/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.evolutionary.mutations;

import java.util.Random;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.evolutionary.interfaces.IMutation;
import org.eclipse.viatra.dse.objectives.TrajectoryFitness;

public class DeleteRandomTransitionMutation
implements IMutation {
    private Random rnd = new Random();

    @Override
    public boolean mutate(TrajectoryFitness parent, ThreadContext context) {
        Object[] trajectory = parent.trajectory;
        int trajectorySize = trajectory.length;
        if (trajectorySize < 1) {
            return false;
        }
        int index = this.rnd.nextInt(trajectorySize);
        context.executeTrajectoryWithMinimalBacktrackWithoutStateCoding(trajectory, index);
        context.executeTrajectoryByTryingWithoutStateCoding(trajectory, index + 1, trajectory.length);
        return true;
    }

    @Override
    public IMutation createNew() {
        return new DeleteRandomTransitionMutation();
    }
}

