/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.bundlor.support.asm;

import org.eclipse.virgo.bundlor.support.partialmanifest.PartialManifest;
import org.objectweb.asm.Type;

final class VisitorUtils {
    VisitorUtils() {
    }

    public static String getPackageName(Type type) {
        if (type.getSort() != 10) {
            if (type.getSort() == 9) {
                return VisitorUtils.getPackageName(type.getElementType());
            }
            return null;
        }
        String name = type.getClassName();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex > -1) {
            return name.substring(0, dotIndex);
        }
        return null;
    }

    public static String getFullyQualifiedTypeName(Type type) {
        if (type.getSort() == 10) {
            return type.getClassName();
        }
        if (type.getSort() == 9) {
            return VisitorUtils.getFullyQualifiedTypeName(type.getElementType());
        }
        return null;
    }

    public static void recordReferencedTypes(PartialManifest partialManifest, Type ... types) {
        Type[] typeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Type t = typeArray[n2];
            partialManifest.recordReferencedType(VisitorUtils.getFullyQualifiedTypeName(t));
            ++n2;
        }
    }

    public static void recordUses(PartialManifest partialManifest, Type exportingType, Type ... types) {
        Type[] typeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Type t = typeArray[n2];
            String packageName = VisitorUtils.getPackageName(t);
            partialManifest.recordUsesPackage(VisitorUtils.getPackageName(exportingType), packageName);
            ++n2;
        }
    }
}

