/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.editors;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipFile;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IWritable;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.plugin.IWritableDelimiter;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.pde.internal.ui.editor.JarEntryEditorInput;
import org.eclipse.pde.internal.ui.editor.JarEntryFile;
import org.eclipse.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.plugin.BundleInputContext;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.virgo.ide.eclipse.editors.AbstractPdeFormPage;
import org.eclipse.virgo.ide.facet.core.FacetUtils;
import org.eclipse.virgo.ide.runtime.core.provisioning.RepositoryUtils;
import org.eclipse.virgo.ide.ui.StatusHandler;
import org.eclipse.virgo.ide.ui.editors.BundleDependenciesPage;
import org.eclipse.virgo.ide.ui.editors.BundleManifestOutlinePage;
import org.eclipse.virgo.ide.ui.editors.BundleOverviewPage;
import org.eclipse.virgo.ide.ui.editors.BundleRuntimePage;
import org.eclipse.virgo.ide.ui.editors.IBundleManifestSaveListener;
import org.eclipse.virgo.ide.ui.editors.PdeCompatibilityUtil;
import org.eclipse.virgo.ide.ui.editors.SpringBundleInputContext;
import org.eclipse.virgo.ide.ui.editors.SpringBundleSourcePage;
import org.eclipse.virgo.kernel.repository.BundleDefinition;
import org.osgi.service.prefs.BackingStoreException;

public class BundleManifestEditor
extends ManifestEditor {
    public static String ID_EDITOR = "org.eclipse.virgo.ide.ui.bundlemanifest";
    protected boolean fEquinox = true;
    protected boolean fShowExtensions = true;
    protected IEclipsePreferences fPrefs;
    protected List<IBundleManifestSaveListener> saveListeners = new ArrayList<IBundleManifestSaveListener>(3);

    public IEditorPart[] getParts() {
        ArrayList<IEditorPart> parts = new ArrayList<IEditorPart>(this.getPageCount());
        if (this.pages != null) {
            int i = 0;
            while (i < this.pages.size()) {
                Object page = this.pages.get(i);
                if (page instanceof IEditorPart) {
                    parts.add((IEditorPart)page);
                }
                ++i;
            }
        }
        return parts.toArray(new IEditorPart[parts.size()]);
    }

    protected void addEditorPages() {
        try {
            BundleOverviewPage overviewPage = new BundleOverviewPage((FormEditor)this);
            this.addPage((IFormPage)overviewPage);
            this.saveListeners.add(overviewPage);
            BundleDependenciesPage dependenciesPage = new BundleDependenciesPage((FormEditor)this);
            this.addPage((IFormPage)dependenciesPage);
            this.saveListeners.add(dependenciesPage);
            BundleRuntimePage runtimePage = new BundleRuntimePage((FormEditor)this);
            this.addPage((IFormPage)runtimePage);
            this.saveListeners.add(runtimePage);
        }
        catch (PartInitException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.virgo.ide.ui", "Failed to create editor pages", (Throwable)e));
        }
        this.addSourcePage("bundle-context");
    }

    protected PDESourcePage createSourcePage(PDEFormEditor editor, String title, String name, String contextId) {
        if (contextId.equals("bundle-context")) {
            return new SpringBundleSourcePage(editor, title, name);
        }
        return super.createSourcePage(editor, title, name, contextId);
    }

    protected void createResourceContexts(InputContextManager manager, IFileEditorInput input) {
        IFile file = input.getFile();
        IContainer container = file.getParent();
        IFile manifestFile = null;
        String name = file.getName().toLowerCase(Locale.ENGLISH);
        if (name.endsWith("mf")) {
            if (container instanceof IFolder) {
                container = container.getParent();
            }
            manifestFile = file;
        }
        if (manifestFile != null && manifestFile.exists()) {
            FileEditorInput in = new FileEditorInput(manifestFile);
            manager.putContext((IEditorInput)in, (InputContext)new SpringBundleInputContext((PDEFormEditor)this, (IEditorInput)in, file == manifestFile));
        }
        manager.monitorFile(manifestFile);
        this.fPrefs = new ProjectScope(container.getProject()).getNode("org.eclipse.pde.core");
        if (this.fPrefs != null) {
            this.fShowExtensions = this.fPrefs.getBoolean("pluginProject.extensions", true);
            this.fEquinox = this.fPrefs.getBoolean("pluginProject.equinox", true);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        for (IBundleManifestSaveListener currListener : this.saveListeners) {
            currListener.manifestSaved();
        }
    }

    public boolean isEquinox() {
        return this.fEquinox;
    }

    public void monitoredFileAdded(IFile file) {
        if (this.fInputContextManager == null) {
            return;
        }
        String name = file.getName();
        if (name.equalsIgnoreCase("MANIFEST.MF") && !this.fInputContextManager.hasContext("bundle-context")) {
            FileEditorInput in = new FileEditorInput(file);
            this.fInputContextManager.putContext((IEditorInput)in, (InputContext)new SpringBundleInputContext((PDEFormEditor)this, (IEditorInput)in, false));
        }
    }

    protected void createInputContexts(InputContextManager contextManager) {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            this.createResourceContexts(contextManager, (IFileEditorInput)input);
        } else if (PdeCompatibilityUtil.isSystemFileEditorInput(input)) {
            this.createSystemFileContexts(contextManager, input);
        } else if (input instanceof IStorageEditorInput) {
            this.createStorageContexts(contextManager, (IStorageEditorInput)input);
        } else if (input instanceof IURIEditorInput) {
            IURIEditorInput uriEditorInput = (IURIEditorInput)input;
            try {
                IFileStore store = EFS.getStore((URI)uriEditorInput.getURI());
                if (!"file".equals(store.getFileSystem().getScheme())) {
                    return;
                }
                IEditorInput sinput = PdeCompatibilityUtil.createSystemFileEditorInput(uriEditorInput);
                if (sinput == null) {
                    sinput = new FileStoreEditorInput(store);
                }
                this.createSystemFileContexts(contextManager, sinput);
            }
            catch (CoreException coreException) {
                return;
            }
        }
    }

    protected void createSystemFileContexts(InputContextManager manager, IEditorInput input) {
        File file = (File)input.getAdapter(File.class);
        if (file == null && input instanceof FileStoreEditorInput) {
            file = new File(((IURIEditorInput)input).getURI());
        }
        if (file == null) {
            return;
        }
        File manifestFile = null;
        String name = file.getName().toLowerCase(Locale.ENGLISH);
        if (name.startsWith("manifest.mf")) {
            manifestFile = file;
        }
        try {
            if (manifestFile != null && manifestFile.exists()) {
                IEditorInput in = PdeCompatibilityUtil.createSystemFileEditorInput(manifestFile);
                if (in == null) {
                    IFileStore store = EFS.getStore((URI)manifestFile.toURI());
                    in = new FileStoreEditorInput(store);
                }
                manager.putContext(in, (InputContext)new SpringBundleInputContext((PDEFormEditor)this, in, file == manifestFile));
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException((Throwable)e);
        }
    }

    protected void createStorageContexts(InputContextManager manager, IStorageEditorInput input) {
        if (input instanceof JarEntryEditorInput) {
            this.createJarEntryContexts(manager, (JarEntryEditorInput)input);
            return;
        }
        String name = input.getName().toLowerCase(Locale.ENGLISH);
        if (name.startsWith("manifest.mf")) {
            manager.putContext((IEditorInput)input, (InputContext)new SpringBundleInputContext((PDEFormEditor)this, (IEditorInput)input, true));
        }
    }

    protected void createJarEntryContexts(InputContextManager manager, JarEntryEditorInput input) {
        ZipFile zip;
        IStorage storage;
        block13: {
            storage = input.getStorage();
            zip = (ZipFile)storage.getAdapter(ZipFile.class);
            try {
                if (zip != null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (zip != null) {
                        zip.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (zip != null) {
                    zip.close();
                }
            }
            catch (IOException iOException) {}
            return;
        }
        if (zip.getEntry("META-INF/MANIFEST.MF") != null) {
            input = new JarEntryEditorInput((IStorage)new JarEntryFile(zip, "META-INF/MANIFEST.MF"));
            manager.putContext((IEditorInput)input, (InputContext)new SpringBundleInputContext((PDEFormEditor)this, (IEditorInput)input, storage.getName().equals("MANIFEST.MF")));
        }
        try {
            if (zip != null) {
                zip.close();
            }
        }
        catch (IOException iOException) {}
    }

    protected void setShowExtensions(boolean show) throws BackingStoreException {
        if (this.fPrefs != null) {
            this.fPrefs.putBoolean("pluginProject.extensions", show);
            this.fPrefs.flush();
        }
        this.fShowExtensions = show;
    }

    public boolean showExtensionTabs() {
        if (this.fInputContextManager.hasContext("plugin-context")) {
            return true;
        }
        IBaseModel model = this.getAggregateModel();
        return this.fShowExtensions && model != null && model.isEditable();
    }

    public String getTitle() {
        IPluginModelBase model = (IPluginModelBase)this.getAggregateModel();
        if (model == null || !model.isValid()) {
            return super.getTitle();
        }
        String text = this.getTitleText(model);
        if (text == null) {
            return super.getTitle();
        }
        return model.getResourceString(text);
    }

    private String getTitleText(IPluginModelBase model) {
        BundleInputContext context;
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        String pref = store.getString("Preferences.MainPage.showObjects");
        StringBuilder builder = new StringBuilder();
        if (model.getUnderlyingResource() != null) {
            if (model.getUnderlyingResource().getName().equals("TEST.MF")) {
                builder.append("test: ");
            } else if (model.getUnderlyingResource().getName().equals("template.mf")) {
                builder.append("template: ");
            }
        }
        if (FacetUtils.isParProject((IResource)this.getCommonProject()) && (context = (BundleInputContext)this.getContextManager().findContext("bundle-context")) != null) {
            IBundleModel bundleModel = (IBundleModel)context.getModel();
            if (pref != null && pref.equals("useNames")) {
                builder.append(bundleModel.getBundle().getHeader("Application-Name"));
            }
            builder.append(bundleModel.getBundle().getHeader("Application-SymbolicName"));
        }
        if (pref != null && pref.equals("useNames") && model.getPluginBase().getName() != null) {
            builder.append(model.getPluginBase().getName());
        }
        if (model.getPluginBase().getId() != null) {
            builder.append(model.getPluginBase().getId());
        }
        return builder.toString();
    }

    protected ISortableContentOutlinePage createContentOutline() {
        return new BundleManifestOutlinePage((PDEFormEditor)this);
    }

    public static IEditorPart openBundleEditor(String bundle, String version, IProject project) {
        return BundleManifestEditor.openPluginEditor(RepositoryUtils.getBundleDefinition((String)bundle, (String)version, (IProject)project));
    }

    public static IEditorPart openPluginEditor(BundleDefinition bundleDefinition) {
        if (bundleDefinition == null) {
            Display.getDefault().beep();
            return null;
        }
        return BundleManifestEditor.openPluginEditor(bundleDefinition, false);
    }

    public static IEditorPart openPluginEditor(Object object, boolean source) {
        if (object instanceof BundleDefinition) {
            URI file = ((BundleDefinition)object).getLocation();
            return BundleManifestEditor.openExternalPlugin(new File(file), "META-INF/MANIFEST.MF");
        }
        return null;
    }

    public static IEditorPart openExternalPlugin(File location, String filename) {
        JarEntryEditorInput input = null;
        if (location.isFile()) {
            try {
                ZipFile zipFile = new ZipFile(location);
                if (zipFile.getEntry(filename) != null) {
                    input = new JarEntryEditorInput((IStorage)new JarEntryFile(zipFile, filename));
                }
            }
            catch (IOException iOException) {}
        } else {
            File file = new File(location, filename);
            if (file.exists()) {
                try {
                    IFileStore store = EFS.getStore((URI)file.toURI());
                    input = new FileStoreEditorInput(store);
                }
                catch (CoreException coreException) {}
            }
        }
        return BundleManifestEditor.openEditor(input);
    }

    public static IEditorPart openEditor(IEditorInput input) {
        if (input != null) {
            try {
                return PDEPlugin.getActivePage().openEditor(input, ID_EDITOR);
            }
            catch (PartInitException e) {
                PDEPlugin.logException((Throwable)e);
            }
        }
        return null;
    }

    public void contributeToToolbar(IToolBarManager manager) {
    }

    protected void performGlobalAction(String id) {
        ISelection selection = this.getSelection();
        IFormPage page = this.getActivePageInstance();
        if (page instanceof AbstractPdeFormPage) {
            boolean handled = ((AbstractPdeFormPage)page).performGlobalAction(id);
            if (!handled) {
                if (id.equals(ActionFactory.UNDO.getId())) {
                    this.fInputContextManager.undo();
                    return;
                }
                if (id.equals(ActionFactory.REDO.getId())) {
                    this.fInputContextManager.redo();
                    return;
                }
                if (id.equals(ActionFactory.CUT.getId()) || id.equals(ActionFactory.COPY.getId())) {
                    this.copyToClipboard(selection);
                    return;
                }
            }
        } else {
            super.performGlobalAction(id);
        }
    }

    private void copyToClipboard(ISelection selection) {
        Object[] objects = null;
        String textVersion = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            if (ssel == null || ssel.size() == 0) {
                return;
            }
            objects = ssel.toArray();
            StringWriter writer = new StringWriter();
            PrintWriter pwriter = new PrintWriter(writer);
            Class<?> objClass = null;
            int i = 0;
            while (i < objects.length) {
                Object obj = objects[i];
                if (objClass == null) {
                    objClass = obj.getClass();
                } else if (!objClass.equals(obj.getClass())) {
                    return;
                }
                if (obj instanceof IWritable) {
                    if (i != 0 && obj instanceof IWritableDelimiter) {
                        ((IWritableDelimiter)obj).writeDelimeter(pwriter);
                    }
                    ((IWritable)obj).write("", pwriter);
                } else if (obj instanceof String) {
                    pwriter.println((String)obj);
                }
                ++i;
            }
            pwriter.flush();
            textVersion = writer.toString();
            try {
                pwriter.close();
                writer.close();
            }
            catch (IOException iOException) {}
        } else if (selection instanceof ITextSelection) {
            textVersion = ((ITextSelection)selection).getText();
        }
        if ((textVersion == null || textVersion.length() == 0) && objects == null) {
            return;
        }
        Object[] o = null;
        Transfer[] t = null;
        if (objects == null) {
            o = new Object[]{textVersion};
            t = new Transfer[]{TextTransfer.getInstance()};
        } else if (textVersion == null || textVersion.length() == 0) {
            o = new Object[]{objects};
            t = new Transfer[]{ModelDataTransfer.getInstance()};
        } else {
            o = new Object[]{objects, textVersion};
            t = new Transfer[]{ModelDataTransfer.getInstance(), TextTransfer.getInstance()};
        }
        this.getClipboard().setContents(o, t);
    }
}

