/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.internal.ui.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.virgo.ide.runtime.core.IServerWorkingCopy;
import org.eclipse.virgo.ide.runtime.core.ServerCorePlugin;
import org.eclipse.virgo.ide.runtime.core.artefacts.Artefact;
import org.eclipse.virgo.ide.runtime.core.artefacts.ArtefactRepository;
import org.eclipse.virgo.ide.runtime.core.artefacts.ArtefactRepositoryManager;
import org.eclipse.virgo.ide.runtime.core.artefacts.BundleArtefact;
import org.eclipse.virgo.ide.runtime.core.artefacts.IArtefact;
import org.eclipse.virgo.ide.runtime.core.artefacts.IArtefactTyped;
import org.eclipse.virgo.ide.runtime.core.artefacts.LibraryArtefact;
import org.eclipse.virgo.ide.runtime.core.artefacts.LocalBundleArtefact;
import org.eclipse.virgo.ide.runtime.core.provisioning.IBundleRepositoryChangeListener;
import org.eclipse.virgo.ide.runtime.core.provisioning.RepositoryProvisioningJob;
import org.eclipse.virgo.ide.runtime.core.provisioning.RepositorySourceProvisiongJob;
import org.eclipse.virgo.ide.runtime.core.provisioning.RepositoryUtils;
import org.eclipse.virgo.ide.runtime.internal.ui.ServerUiImages;
import org.eclipse.virgo.ide.runtime.internal.ui.ServerUiPlugin;
import org.eclipse.virgo.ide.runtime.internal.ui.editor.Messages;
import org.eclipse.virgo.ide.runtime.internal.ui.editor.WebUiUtils;
import org.eclipse.virgo.ide.runtime.internal.ui.providers.RepositorySearchResultContentProvider;
import org.eclipse.virgo.ide.runtime.internal.ui.providers.RuntimeLabelProvider;
import org.eclipse.virgo.ide.runtime.internal.ui.repository.RefreshBundleJob;
import org.eclipse.virgo.ide.runtime.internal.ui.sorters.RepositoryViewerSorter;
import org.eclipse.virgo.ide.ui.editors.BundleManifestEditor;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.ui.editor.ServerEditorPart;

public class RepositoryBrowserEditorPage
extends ServerEditorPart
implements ISelectionChangedListener {
    private static final DateFormat dateFormat = DateFormat.getDateInstance(1, Locale.getDefault());
    private Button anaylseButton;
    private Button downloadButton;
    private Button downloadSourcesCheckbox;
    private final IJobChangeListener jobListener = new ArtefactOperationJobListener();
    private IServerWorkingCopy serverWC;
    private Button refreshButton;
    private PropertyChangeListener propertyListener;
    private final RepositorySearchResultContentProvider searchResultContentProvider = new RepositorySearchResultContentProvider();
    private final ColoredRespositoryLabelProvider coloredRespositoryLabelProvider = new ColoredRespositoryLabelProvider();
    private CommonViewer repositoryTableViewer;
    private Button searchButton;
    private Button downloadSourcesButton;
    private Tree searchResultTable;
    private CheckboxTreeViewer searchResultTableViewer;
    private Text searchText;
    private Shell shell;
    private Button licenseButton;
    private Button openManifestButton;
    private Link update;
    private IBundleRepositoryChangeListener repositoryListener;
    private static String PROXY_PREF_PAGE_ID = Messages.RepositoryBrowserEditorPage_0;

    public void createPartControl(Composite parent) {
        this.shell = parent.getShell();
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        ScrolledForm form = toolkit.createScrolledForm(parent);
        toolkit.decorateFormHeading(form.getForm());
        form.setText(Messages.RepositoryBrowserEditorPage_BundleBrowserLabel);
        form.setImage(this.getFormImage());
        GridLayout layout = new GridLayout(2, true);
        layout.marginTop = 6;
        layout.marginLeft = 6;
        form.getBody().setLayout((Layout)layout);
        Section leftSection = this.createLeftSection(toolkit, form);
        this.createRightSection(toolkit, form);
        form.setContent((Control)leftSection);
        this.initialize();
    }

    protected Image getFormImage() {
        return ServerUiImages.getImage("org.eclipse.virgo.ide.runtime.ui.virgo_obj.png");
    }

    public void dispose() {
        super.dispose();
        if (this.serverWC != null) {
            this.serverWC.removeConfigurationChangeListener(this.propertyListener);
        }
        Job.getJobManager().removeJobChangeListener(this.jobListener);
        ServerCorePlugin.getArtefactRepositoryManager().removeBundleRepositoryChangeListener(this.repositoryListener);
    }

    public void init(IEditorSite site, IEditorInput input) {
        IServerWorkingCopy ts;
        super.init(site, input);
        this.serverWC = ts = (IServerWorkingCopy)this.server.loadAdapter(IServerWorkingCopy.class, null);
        this.addListeners();
        this.initialize();
    }

    public void setFocus() {
        if (this.searchResultTable != null) {
            this.searchResultTable.setFocus();
        }
    }

    private Section createLeftSection(FormToolkit toolkit, ScrolledForm form) {
        Section leftSection = toolkit.createSection(form.getBody(), 384);
        leftSection.setText(Messages.RepositoryBrowserEditorPage_SearchBundlesAndLibraries);
        leftSection.setDescription(Messages.RepositoryBrowserEditorPage_SearchBundlesAndLibrariesByName);
        leftSection.setLayoutData((Object)new GridData(1808));
        Composite leftComposite = toolkit.createComposite((Composite)leftSection);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        leftComposite.setLayout((Layout)layout);
        leftComposite.setLayoutData((Object)new GridData(1808));
        toolkit.paintBordersFor(leftComposite);
        leftSection.setClient((Control)leftComposite);
        this.searchText = toolkit.createText(leftComposite, Messages.RepositoryBrowserEditorPage_4);
        GridData data = new GridData(768);
        this.searchText.setLayoutData((Object)data);
        this.searchText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r' || e.character == '\n') {
                    RepositoryBrowserEditorPage.this.handleSearch();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        Composite searchButtonComposite = new Composite(leftComposite, 0);
        searchButtonComposite.setLayout((Layout)new GridLayout(1, true));
        data = new GridData(2);
        searchButtonComposite.setLayoutData((Object)data);
        this.searchButton = toolkit.createButton(searchButtonComposite, Messages.RepositoryBrowserEditorPage_Search, 8);
        this.searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositoryBrowserEditorPage.this.handleSearch();
            }
        });
        data = new GridData(768);
        data.widthHint = 100;
        this.searchButton.setLayoutData((Object)data);
        this.searchResultTable = toolkit.createTree(leftComposite, 66082);
        this.searchResultTableViewer = new CheckboxTreeViewer(this.searchResultTable);
        this.searchResultTableViewer.setContentProvider((IContentProvider)this.searchResultContentProvider);
        this.searchResultTableViewer.setLabelProvider((IBaseLabelProvider)this.coloredRespositoryLabelProvider);
        this.searchResultTableViewer.setInput((Object)this);
        this.searchResultTableViewer.setSorter((ViewerSorter)new RepositoryViewerSorter());
        this.searchResultTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                RepositoryBrowserEditorPage.this.handleCheckStateChange(event);
                RepositoryBrowserEditorPage.this.downloadButton.setEnabled(RepositoryBrowserEditorPage.this.searchResultTableViewer.getCheckedElements().length > 0);
            }
        });
        this.searchResultTableViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                final Object element = event.getElement();
                if (!RepositoryBrowserEditorPage.this.searchResultTableViewer.getGrayed(element)) {
                    BusyIndicator.showWhile((Display)RepositoryBrowserEditorPage.this.shell.getDisplay(), (Runnable)new Runnable(){

                        public void run() {
                            RepositoryBrowserEditorPage.this.setSubtreeChecked(element, RepositoryBrowserEditorPage.this.searchResultTableViewer.getChecked(element), false);
                        }
                    });
                }
            }
        });
        this.registerContextMenu((StructuredViewer)this.searchResultTableViewer);
        data = new GridData(1808);
        data.heightHint = 120;
        this.searchResultTable.setLayoutData((Object)data);
        this.searchResultTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = RepositoryBrowserEditorPage.this.searchResultTableViewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object element = ((IStructuredSelection)selection).getFirstElement();
                    if (element instanceof IArtefact) {
                        RepositoryBrowserEditorPage.this.anaylseButton.setEnabled(true);
                        RepositoryBrowserEditorPage.this.licenseButton.setEnabled(true);
                    } else {
                        RepositoryBrowserEditorPage.this.anaylseButton.setEnabled(false);
                        RepositoryBrowserEditorPage.this.licenseButton.setEnabled(false);
                    }
                }
            }
        });
        Composite buttonComposite = new Composite(leftComposite, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, true));
        data = new GridData(2);
        buttonComposite.setLayoutData((Object)data);
        data = new GridData(768);
        data.widthHint = 100;
        Button selectAllButton = toolkit.createButton(buttonComposite, Messages.RepositoryBrowserEditorPage_SelectAll, 8);
        selectAllButton.setLayoutData((Object)data);
        selectAllButton.setToolTipText(Messages.RepositoryBrowserEditorPage_SelectAllBundlesAndLibraries);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RepositoryBrowserEditorPage.this.searchResultTableViewer.setCheckedElements(RepositoryBrowserEditorPage.this.searchResultContentProvider.getElements(RepositoryBrowserEditorPage.this.searchResultTableViewer.getInput()));
            }
        });
        Button deselectAllButton = toolkit.createButton(buttonComposite, Messages.RepositoryBrowserEditorPage_DeselectAllBundlesAndLibraries, 8);
        deselectAllButton.setToolTipText(Messages.RepositoryBrowserEditorPage_9);
        deselectAllButton.setLayoutData((Object)data);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RepositoryBrowserEditorPage.this.searchResultTableViewer.setCheckedElements(new Object[0]);
            }
        });
        toolkit.createLabel(buttonComposite, Messages.RepositoryBrowserEditorPage_10);
        this.anaylseButton = toolkit.createButton(buttonComposite, Messages.RepositoryBrowserEditorPage_Analyse, 8);
        this.anaylseButton.setEnabled(false);
        this.anaylseButton.setLayoutData((Object)data);
        this.anaylseButton.setToolTipText(Messages.RepositoryBrowserEditorPage_AnalyseSelected);
        this.anaylseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object element;
                ISelection selection = RepositoryBrowserEditorPage.this.searchResultTableViewer.getSelection();
                if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IArtefact) {
                    WebUiUtils.openUrl(RepositoryUtils.getRepositoryUrl((IArtefact)((IArtefact)element)));
                }
            }
        });
        this.licenseButton = toolkit.createButton(buttonComposite, Messages.RepositoryBrowserEditorPage_ViewLicense, 8);
        this.licenseButton.setEnabled(false);
        this.licenseButton.setLayoutData((Object)data);
        this.licenseButton.setToolTipText(Messages.RepositoryBrowserEditorPage_OpenLicense);
        this.licenseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ISelection selection = RepositoryBrowserEditorPage.this.searchResultTableViewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object element = ((IStructuredSelection)selection).getFirstElement();
                    if (element instanceof LibraryArtefact) {
                        WebUiUtils.openUrl(RepositoryUtils.getResourceUrl((LibraryArtefact)((LibraryArtefact)element), (String)"license"));
                    } else if (element instanceof BundleArtefact) {
                        WebUiUtils.openUrl(RepositoryUtils.getResourceUrl((BundleArtefact)((BundleArtefact)element), (String)"license"));
                    }
                }
            }
        });
        toolkit.createLabel(buttonComposite, "");
        this.downloadButton = toolkit.createButton(buttonComposite, Messages.RepositoryBrowserEditorPage_Download, 8);
        this.downloadButton.setEnabled(false);
        this.downloadButton.setLayoutData((Object)data);
        this.downloadButton.setToolTipText(Messages.RepositoryBrowserEditorPage_DownloadSelected);
        this.downloadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object[] selections;
                LinkedHashSet<Artefact> artifacts = new LinkedHashSet<Artefact>();
                Object[] objectArray = selections = RepositoryBrowserEditorPage.this.searchResultTableViewer.getCheckedElements();
                int n = selections.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selection = objectArray[n2];
                    if (selection instanceof IArtefact) {
                        artifacts.add((Artefact)selection);
                    }
                    ++n2;
                }
                boolean showDialog = ServerUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.virgo.ide.runtime.ui.download.message");
                if (!showDialog) {
                    MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)RepositoryBrowserEditorPage.this.shell, (String)Messages.RepositoryBrowserEditorPage_DownloadBundlesAndLibraries, (String)Messages.RepositoryBrowserEditorPage_DownloadTriggerMessage, (String)Messages.RepositoryBrowserEditorPage_DontShowDialog, (boolean)false, (IPreferenceStore)ServerUiPlugin.getDefault().getPreferenceStore(), (String)"org.eclipse.virgo.ide.runtime.ui.download.message");
                    if (dialog.getReturnCode() != 0) {
                        return;
                    }
                    ServerUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.virgo.ide.runtime.ui.download.message", new Boolean(dialog.getToggleState()).booleanValue());
                }
                HashSet<IRuntime> runtimes = new HashSet<IRuntime>();
                runtimes.add(RepositoryBrowserEditorPage.this.getServer().getRuntime());
                RepositoryProvisioningJob operation = new RepositoryProvisioningJob(runtimes, RepositoryUtils.resolveDependencies(artifacts, (boolean)false), RepositoryBrowserEditorPage.this.downloadSourcesCheckbox.getSelection());
                operation.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ServerUiImages.DESC_OBJ_BUNDLE);
                operation.schedule();
                RepositoryBrowserEditorPage.this.searchResultTableViewer.setCheckedElements(new Object[0]);
                RepositoryBrowserEditorPage.this.downloadButton.setEnabled(false);
            }
        });
        TableWrapLayout twLayout = new TableWrapLayout();
        twLayout.bottomMargin = 0;
        twLayout.topMargin = 0;
        twLayout.leftMargin = 0;
        twLayout.rightMargin = 0;
        Composite wrappedComposite = toolkit.createComposite(leftComposite);
        wrappedComposite.setLayout((Layout)twLayout);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)wrappedComposite);
        this.downloadSourcesCheckbox = toolkit.createButton(wrappedComposite, Messages.RepositoryBrowserEditorPage_DownloadSourceJars, 96);
        this.downloadSourcesCheckbox.setSelection(true);
        this.downloadSourcesCheckbox.setLayoutData((Object)new TableWrapData(2, 16));
        Link repoLink = new Link(wrappedComposite, 64);
        repoLink.setText(Messages.RepositoryBrowserEditorPage_SourceReposMessage);
        repoLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebUiUtils.openUrl(Messages.RepositoryBrowserEditorPage_SourceRepos);
            }
        });
        repoLink.setLayoutData((Object)new TableWrapData(2, 16));
        this.update = new Link(wrappedComposite, 64);
        this.update.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openQuestion((Shell)RepositoryBrowserEditorPage.this.shell, (String)Messages.RepositoryBrowserEditorPage_UpdateLocalBundles, (String)Messages.RepositoryBrowserEditorPage_ConfirmIndexMessage)) {
                    ServerCorePlugin.getArtefactRepositoryManager().update();
                }
            }
        });
        this.setRepositoryDateString();
        this.update.setLayoutData((Object)new TableWrapData(2, 16));
        Hyperlink disclaimer = toolkit.createHyperlink(wrappedComposite, Messages.RepositoryBrowserEditorPage_FirewallConfigureMessage, 64);
        disclaimer.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)PROXY_PREF_PAGE_ID, null, null);
                dialog.open();
            }
        });
        disclaimer.setLayoutData((Object)new TableWrapData(2, 16));
        return leftSection;
    }

    protected void registerContextMenu(StructuredViewer viewer) {
        MenuManager searchResultManager = new MenuManager();
        Menu searchResultPopup = searchResultManager.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(searchResultPopup);
        this.getSite().registerContextMenu(searchResultManager, (ISelectionProvider)viewer);
    }

    private void setRepositoryDateString() {
        Date date = ServerCorePlugin.getArtefactRepositoryManager().getArtefactRepositoryDate();
        String dateString = dateFormat.format(date);
        this.update.setText(String.valueOf(Messages.RepositoryBrowserEditorPage_UpdateURL) + dateString + ")");
    }

    protected String getServerName() {
        return Messages.RepositoryBrowserEditorPage_ServerName;
    }

    private Section createRightSection(FormToolkit toolkit, ScrolledForm form) {
        Section leftSection = toolkit.createSection(form.getBody(), 384);
        leftSection.setText(Messages.RepositoryBrowserEditorPage_BundlesAndLibraries);
        leftSection.setDescription(String.valueOf(Messages.RepositoryBrowserEditorPage_BundlesAndLibrariesMessage) + this.getServerName() + ". " + Messages.RepositoryBrowserEditorPage_BundlesAndLibrariesProviso);
        leftSection.setLayoutData((Object)new GridData(1808));
        Composite leftComposite = toolkit.createComposite((Composite)leftSection);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        leftComposite.setLayout((Layout)layout);
        leftComposite.setLayoutData((Object)new GridData(1808));
        toolkit.paintBordersFor(leftComposite);
        leftSection.setClient((Control)leftComposite);
        GridData data = new GridData(768);
        Composite composite2 = toolkit.createComposite(leftComposite);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        composite2.setLayout((Layout)layout);
        composite2.setLayoutData((Object)new GridData(1808));
        toolkit.paintBordersFor(composite2);
        this.repositoryTableViewer = new CommonViewer("org.eclipse.virgo.ide.runtime.ui.ArtefactsBrowserView", composite2, 2052);
        this.repositoryTableViewer.setSorter((ViewerSorter)new RepositoryViewerSorter());
        this.registerContextMenu((StructuredViewer)this.repositoryTableViewer);
        data = new GridData(1808);
        data.heightHint = 120;
        this.repositoryTableViewer.getControl().setLayoutData((Object)data);
        Composite buttonComposite = new Composite(composite2, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, true));
        data = new GridData(2);
        buttonComposite.setLayoutData((Object)data);
        data = new GridData(768);
        data.widthHint = 100;
        this.refreshButton = toolkit.createButton(buttonComposite, Messages.RepositoryBrowserEditorPage_Refresh, 8);
        this.refreshButton.setLayoutData((Object)data);
        this.refreshButton.setToolTipText(Messages.RepositoryBrowserEditorPage_RefreshMessage);
        this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RepositoryBrowserEditorPage.this.refreshBundleRepository();
            }
        });
        this.downloadSourcesButton = toolkit.createButton(buttonComposite, Messages.RepositoryBrowserEditorPage_InstallSources, 8);
        this.downloadSourcesButton.setLayoutData((Object)data);
        this.downloadSourcesButton.setToolTipText(Messages.RepositoryBrowserEditorPage_InstallSourcesMessage);
        this.downloadSourcesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RepositoryBrowserEditorPage.this.downloadSources();
            }
        });
        toolkit.createLabel(buttonComposite, Messages.RepositoryBrowserEditorPage_40);
        this.openManifestButton = toolkit.createButton(buttonComposite, Messages.RepositoryBrowserEditorPage_OpenManifest, 8);
        this.openManifestButton.setLayoutData((Object)data);
        this.openManifestButton.setToolTipText(Messages.RepositoryBrowserEditorPage_OpenManifestMessage);
        this.openManifestButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object element;
                ISelection selection = RepositoryBrowserEditorPage.this.repositoryTableViewer.getSelection();
                if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IPackageFragmentRoot) {
                    IPackageFragmentRoot fragment = (IPackageFragmentRoot)element;
                    BundleManifestEditor.openExternalPlugin((File)fragment.getPath().toFile(), (String)"META-INF/MANIFEST.MF");
                }
            }
        });
        this.openManifestButton.setEnabled(false);
        this.repositoryTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object element = ((IStructuredSelection)selection).getFirstElement();
                    if (element instanceof IPackageFragmentRoot) {
                        RepositoryBrowserEditorPage.this.openManifestButton.setEnabled(true);
                    } else {
                        RepositoryBrowserEditorPage.this.openManifestButton.setEnabled(false);
                    }
                }
            }
        });
        TableWrapLayout twLayout = new TableWrapLayout();
        twLayout.bottomMargin = 0;
        twLayout.topMargin = 0;
        twLayout.leftMargin = 0;
        twLayout.rightMargin = 0;
        Composite wrappedComposite = toolkit.createComposite(leftComposite);
        wrappedComposite.setLayout((Layout)twLayout);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)wrappedComposite);
        Link repoLink = new Link(wrappedComposite, 64);
        repoLink.setText(Messages.RepositoryBrowserEditorPage_NewBundlesMessage);
        repoLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositoryBrowserEditorPage.this.refreshBundleRepository();
            }
        });
        repoLink.setLayoutData((Object)new TableWrapData(2, 16));
        return leftSection;
    }

    private void refreshBundleRepository() {
        RefreshBundleJob.execute(this.shell, this.getServer().getRuntime());
    }

    protected void downloadSources() {
        LinkedHashSet<LocalBundleArtefact> artifacts = new LinkedHashSet<LocalBundleArtefact>();
        ArtefactRepository repository = RepositoryUtils.getRepositoryContents((IRuntime)this.server.getRuntime());
        for (IArtefactTyped bundle : repository.getBundles()) {
            if (!(bundle instanceof LocalBundleArtefact) || ((LocalBundleArtefact)bundle).isSourceDownloaded()) continue;
            artifacts.add((LocalBundleArtefact)bundle);
        }
        HashSet<IRuntime> runtimes = new HashSet<IRuntime>();
        runtimes.add(this.getServer().getRuntime());
        RepositorySourceProvisiongJob operation = new RepositorySourceProvisiongJob(runtimes, artifacts);
        operation.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ServerUiImages.DESC_OBJ_BUNDLE);
        operation.schedule();
    }

    private void handleCheckStateChange(final CheckStateChangedEvent event) {
        BusyIndicator.showWhile((Display)this.shell.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                boolean state = event.getChecked();
                RepositoryBrowserEditorPage.this.setSubtreeChecked(event.getElement(), state, true);
                RepositoryBrowserEditorPage.this.updateParentState(event.getElement());
            }
        });
    }

    private void setSubtreeChecked(Object container, boolean state, boolean checkExpandedState) {
        Object[] members = this.searchResultContentProvider.getChildren(container);
        int i = members.length - 1;
        while (i >= 0) {
            boolean elementGrayChecked;
            Object element = members[i];
            boolean bl = elementGrayChecked = this.searchResultTableViewer.getGrayed(element) || this.searchResultTableViewer.getChecked(element);
            if (state) {
                this.searchResultTableViewer.setChecked(element, true);
                this.searchResultTableViewer.setGrayed(element, false);
            } else {
                this.searchResultTableViewer.setGrayChecked(element, false);
            }
            if (state || elementGrayChecked) {
                this.setSubtreeChecked(element, state, true);
            }
            --i;
        }
    }

    private void updateParentState(Object child) {
        if (child == null || this.searchResultContentProvider.getParent(child) == null) {
            return;
        }
        Object parent = this.searchResultContentProvider.getParent(child);
        boolean childChecked = false;
        Object[] members = this.searchResultContentProvider.getChildren(parent);
        int i = members.length - 1;
        while (i >= 0) {
            if (this.searchResultTableViewer.getChecked(members[i]) || this.searchResultTableViewer.getGrayed(members[i])) {
                childChecked = true;
                break;
            }
            --i;
        }
        this.searchResultTableViewer.setGrayChecked(parent, childChecked);
        this.updateParentState(parent);
    }

    protected void addListeners() {
        this.propertyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
            }
        };
        this.serverWC.addConfigurationChangeListener(this.propertyListener);
        Job.getJobManager().addJobChangeListener(this.jobListener);
        this.repositoryListener = new IBundleRepositoryChangeListener(){

            public void bundleRepositoryChanged(IRuntime runtime) {
                RepositoryBrowserEditorPage.this.refreshViewers();
            }
        };
        ServerCorePlugin.getArtefactRepositoryManager().addBundleRepositoryChangeListener(this.repositoryListener);
    }

    protected void handleSearch() {
        String search = this.searchText.getText();
        this.searchResultTableViewer.setInput((Object)RepositoryUtils.searchForArtifacts((String)search));
        this.searchResultTableViewer.expandToLevel(2);
    }

    protected void initialize() {
        if (this.searchResultTable == null) {
            return;
        }
        this.searchResultTable.removeAll();
        this.setErrorMessage(null);
        this.intializeViewers();
    }

    protected void intializeViewers() {
        this.shell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                RepositoryBrowserEditorPage.this.repositoryTableViewer.setInput((Object)RepositoryBrowserEditorPage.this.getServer());
                RepositoryBrowserEditorPage.this.repositoryTableViewer.expandToLevel(2);
                RepositoryBrowserEditorPage.this.searchResultTableViewer.refresh(true);
                RepositoryBrowserEditorPage.this.searchResultTableViewer.expandToLevel(2);
            }
        });
    }

    protected void refreshViewers() {
        this.shell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                ISelection selection = RepositoryBrowserEditorPage.this.repositoryTableViewer.getSelection();
                RepositoryBrowserEditorPage.this.repositoryTableViewer.refresh();
                RepositoryBrowserEditorPage.this.repositoryTableViewer.setSelection(selection);
                RepositoryBrowserEditorPage.this.searchResultTableViewer.refresh(true);
            }
        });
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ISelectionChangedListener.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        this.repositoryTableViewer.setSelection((ISelection)sel, true);
        this.repositoryTableViewer.expandToLevel(sel.getFirstElement(), -1);
    }

    private final class ArtefactOperationJobListener
    extends JobChangeAdapter {
        private ArtefactOperationJobListener() {
        }

        public void done(IJobChangeEvent event) {
            if (event.getJob() instanceof RepositoryProvisioningJob) {
                if (((RepositoryProvisioningJob)event.getJob()).getRuntimes().contains(RepositoryBrowserEditorPage.this.getServer().getRuntime())) {
                    RepositoryBrowserEditorPage.this.refreshViewers();
                }
            } else if (event.getJob() instanceof ArtefactRepositoryManager.ArtefactRepositoryUpdateJob) {
                RepositoryBrowserEditorPage.this.shell.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        RepositoryBrowserEditorPage.this.setRepositoryDateString();
                    }
                });
            }
        }
    }

    private class ColoredRespositoryLabelProvider
    extends RuntimeLabelProvider
    implements IColorProvider {
        private ColoredRespositoryLabelProvider() {
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            ArtefactRepository repository = RepositoryUtils.getRepositoryContents((IRuntime)RepositoryBrowserEditorPage.this.server.getRuntime());
            if (repository != null && element instanceof Artefact && repository.contains((IArtefact)element)) {
                return Display.getCurrent().getSystemColor(16);
            }
            return null;
        }
    }
}

