/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.editor.ui.internal.overview;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.libra.framework.editor.core.IOSGiFrameworkAdmin;
import org.eclipse.libra.framework.editor.core.model.IBundle;
import org.eclipse.libra.framework.editor.ui.internal.EditorUIPlugin;
import org.eclipse.libra.framework.editor.ui.internal.overview.BundleInformationMasterDetailsBlock;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.internal.ide.StringMatcher;

public class BundleInformationMasterPart
extends SectionPart {
    private static final String TYPE_FILTER_TEXT = "type filter text";
    private final FormToolkit toolkit;
    StructuredViewer bundleTableViewer;
    Table bundleTable;
    private Button startButton;
    private Button stopButton;
    private Button refreshButton;
    private Button updateButton;
    Text filterText;
    TableColumn idColumn;
    TableColumn symbolicNameColumn;
    TableColumn statusColumn;
    final BundleInformationMasterDetailsBlock masterDetailsBlock;

    public BundleInformationMasterPart(Composite parent, FormToolkit toolkit, int style, BundleInformationMasterDetailsBlock masterDetailsBlock) {
        super(parent, toolkit, style);
        this.toolkit = toolkit;
        this.masterDetailsBlock = masterDetailsBlock;
    }

    protected void createContents() {
        Section section = this.getSection();
        section.setText("Bundle Status");
        section.setDescription("Information about installed bundles on server.");
        section.setLayoutData((Object)new GridData(770));
        this.createSectionToolbar(section);
        Composite composite = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(770));
        this.toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        this.filterText = this.toolkit.createText(composite, TYPE_FILTER_TEXT, 384);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BundleInformationMasterPart.this.bundleTableViewer.refresh();
            }
        });
        GridData data = new GridData(770);
        this.filterText.setLayoutData((Object)data);
        this.toolkit.createLabel(composite, "", 0);
        this.bundleTable = this.toolkit.createTable(composite, 66308);
        data = new GridData(770);
        data.heightHint = 550;
        this.bundleTable.setLayoutData((Object)data);
        this.bundleTable.setLinesVisible(true);
        TableColumn imageColumn = new TableColumn(this.bundleTable, 16384);
        imageColumn.setWidth(23);
        this.idColumn = new TableColumn(this.bundleTable, 131072);
        this.idColumn.setText("Id");
        this.idColumn.setWidth(50);
        this.idColumn.addListener(13, (Listener)new SortingListener());
        this.symbolicNameColumn = new TableColumn(this.bundleTable, 16384);
        this.symbolicNameColumn.setText("Symbolic-Name");
        this.symbolicNameColumn.setWidth(280);
        this.symbolicNameColumn.addListener(13, (Listener)new SortingListener());
        this.statusColumn = new TableColumn(this.bundleTable, 0x1000000);
        this.statusColumn.setText("Status");
        this.statusColumn.setWidth(70);
        this.statusColumn.addListener(13, (Listener)new SortingListener());
        this.bundleTableViewer = new TableViewer(this.bundleTable);
        this.bundleTableViewer.setContentProvider((IContentProvider)new BundleStatusContentProvider());
        this.bundleTableViewer.setLabelProvider((IBaseLabelProvider)new BundleStatusLabelProvider());
        this.bundleTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BundleInformationMasterPart.this.getManagedForm().fireSelectionChanged((IFormPart)BundleInformationMasterPart.this, event.getSelection());
            }
        });
        this.bundleTableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IBundle && BundleInformationMasterPart.this.filterText.getText().length() > 0 && !BundleInformationMasterPart.TYPE_FILTER_TEXT.equals(BundleInformationMasterPart.this.filterText.getText())) {
                    StringMatcher matcher = new StringMatcher(String.valueOf(BundleInformationMasterPart.this.filterText.getText()) + "*", true, false);
                    return matcher.match(((IBundle)element).getSymbolicName());
                }
                return true;
            }
        });
        this.bundleTable.setHeaderVisible(true);
        this.bundleTableViewer.setComparator((ViewerComparator)new BundleSorter(SORT_COLUMN.ID, 128));
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, true));
        data = new GridData(2);
        buttonComposite.setLayoutData((Object)data);
        this.startButton = this.toolkit.createButton(buttonComposite, "Start", 8);
        data = new GridData(768);
        data.widthHint = 70;
        this.startButton.setLayoutData((Object)data);
        this.startButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BundleInformationMasterPart.this.executeServerCommand("start");
            }
        });
        this.stopButton = this.toolkit.createButton(buttonComposite, "Stop", 8);
        this.stopButton.setLayoutData((Object)data);
        this.stopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BundleInformationMasterPart.this.executeServerCommand("stop");
            }
        });
        this.refreshButton = this.toolkit.createButton(buttonComposite, "Refresh", 8);
        this.refreshButton.setLayoutData((Object)data);
        this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BundleInformationMasterPart.this.executeServerCommand("refresh");
            }
        });
        this.updateButton = this.toolkit.createButton(buttonComposite, "Update", 8);
        this.updateButton.setLayoutData((Object)data);
        this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BundleInformationMasterPart.this.executeServerCommand("update");
            }
        });
        this.bundleTableViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BundleInformationMasterPart.this.updateButtonState();
            }
        });
        this.updateButtonState();
    }

    void updateButtonState() {
        boolean bundleSelected = this.getSelectedBundle() != null;
        this.startButton.setEnabled(bundleSelected);
        this.stopButton.setEnabled(bundleSelected);
        this.refreshButton.setEnabled(bundleSelected);
        this.updateButton.setEnabled(bundleSelected);
    }

    private IBundle getSelectedBundle() {
        Object selectedObject = ((IStructuredSelection)this.bundleTableViewer.getSelection()).getFirstElement();
        if (selectedObject instanceof IBundle) {
            return (IBundle)selectedObject;
        }
        return null;
    }

    void executeServerCommand(final String command) {
        IBundle bundle = this.getSelectedBundle();
        if (bundle != null) {
            final long bundleId = Long.parseLong(bundle.getId());
            Job commandJob = new Job("Execute server command '" + command + "'"){

                protected IStatus run(final IProgressMonitor monitor) {
                    final IOSGiFrameworkAdmin admin = (IOSGiFrameworkAdmin)BundleInformationMasterPart.this.masterDetailsBlock.getServer().loadAdapter(IOSGiFrameworkAdmin.class, null);
                    try {
                        if ("start".equals(command)) {
                            admin.startBundle(bundleId);
                        } else if ("stop".equals(command)) {
                            admin.stopBundle(bundleId);
                        } else if ("refresh".equals(command)) {
                            admin.refreshBundle(bundleId);
                        } else if ("update".equals(command)) {
                            admin.updateBundle(bundleId);
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    (this).BundleInformationMasterPart.this.masterDetailsBlock.refresh(admin.getBundles(monitor));
                                }
                                catch (CoreException e) {
                                    EditorUIPlugin.log(e);
                                }
                            }
                        });
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                }
            };
            commandJob.setSystem(true);
            commandJob.schedule();
        }
    }

    private void createSectionToolbar(Section section) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        final Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
        toolbar.setCursor(handCursor);
        toolbar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!handCursor.isDisposed()) {
                    handCursor.dispose();
                }
            }
        });
        ICommandImageService service = (ICommandImageService)this.masterDetailsBlock.getEditorPage().getSite().getWorkbenchWindow().getService(ICommandImageService.class);
        toolBarManager.add((IAction)new Action("Refresh", service.getImageDescriptor("org.eclipse.ui.file.refresh")){

            public void run() {
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("Updating bundle status from server", 1);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ((this).this).BundleInformationMasterPart.this.masterDetailsBlock.getEditorPage().clearStatus();
                                IOSGiFrameworkAdmin admin = (IOSGiFrameworkAdmin)((this).this).BundleInformationMasterPart.this.masterDetailsBlock.getServer().loadAdapter(IOSGiFrameworkAdmin.class, monitor);
                                if (admin == null) {
                                    IStatus status = EditorUIPlugin.newErrorStatus("Bundle Overview editor part is not integrated with the runtime.");
                                    EditorUIPlugin.log(status);
                                    ((this).this).BundleInformationMasterPart.this.masterDetailsBlock.getEditorPage().setStatus(status);
                                    return;
                                }
                                try {
                                    ((this).this).BundleInformationMasterPart.this.masterDetailsBlock.refresh(admin.getBundles(monitor));
                                }
                                catch (CoreException e) {
                                    EditorUIPlugin.log(e);
                                    ((this).this).BundleInformationMasterPart.this.masterDetailsBlock.getEditorPage().setStatus(e.getStatus());
                                }
                            }
                        });
                        monitor.worked(1);
                    }
                };
                try {
                    ProgressMonitorDialog context = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
                    context.run(true, true, runnable);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    public boolean refresh(Map<Long, IBundle> bundles) {
        if (bundles != null && !bundles.equals(this.bundleTableViewer.getInput())) {
            super.refresh();
            this.bundleTableViewer.setInput(bundles);
            return true;
        }
        return false;
    }

    public void clear() {
        this.bundleTableViewer.setInput(null);
    }

    public void setSelectedBundle(IBundle bundle) {
        this.bundleTableViewer.setSelection((ISelection)new StructuredSelection((Object)bundle));
        this.bundleTableViewer.reveal((Object)bundle);
    }

    static class BundleSorter
    extends ViewerComparator {
        private final SORT_COLUMN sortColumn;
        private final int dir;

        public BundleSorter(SORT_COLUMN sortCoLumn, int dir) {
            this.sortColumn = sortCoLumn;
            this.dir = dir;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            IBundle b1 = (IBundle)e1;
            IBundle b2 = (IBundle)e2;
            int compare = 0;
            switch (this.sortColumn) {
                case ID: {
                    compare = Long.valueOf(b1.getId()).compareTo(Long.valueOf(b2.getId()));
                    break;
                }
                case STATUS: {
                    compare = b1.getState().compareTo(b2.getState());
                    break;
                }
                case NAME: {
                    compare = b1.getSymbolicName().compareTo(b2.getSymbolicName());
                }
            }
            if (this.dir == 1024) {
                compare *= -1;
            }
            return compare;
        }
    }

    static class BundleStatusComparator
    extends ViewerComparator {
        BundleStatusComparator() {
        }

        public void sort(Viewer viewer, Object[] elements) {
            Arrays.sort(elements, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return Long.valueOf(((IBundle)o1).getId()).compareTo(Long.valueOf(((IBundle)o2).getId()));
                }
            });
        }
    }

    static class BundleStatusContentProvider
    implements IStructuredContentProvider {
        private Map<Long, IBundle> bundles;

        BundleStatusContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (this.bundles != null) {
                return this.bundles.values().toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.bundles = newInput instanceof Map ? (Map)newInput : null;
        }
    }

    static class BundleStatusLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        BundleStatusLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return PDEPluginImages.get((String)PDEPluginImages.OBJ_DESC_BUNDLE);
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IBundle bundle = (IBundle)element;
            switch (columnIndex) {
                case 1: {
                    return bundle.getId();
                }
                case 2: {
                    return String.valueOf(bundle.getSymbolicName()) + " (" + bundle.getVersion() + ")";
                }
                case 3: {
                    return bundle.getState();
                }
            }
            return "";
        }
    }

    static enum SORT_COLUMN {
        ID,
        STATUS,
        NAME;

    }

    class SortingListener
    implements Listener {
        SortingListener() {
        }

        public void handleEvent(Event event) {
            TableColumn sortColumn = BundleInformationMasterPart.this.bundleTable.getSortColumn();
            TableColumn currentColumn = (TableColumn)event.widget;
            int dir = BundleInformationMasterPart.this.bundleTable.getSortDirection();
            if (sortColumn == currentColumn) {
                dir = dir == 128 ? 1024 : 128;
            } else {
                BundleInformationMasterPart.this.bundleTable.setSortColumn(currentColumn);
                dir = 128;
            }
            SORT_COLUMN sortIdentifier = null;
            if (currentColumn == BundleInformationMasterPart.this.idColumn) {
                sortIdentifier = SORT_COLUMN.ID;
            }
            if (currentColumn == BundleInformationMasterPart.this.statusColumn) {
                sortIdentifier = SORT_COLUMN.STATUS;
            }
            if (currentColumn == BundleInformationMasterPart.this.symbolicNameColumn) {
                sortIdentifier = SORT_COLUMN.NAME;
            }
            BundleInformationMasterPart.this.bundleTable.setSortDirection(dir);
            BundleInformationMasterPart.this.bundleTableViewer.setComparator((ViewerComparator)new BundleSorter(sortIdentifier, dir));
            BundleInformationMasterPart.this.bundleTableViewer.refresh();
        }
    }
}

