/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.jdt.internal.ui.decoration;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.virgo.ide.jdt.ui.JdtUiPlugin;

public class JdtUiImages {
    private static final String ICON_PATH_PREFIX = "icons/full/";
    private static final String NAME_PREFIX = "org.eclipse.virgo.ide.jdt.ui.";
    private static final int NAME_PREFIX_LENGTH = "org.eclipse.virgo.ide.jdt.ui.".length();
    private static URL ICON_BASE_URL = null;
    private static Map<String, ImageDescriptor> imageDescriptors;
    private static ImageRegistry imageRegistry;
    public static final String IMG_OVR_LOCKED = "org.eclipse.virgo.ide.jdt.ui.locked_ovr.gif";
    public static final String IMG_OVR_EXPORTED = "org.eclipse.virgo.ide.jdt.ui.package_export_ovr.gif";
    private static final String OVR = "ovr16/";
    public static final ImageDescriptor DESC_OVR_LOCKED;
    public static final ImageDescriptor DESC_OVR_EXPORTED;

    static {
        try {
            ICON_BASE_URL = new URL(JdtUiPlugin.getDefault().getBundle().getEntry("/"), ICON_PATH_PREFIX);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        DESC_OVR_LOCKED = JdtUiImages.createManaged(OVR, IMG_OVR_LOCKED);
        DESC_OVR_EXPORTED = JdtUiImages.createManaged(OVR, IMG_OVR_EXPORTED);
    }

    public static Image getImage(String key) {
        return JdtUiImages.getImageRegistry().get(key);
    }

    public static void setToolImageDescriptors(IAction action, String iconName) {
        JdtUiImages.setImageDescriptors(action, "tool16", iconName);
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        JdtUiImages.setImageDescriptors(action, "lcl16", iconName);
    }

    static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
            Iterator<String> iterator = imageDescriptors.keySet().iterator();
            while (iterator.hasNext()) {
                String string;
                String key = string = iterator.next();
                imageRegistry.put(key, imageDescriptors.get(key));
            }
            imageDescriptors = null;
        }
        return imageRegistry;
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)JdtUiImages.makeIconFileURL("d" + type, relPath));
            if (id != null) {
                action.setDisabledImageDescriptor(id);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        action.setImageDescriptor(JdtUiImages.create("e" + type, relPath));
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        try {
            ImageDescriptor result = ImageDescriptor.createFromURL((URL)JdtUiImages.makeIconFileURL(prefix, name.substring(NAME_PREFIX_LENGTH)));
            if (imageDescriptors == null) {
                imageDescriptors = new HashMap<String, ImageDescriptor>();
            }
            imageDescriptors.put(name, result);
            return result;
        }
        catch (MalformedURLException e) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)JdtUiImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException e) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(ICON_BASE_URL, buffer.toString());
    }
}

