/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.shell.state.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiExportPackage;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiFramework;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiFrameworkFactory;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiImportPackage;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiResolutionFailure;
import org.eclipse.virgo.kernel.shell.state.QuasiLiveService;
import org.eclipse.virgo.kernel.shell.state.QuasiPackage;
import org.eclipse.virgo.kernel.shell.state.StateService;
import org.eclipse.virgo.kernel.shell.state.internal.StandardQuasiLiveFramework;
import org.eclipse.virgo.kernel.shell.state.internal.StandardQuasiLiveService;
import org.eclipse.virgo.kernel.shell.state.internal.StandardQuasiPackage;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.springframework.util.AntPathMatcher;

public final class StandardStateService
implements StateService {
    private final QuasiFrameworkFactory quasiFrameworkFactory;
    private final BundleContext bundleContext;
    private final RegionDigraph regionDigraph;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public StandardStateService(QuasiFrameworkFactory quasiFrameworkFactory, BundleContext bundleContext, RegionDigraph regionDigraph) {
        this.quasiFrameworkFactory = quasiFrameworkFactory;
        this.bundleContext = bundleContext;
        this.regionDigraph = regionDigraph;
    }

    @Override
    public List<QuasiBundle> getAllBundles(File source) {
        return this.getQuasiFramework(source).getBundles();
    }

    @Override
    public String getBundleRegionName(long bundleId) {
        return this.regionDigraph.getRegion(bundleId).getName();
    }

    @Override
    public QuasiBundle getBundle(File source, long bundleId) {
        return this.getQuasiFramework(source).getBundle(bundleId);
    }

    @Override
    public List<QuasiLiveService> getAllServices(File source) {
        ArrayList<QuasiLiveService> quasiLiveServices = new ArrayList<QuasiLiveService>();
        if (source == null) {
            SortedMap<Long, QuasiLiveService> services = this.getServicesSortedMap(this.getQuasiFramework());
            for (Map.Entry<Long, QuasiLiveService> serviceEntry : services.entrySet()) {
                quasiLiveServices.add(serviceEntry.getValue());
            }
        }
        return quasiLiveServices;
    }

    private SortedMap<Long, QuasiLiveService> getServicesSortedMap(QuasiFramework quasiFramework) {
        TreeMap<Long, QuasiLiveService> services = new TreeMap<Long, QuasiLiveService>();
        ServiceReference[] allServiceReferences = null;
        try {
            allServiceReferences = this.bundleContext.getAllServiceReferences(null, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return services;
        }
        ServiceReference[] serviceReferenceArray = allServiceReferences;
        int n = allServiceReferences.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference serviceReference = serviceReferenceArray[n2];
            StandardQuasiLiveService service = new StandardQuasiLiveService(quasiFramework, serviceReference);
            services.put(service.getServiceId(), service);
            ++n2;
        }
        return services;
    }

    @Override
    public QuasiLiveService getService(File source, long serviceId) {
        if (source == null) {
            SortedMap<Long, QuasiLiveService> services = this.getServicesSortedMap(this.getQuasiFramework());
            return (QuasiLiveService)services.get(serviceId);
        }
        return null;
    }

    @Override
    public List<QuasiResolutionFailure> getResolverReport(File source, long bundleId) {
        QuasiFramework framework = this.getQuasiFramework(source);
        framework.resolve();
        return framework.diagnose(bundleId);
    }

    @Override
    public QuasiPackage getPackages(File source, String packageName) {
        QuasiFramework framework = this.getQuasiFramework(source);
        if (packageName != null) {
            ArrayList<QuasiImportPackage> importers = new ArrayList<QuasiImportPackage>();
            ArrayList<QuasiExportPackage> exporters = new ArrayList<QuasiExportPackage>();
            List bundles = framework.getBundles();
            for (QuasiBundle qBundle : bundles) {
                QuasiExportPackage exportPackage;
                QuasiImportPackage importPackage = this.processImporters(qBundle, packageName);
                if (importPackage != null) {
                    importers.add(importPackage);
                }
                if ((exportPackage = this.processExporters(qBundle, packageName)) == null) continue;
                exporters.add(exportPackage);
            }
            return new StandardQuasiPackage(exporters, importers, packageName);
        }
        return null;
    }

    @Override
    public List<QuasiBundle> search(File source, String term) {
        try {
            StandardStateService.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            QuasiFramework framework = this.getQuasiFramework(source);
            ArrayList<QuasiBundle> matchingBundles = new ArrayList<QuasiBundle>();
            if (term != null) {
                AntPathMatcher matcher = new AntPathMatcher();
                matcher.setPathSeparator(".");
                List bundles = framework.getBundles();
                for (QuasiBundle bundle : bundles) {
                    if (!matcher.match(term, bundle.getSymbolicName())) continue;
                    matchingBundles.add(bundle);
                }
            }
            ArrayList<QuasiBundle> arrayList = matchingBundles;
            StandardStateService.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return arrayList;
        }
        catch (Throwable throwable) {
            StandardStateService.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private QuasiFramework getQuasiFramework() {
        return new StandardQuasiLiveFramework(this.quasiFrameworkFactory.create(), this.bundleContext);
    }

    private QuasiFramework getQuasiFramework(File source) {
        if (source == null) {
            return this.getQuasiFramework();
        }
        try {
            return this.quasiFrameworkFactory.create(source);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating quasi-framework", e);
        }
    }

    private QuasiImportPackage processImporters(QuasiBundle qBundle, String packageName) {
        try {
            QuasiImportPackage quasiImportPackage;
            block3: {
                StandardStateService.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
                for (QuasiImportPackage qImportPackage : qBundle.getImportPackages()) {
                    if (!qImportPackage.getPackageName().equals(packageName)) continue;
                    quasiImportPackage = qImportPackage;
                    break block3;
                }
                quasiImportPackage = null;
            }
            StandardStateService.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return quasiImportPackage;
        }
        catch (Throwable throwable) {
            StandardStateService.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private QuasiExportPackage processExporters(QuasiBundle qBundle, String packageName) {
        try {
            QuasiExportPackage quasiExportPackage;
            block3: {
                StandardStateService.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
                for (QuasiExportPackage qExportPackage : qBundle.getExportPackages()) {
                    if (!qExportPackage.getPackageName().equals(packageName)) continue;
                    quasiExportPackage = qExportPackage;
                    break block3;
                }
                quasiExportPackage = null;
            }
            StandardStateService.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return quasiExportPackage;
        }
        catch (Throwable throwable) {
            StandardStateService.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("StandardStateService.java", Class.forName("org.eclipse.virgo.kernel.shell.state.internal.StandardStateService"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "search", "org.eclipse.virgo.kernel.shell.state.internal.StandardStateService", "java.io.File:java.lang.String:", "source:term:", "", "java.util.List"), 170);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "processImporters", "org.eclipse.virgo.kernel.shell.state.internal.StandardStateService", "org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle:java.lang.String:", "qBundle:packageName:", "", "org.eclipse.virgo.kernel.osgi.quasi.QuasiImportPackage"), 203);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "processExporters", "org.eclipse.virgo.kernel.shell.state.internal.StandardStateService", "org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle:java.lang.String:", "qBundle:packageName:", "", "org.eclipse.virgo.kernel.osgi.quasi.QuasiExportPackage"), 212);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.shell.state.internal.StandardStateService");
    }
}

