/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.repository.HashGenerator;
import org.eclipse.virgo.repository.builder.ArtifactDescriptorBuilder;
import org.eclipse.virgo.repository.builder.AttributeBuilder;

public class ShaHashGenerator
implements HashGenerator {
    private static final String DIGEST_ALGORITHM = "sha";
    private static final int BUFFER_SIZE = 8192;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    @Override
    public void generateHash(ArtifactDescriptorBuilder artifactDescriptorBuilder, File artifactFile) {
        BigInteger bi;
        String hash;
        MessageDigest digest;
        if (artifactFile.isDirectory()) {
            return;
        }
        try {
            digest = MessageDigest.getInstance(DIGEST_ALGORITHM);
            artifactDescriptorBuilder.addAttribute(new AttributeBuilder().setName("hash-algorithm").setValue(DIGEST_ALGORITHM).build());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(String.format("Unable to get digest algorithm '%s'", DIGEST_ALGORITHM), e);
        }
        FileInputStream in = null;
        try {
            try {
                int length;
                in = new FileInputStream(artifactFile);
                byte[] buffer = new byte[8192];
                while ((length = in.read(buffer)) != -1) {
                    digest.update(buffer, 0, length);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Unable to read file '%s' for hashing", artifactFile.getAbsolutePath()), e);
            }
        }
        catch (Throwable throwable) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        if ((hash = (bi = new BigInteger(1, digest.digest())).toString(16)).length() % 2 != 0) {
            hash = "0" + hash;
        }
        AttributeBuilder attributeBuilder = new AttributeBuilder();
        attributeBuilder.setName("hash");
        attributeBuilder.setValue(hash);
        artifactDescriptorBuilder.addAttribute(attributeBuilder.build());
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.repository.internal.ShaHashGenerator");
    }
}

