/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.deployer.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.equinox.internal.simpleconfigurator.manipulator.SimpleConfiguratorManipulatorUtils;
import org.eclipse.equinox.internal.simpleconfigurator.utils.BundleInfo;
import org.eclipse.equinox.internal.simpleconfigurator.utils.SimpleConfiguratorUtils;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;

public class BundleInfosUpdater {
    private final File bundlesInfoFile;
    private final File baseDir;
    private final HashMap<String, BundleInfo> toBeAddedInBundlesInfo;
    private final HashMap<String, BundleInfo> toBeRemovedFromBundlesInfo;

    public BundleInfosUpdater(URL bundlesInfoURL, File base) {
        this.bundlesInfoFile = new File(bundlesInfoURL.getFile());
        this.toBeAddedInBundlesInfo = new HashMap();
        this.toBeRemovedFromBundlesInfo = new HashMap();
        this.baseDir = base;
    }

    public BundleInfosUpdater(File bundlesInfo, File base) {
        this.bundlesInfoFile = bundlesInfo;
        this.toBeAddedInBundlesInfo = new HashMap();
        this.toBeRemovedFromBundlesInfo = new HashMap();
        this.baseDir = base;
    }

    public void addBundlesToBundlesInfo(File[] files) throws IOException, BundleException {
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File currFile = fileArray[n2];
            BundleInfo currBundleInfo = BundleInfosUpdater.bundleFile2BundleInfo(currFile, 4, true);
            if (currBundleInfo != null) {
                this.toBeAddedInBundlesInfo.put(this.getIdentifier(currBundleInfo), currBundleInfo);
            }
            ++n2;
        }
    }

    private String getIdentifier(BundleInfo bundleInfo) {
        return String.valueOf(bundleInfo.getSymbolicName()) + "=" + bundleInfo.getVersion();
    }

    public void addBundleToBundlesInfo(File file, int startLevel, boolean autoStartFlag) throws IOException, BundleException {
        BundleInfo bundleInfo = BundleInfosUpdater.bundleFile2BundleInfo(file, startLevel, autoStartFlag);
        if (bundleInfo != null) {
            this.toBeAddedInBundlesInfo.put(this.getIdentifier(bundleInfo), bundleInfo);
        }
    }

    public void addBundleToBundlesInfo(String bundleSymbolicName, URI url, String bundleVersion, int startLevel, boolean autoStartFlag) throws IOException, BundleException {
        try {
            BundleInfo bundleInfo = BundleInfosUpdater.createBundleInfo(bundleSymbolicName, bundleVersion, this.baseDir.toURI().relativize(url), startLevel, autoStartFlag);
            if (bundleInfo != null) {
                this.toBeAddedInBundlesInfo.put(this.getIdentifier(bundleInfo), bundleInfo);
            }
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex.getCause());
        }
    }

    public void removeBundleFromBundlesInfo(String bundleSymbolicName, URI url, String bundleVersion, int startLevel, boolean autoStartFlag) throws IOException, BundleException {
        try {
            BundleInfo bundleInfo = BundleInfosUpdater.createBundleInfo(bundleSymbolicName, bundleVersion, this.baseDir.toURI().relativize(url), startLevel, autoStartFlag);
            if (bundleInfo != null) {
                this.toBeRemovedFromBundlesInfo.put(this.getIdentifier(bundleInfo), bundleInfo);
            }
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex.getCause());
        }
    }

    public boolean isAvailable() {
        return this.bundlesInfoFile.exists();
    }

    private HashMap<String, BundleInfo> readBundleInfosInMap(List<BundleInfo> bundleInfos) {
        HashMap<String, BundleInfo> infos = new HashMap<String, BundleInfo>();
        for (BundleInfo bundleInfo : bundleInfos) {
            infos.put(this.getIdentifier(bundleInfo), bundleInfo);
        }
        return infos;
    }

    public void updateBundleInfosRepository() throws IOException {
        List readConfiguration = SimpleConfiguratorUtils.readConfiguration((URL)this.bundlesInfoFile.toURI().toURL(), this.baseDir == null ? null : this.baseDir.toURI());
        HashMap<String, BundleInfo> currentBundleInfos = this.readBundleInfosInMap(readConfiguration);
        currentBundleInfos.putAll(this.toBeAddedInBundlesInfo);
        this.toBeAddedInBundlesInfo.clear();
        for (String identifier : this.toBeRemovedFromBundlesInfo.keySet()) {
            currentBundleInfos.remove(identifier);
        }
        this.toBeRemovedFromBundlesInfo.clear();
        if (this.bundlesInfoFile.exists()) {
            String backupName = String.valueOf(this.bundlesInfoFile.getName()) + System.currentTimeMillis();
            File backupFile = new File(this.bundlesInfoFile.getParentFile(), backupName);
            if (!this.bundlesInfoFile.renameTo(backupFile)) {
                throw new IOException("Fail to rename from (" + this.bundlesInfoFile + ") to (" + backupFile + ")");
            }
        }
        SimpleConfiguratorManipulatorUtils.writeConfiguration((BundleInfo[])currentBundleInfos.values().toArray(new BundleInfo[currentBundleInfos.size()]), (File)this.bundlesInfoFile);
    }

    private static BundleInfo bundleFile2BundleInfo(File file, int startLevel, boolean autoStartFlag) throws IOException, BundleException {
        try {
            Attributes mainAttributes;
            String symbName;
            JarFile jarFile = new JarFile(file);
            Manifest manifest = jarFile.getManifest();
            if (manifest != null && (symbName = (mainAttributes = manifest.getMainAttributes()).getValue("Bundle-SymbolicName")) != null) {
                ManifestElement[] symbNameHeader = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)symbName);
                return BundleInfosUpdater.createBundleInfo(symbNameHeader[0].getValue(), mainAttributes.getValue("Bundle-Version"), file.toURI(), startLevel, autoStartFlag);
            }
            return null;
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex.getCause());
        }
    }

    private static BundleInfo createBundleInfo(String symbName, String bundleVersion, URI uri, int startLevel, boolean autoStart) throws URISyntaxException {
        return new BundleInfo(symbName, bundleVersion, uri, startLevel, autoStart);
    }
}

