/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import org.springframework.util.StringUtils;

public class CustomBooleanEditor
extends PropertyEditorSupport {
    public static final String VALUE_TRUE = "true";
    public static final String VALUE_FALSE = "false";
    public static final String VALUE_ON = "on";
    public static final String VALUE_OFF = "off";
    public static final String VALUE_YES = "yes";
    public static final String VALUE_NO = "no";
    public static final String VALUE_1 = "1";
    public static final String VALUE_0 = "0";
    private final String trueString;
    private final String falseString;
    private final boolean allowEmpty;

    public CustomBooleanEditor(boolean allowEmpty) {
        this(null, null, allowEmpty);
    }

    public CustomBooleanEditor(String trueString, String falseString, boolean allowEmpty) {
        this.trueString = trueString;
        this.falseString = falseString;
        this.allowEmpty = allowEmpty;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        String input;
        String string = input = text != null ? text.trim() : null;
        if (this.allowEmpty && !StringUtils.hasLength((String)input)) {
            this.setValue(null);
        } else if (this.trueString != null && input.equalsIgnoreCase(this.trueString)) {
            this.setValue(Boolean.TRUE);
        } else if (this.falseString != null && input.equalsIgnoreCase(this.falseString)) {
            this.setValue(Boolean.FALSE);
        } else if (this.trueString == null && (input.equalsIgnoreCase(VALUE_TRUE) || input.equalsIgnoreCase(VALUE_ON) || input.equalsIgnoreCase(VALUE_YES) || input.equals(VALUE_1))) {
            this.setValue(Boolean.TRUE);
        } else if (this.falseString == null && (input.equalsIgnoreCase(VALUE_FALSE) || input.equalsIgnoreCase(VALUE_OFF) || input.equalsIgnoreCase(VALUE_NO) || input.equals(VALUE_0))) {
            this.setValue(Boolean.FALSE);
        } else {
            throw new IllegalArgumentException("Invalid boolean value [" + text + "]");
        }
    }

    public String getAsText() {
        if (Boolean.TRUE.equals(this.getValue())) {
            return this.trueString != null ? this.trueString : VALUE_TRUE;
        }
        if (Boolean.FALSE.equals(this.getValue())) {
            return this.falseString != null ? this.falseString : VALUE_FALSE;
        }
        return "";
    }
}

