/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.validation.ValidationException;
import org.apache.openejb.ClassLoaderUtil;
import org.apache.openejb.NoSuchApplicationException;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.UndeployException;
import org.apache.openejb.assembler.Deployer;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.DeploymentLoader;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.Module;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.loader.SystemInstance;

@Stateless(name="openejb/Deployer")
@Remote(value={Deployer.class})
@TransactionManagement(value=TransactionManagementType.BEAN)
public class DeployerEjb
implements Deployer {
    public static final String OPENEJB_DEPLOYER_FORCED_APP_ID_PROP = "openejb.deployer.forced.appId";
    private static final File uniqueFile;
    private final DeploymentLoader deploymentLoader = new DeploymentLoader();
    private final ConfigurationFactory configurationFactory = new ConfigurationFactory();
    private final Assembler assembler = (Assembler)SystemInstance.get().getComponent(org.apache.openejb.spi.Assembler.class);

    @Override
    public String getUniqueFile() {
        return uniqueFile.getAbsolutePath();
    }

    @Override
    public Collection<AppInfo> getDeployedApps() {
        return this.assembler.getDeployedApplications();
    }

    @Override
    public AppInfo deploy(String location) throws OpenEJBException {
        return this.deploy(location, null);
    }

    @Override
    public AppInfo deploy(Properties properties) throws OpenEJBException {
        return this.deploy(null, properties);
    }

    @Override
    public AppInfo deploy(String location, Properties properties) throws OpenEJBException {
        if (location == null && properties == null) {
            throw new NullPointerException("location and properties are null");
        }
        if (location == null) {
            location = properties.getProperty("filename");
        }
        if (properties == null) {
            properties = new Properties();
        }
        AppModule appModule = null;
        try {
            File file = new File(location);
            appModule = this.deploymentLoader.load(file);
            TreeMap<String, Module> modules = new TreeMap<String, Module>();
            for (EjbModule ejbModule : appModule.getEjbModules()) {
                modules.put(ejbModule.getModuleId(), ejbModule);
            }
            for (ClientModule clientModule : appModule.getClientModules()) {
                modules.put(clientModule.getModuleId(), clientModule);
            }
            for (WebModule webModule : appModule.getWebModules()) {
                modules.put(webModule.getModuleId(), webModule);
            }
            for (ConnectorModule connectorModule : appModule.getConnectorModules()) {
                modules.put(connectorModule.getModuleId(), connectorModule);
            }
            for (Map.Entry entry : properties.entrySet()) {
                DeploymentModule module;
                String name = (String)entry.getKey();
                if (!name.startsWith("altDD/")) continue;
                int slash = (name = name.substring("altDD".length() + 1)).indexOf(47);
                if (slash > 0) {
                    String moduleId = name.substring(0, slash);
                    name = name.substring(slash + 1);
                    module = (DeploymentModule)modules.get(moduleId);
                } else {
                    module = appModule;
                }
                if (module == null) continue;
                String value = (String)entry.getValue();
                File dd = new File(value);
                if (dd.canRead()) {
                    module.getAltDDs().put(name, dd.toURI().toURL());
                    continue;
                }
                module.getAltDDs().put(name, value);
            }
            AppInfo appInfo = this.configurationFactory.configureApplication(appModule);
            if (properties != null && properties.containsKey(OPENEJB_DEPLOYER_FORCED_APP_ID_PROP)) {
                appInfo.appId = properties.getProperty(OPENEJB_DEPLOYER_FORCED_APP_ID_PROP);
            }
            this.assembler.createApplication(appInfo);
            return appInfo;
        }
        catch (Throwable e) {
            if (appModule != null) {
                ClassLoaderUtil.destroyClassLoader(appModule.getJarLocation());
            }
            e.printStackTrace();
            if (e instanceof ValidationException) {
                throw (ValidationException)e;
            }
            if (e instanceof OpenEJBException) {
                if (e.getCause() instanceof ValidationException) {
                    throw (ValidationException)e.getCause();
                }
                throw (OpenEJBException)e;
            }
            throw new OpenEJBException(e);
        }
    }

    @Override
    public void undeploy(String moduleId) throws UndeployException, NoSuchApplicationException {
        this.assembler.destroyApplication(moduleId);
    }

    static {
        String uniqueName = "OpenEJB-" + new BigInteger(128, new SecureRandom()).toString(36);
        String tempDir = System.getProperty("java.io.tmpdir");
        try {
            uniqueFile = new File(tempDir, uniqueName).getCanonicalFile();
            uniqueFile.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        uniqueFile.deleteOnExit();
    }
}

