/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregion.internal.quasi;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiParameterised;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.common.StringUtils;

public class StandardQuasiParameterised
implements QuasiParameterised {
    private static final String VERSION_ATTRIBUTE = "version";
    private static final String BUNDLE_SYMBOLIC_NAME_ATTRIBUTE = "bundle-symbolic-name";
    private static final String BUNDLE_VERSION_ATTRIBUTE = "bundle-version";
    private final Map<String, Object> attributes;
    private final Map<String, Object> directives;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    public StandardQuasiParameterised(ImportPackageSpecification importPackageSpecification) {
        VersionRange versionRange;
        String bundleSymbolicName;
        this.attributes = StandardQuasiParameterised.normalise(importPackageSpecification.getAttributes());
        this.directives = StandardQuasiParameterised.normalise(importPackageSpecification.getDirectives());
        VersionRange bundleVersionRange = importPackageSpecification.getBundleVersionRange();
        if (bundleVersionRange != null) {
            this.attributes.put(BUNDLE_VERSION_ATTRIBUTE, bundleVersionRange);
        }
        if (StringUtils.hasLength((String)(bundleSymbolicName = importPackageSpecification.getBundleSymbolicName()))) {
            this.attributes.put(BUNDLE_SYMBOLIC_NAME_ATTRIBUTE, bundleSymbolicName);
        }
        if ((versionRange = importPackageSpecification.getVersionRange()) != null) {
            this.attributes.put(VERSION_ATTRIBUTE, versionRange);
        }
    }

    public StandardQuasiParameterised(ExportPackageDescription exportPackageDescription) {
        this.attributes = StandardQuasiParameterised.normalise(exportPackageDescription.getAttributes());
        this.directives = StandardQuasiParameterised.normalise(exportPackageDescription.getDirectives());
    }

    private static Map<String, Object> normalise(Map<String, Object> map) {
        if (map != null) {
            return new HashMap<String, Object>(map);
        }
        return new HashMap<String, Object>();
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Map<String, Object> getDirectives() {
        return this.directives;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[");
        boolean first = true;
        if (this.directives != null) {
            for (String directiveName : this.directives.keySet()) {
                if (!first) {
                    result.append(", ");
                }
                first = false;
                result.append(directiveName);
                result.append(":=");
                result.append(this.directives.get(directiveName));
            }
        }
        if (this.attributes != null) {
            for (String attributeName : this.attributes.keySet()) {
                if (!first) {
                    result.append(", ");
                }
                first = false;
                result.append(attributeName);
                result.append("=");
                result.append(this.attributes.get(attributeName));
            }
        }
        result.append("]");
        return result.toString();
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.userregion.internal.quasi.StandardQuasiParameterised");
    }
}

