/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.annotation;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.cache.annotation.CacheAnnotationParser;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.cache.interceptor.CacheEvictOperation;
import org.springframework.cache.interceptor.CacheOperation;
import org.springframework.cache.interceptor.CachePutOperation;
import org.springframework.cache.interceptor.CacheableOperation;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringCacheAnnotationParser
implements CacheAnnotationParser,
Serializable {
    @Override
    public Collection<CacheOperation> parseCacheAnnotations(AnnotatedElement ae) {
        Collection<Caching> caching;
        Collection<CachePut> updates;
        Collection<CacheEvict> evicts;
        Collection<CacheOperation> ops = null;
        Collection<Cacheable> cacheables = SpringCacheAnnotationParser.getAnnotations(ae, Cacheable.class);
        if (cacheables != null) {
            ops = this.lazyInit(ops);
            for (Cacheable cacheable : cacheables) {
                ops.add(this.parseCacheableAnnotation(ae, cacheable));
            }
        }
        if ((evicts = SpringCacheAnnotationParser.getAnnotations(ae, CacheEvict.class)) != null) {
            ops = this.lazyInit(ops);
            for (CacheEvict e : evicts) {
                ops.add(this.parseEvictAnnotation(ae, e));
            }
        }
        if ((updates = SpringCacheAnnotationParser.getAnnotations(ae, CachePut.class)) != null) {
            ops = this.lazyInit(ops);
            for (CachePut p : updates) {
                ops.add(this.parseUpdateAnnotation(ae, p));
            }
        }
        if ((caching = SpringCacheAnnotationParser.getAnnotations(ae, Caching.class)) != null) {
            ops = this.lazyInit(ops);
            for (Caching c : caching) {
                ops.addAll(this.parseCachingAnnotation(ae, c));
            }
        }
        return ops;
    }

    private <T extends Annotation> Collection<CacheOperation> lazyInit(Collection<CacheOperation> ops) {
        return ops != null ? ops : new ArrayList(1);
    }

    CacheableOperation parseCacheableAnnotation(AnnotatedElement ae, Cacheable caching) {
        CacheableOperation cuo = new CacheableOperation();
        cuo.setCacheNames(caching.value());
        cuo.setCondition(caching.condition());
        cuo.setKey(caching.key());
        cuo.setName(ae.toString());
        return cuo;
    }

    CacheEvictOperation parseEvictAnnotation(AnnotatedElement ae, CacheEvict caching) {
        CacheEvictOperation ceo = new CacheEvictOperation();
        ceo.setCacheNames(caching.value());
        ceo.setCondition(caching.condition());
        ceo.setKey(caching.key());
        ceo.setCacheWide(caching.allEntries());
        ceo.setBeforeInvocation(caching.beforeInvocation());
        ceo.setName(ae.toString());
        return ceo;
    }

    CacheOperation parseUpdateAnnotation(AnnotatedElement ae, CachePut caching) {
        CachePutOperation cuo = new CachePutOperation();
        cuo.setCacheNames(caching.value());
        cuo.setCondition(caching.condition());
        cuo.setKey(caching.key());
        cuo.setName(ae.toString());
        return cuo;
    }

    Collection<CacheOperation> parseCachingAnnotation(AnnotatedElement ae, Caching caching) {
        Object[] updates;
        Object[] evicts;
        int n;
        Collection<CacheOperation> ops = null;
        Object[] cacheables = caching.cacheable();
        if (!ObjectUtils.isEmpty((Object[])cacheables)) {
            ops = this.lazyInit(ops);
            Object[] objectArray = cacheables;
            n = cacheables.length;
            int n2 = 0;
            while (n2 < n) {
                Object cacheable = objectArray[n2];
                ops.add(this.parseCacheableAnnotation(ae, (Cacheable)cacheable));
                ++n2;
            }
        }
        if (!ObjectUtils.isEmpty((Object[])(evicts = caching.evict()))) {
            ops = this.lazyInit(ops);
            Object[] objectArray = evicts;
            int n3 = evicts.length;
            n = 0;
            while (n < n3) {
                Object evict = objectArray[n];
                ops.add(this.parseEvictAnnotation(ae, (CacheEvict)evict));
                ++n;
            }
        }
        if (!ObjectUtils.isEmpty((Object[])(updates = caching.put()))) {
            ops = this.lazyInit(ops);
            Object[] objectArray = updates;
            int n4 = updates.length;
            int n5 = 0;
            while (n5 < n4) {
                Object update = objectArray[n5];
                ops.add(this.parseUpdateAnnotation(ae, (CachePut)update));
                ++n5;
            }
        }
        return ops;
    }

    private static <T extends Annotation> Collection<T> getAnnotations(AnnotatedElement ae, Class<T> annotationType) {
        ArrayList<T> anns = new ArrayList<T>(2);
        T ann = ae.getAnnotation(annotationType);
        if (ann != null) {
            anns.add(ann);
        }
        Annotation[] annotationArray = ae.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation metaAnn = annotationArray[n2];
            ann = metaAnn.annotationType().getAnnotation(annotationType);
            if (ann != null) {
                anns.add(ann);
            }
            ++n2;
        }
        return anns.isEmpty() ? null : anns;
    }
}

