/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.management.framework;

import java.io.IOException;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;
import org.osgi.jmx.Item;
import org.osgi.jmx.JmxConstants;

public interface CustomBundleWiringStateMBean {
    public static final String OBJECTNAME = "osgi.core:type=wiringState,version=1.0";
    public static final String ALL_NAMESPACE = "osgi.wiring.all";
    public static final String KEY = "Key";
    public static final Item KEY_ITEM = new Item("Key", "The property key", SimpleType.STRING, new String[0]);
    public static final String VALUE = "Value";
    public static final Item VALUE_ITEM = new Item("Value", "The property value", SimpleType.STRING, new String[0]);
    public static final CompositeType PROPERTY_TYPE = Item.compositeType((String)"PROPERTY", (String)"Describes a single directive or attribute of a capability or requirement", (Item[])new Item[]{KEY_ITEM, VALUE_ITEM});
    public static final TabularType DIRECTIVES_TYPE = Item.tabularType((String)"DIRECTIVES", (String)"Describes the directives of a capability or requirement", (CompositeType)PROPERTY_TYPE, (String[])new String[]{"Key"});
    public static final TabularType ATTRIBUTES_TYPE = Item.tabularType((String)"ATTRIBUTES", (String)"Describes attributes of a capability or requirement", (CompositeType)JmxConstants.PROPERTY_TYPE, (String[])new String[]{"Key"});
    public static final String DIRECTIVES = "Directives";
    public static final Item DIRECTIVES_ITEM = new Item("Directives", "The directives of a capability or requirement", (OpenType)DIRECTIVES_TYPE, new String[0]);
    public static final String ATTRIBUTES = "Attributes";
    public static final Item ATTRIBUTES_ITEM = new Item("Attributes", "The attributes of a capability or requirement", (OpenType)ATTRIBUTES_TYPE, new String[0]);
    public static final String NAMESPACE = "Namespace";
    public static final Item NAMESPACE_ITEM = new Item("Namespace", "The namespace of a capability or requirement", SimpleType.STRING, new String[0]);
    public static final CompositeType BUNDLE_REQUIREMENT_TYPE = Item.compositeType((String)"BUNDLE_REQUIREMENT", (String)"Describes the live wired requirements of a bundle", (Item[])new Item[]{ATTRIBUTES_ITEM, DIRECTIVES_ITEM, NAMESPACE_ITEM});
    public static final ArrayType<CompositeData> REQUIREMENT_ARRAY_TYPE = Item.arrayType((int)1, (OpenType)BUNDLE_REQUIREMENT_TYPE);
    public static final CompositeType BUNDLE_CAPABILITY_TYPE = Item.compositeType((String)"BUNDLE_CAPABILITY", (String)"Describes the live wired capabilities of a bundle", (Item[])new Item[]{ATTRIBUTES_ITEM, DIRECTIVES_ITEM, NAMESPACE_ITEM});
    public static final ArrayType<CompositeData> CAPABILITY_ARRAY_TYPE = Item.arrayType((int)1, (OpenType)BUNDLE_CAPABILITY_TYPE);
    public static final String BUNDLE_REVISION_ID = "BundleRevisionId";
    public static final Item BUNDLE_REVISION_ID_ITEM = new Item("BundleRevisionId", "The local identifier of the bundle revision", SimpleType.INTEGER, new String[0]);
    public static final String REQUIREMENTS = "Requirements";
    public static final Item REQUIREMENTS_ITEM = new Item("Requirements", "The bundle requirements of a bundle revision wiring", REQUIREMENT_ARRAY_TYPE, new String[0]);
    public static final CompositeType BUNDLE_REVISION_REQUIREMENTS_TYPE = Item.compositeType((String)"BUNDLE_REVISION_REQUIREMENTS", (String)"Describes the requirements for a bundle revision", (Item[])new Item[]{BUNDLE_REVISION_ID_ITEM, REQUIREMENTS_ITEM});
    public static final TabularType BUNDLE_REVISIONS_REQUIREMENTS_TYPE = Item.tabularType((String)"REVISIONS_REQUIREMENTS", (String)"The bundle requirements for all bundle revisions", (CompositeType)BUNDLE_REVISION_REQUIREMENTS_TYPE, (String[])new String[]{"BundleRevisionId"});
    public static final String CAPABILITIES = "Capabilities";
    public static final Item CAPABILITIES_ITEM = new Item("Capabilities", "The bundle capabilities of a bundle revision wiring", CAPABILITY_ARRAY_TYPE, new String[0]);
    public static final CompositeType BUNDLE_REVISION_CAPABILITIES_TYPE = Item.compositeType((String)"BUNDLE_REVISION_CAPABILITIES", (String)"Describes the capabilities for a bundle revision", (Item[])new Item[]{BUNDLE_REVISION_ID_ITEM, CAPABILITIES_ITEM});
    public static final TabularType BUNDLE_REVISIONS_CAPABILITIES_TYPE = Item.tabularType((String)"REVISIONS_CAPABILITIES", (String)"The bundle capabilities for all bundle revisions", (CompositeType)BUNDLE_REVISION_CAPABILITIES_TYPE, (String[])new String[]{"BundleRevisionId"});
    public static final String BUNDLE_REQUIREMENT = "BundleRequirement";
    public static final Item BUNDLE_REQUIREMENT_ITEM = new Item("BundleRequirement", "The wired requirements of a bundle", (OpenType)BUNDLE_REQUIREMENT_TYPE, new String[0]);
    public static final String BUNDLE_CAPABILITY = "BundleCapability";
    public static final Item BUNDLE_CAPABILITY_ITEM = new Item("BundleCapability", "The wired capabilities of a bundle", (OpenType)BUNDLE_CAPABILITY_TYPE, new String[0]);
    public static final String PROVIDER_BUNDLE_ID = "ProviderBundleId";
    public static final Item PROVIDER_BUNDLE_ID_ITEM = new Item("ProviderBundleId", "The identifier of the bundle that is the provider of the capability", SimpleType.LONG, new String[0]);
    public static final String PROVIDER_BUNDLE_REVISION_ID = "ProviderBundleRevisionId";
    public static final Item PROVIDER_BUNDLE_REVISION_ID_ITEM = new Item("ProviderBundleRevisionId", "A local id for the bundle revision that is the provider of the capability", SimpleType.INTEGER, new String[0]);
    public static final String REQUIRER_BUNDLE_ID = "RequirerBundleId";
    public static final Item REQUIRER_BUNDLE_ID_ITEM = new Item("RequirerBundleId", "The identifier of the bundle that is the requirer of the requirement", SimpleType.LONG, new String[0]);
    public static final String REQUIRER_BUNDLE_REVISION_ID = "RequirerBundleRevisionId";
    public static final Item REQUIRER_BUNDLE_REVISION_ID_ITEM = new Item("RequirerBundleRevisionId", "A local id for the bundle revision that is the requirer of the requirement", SimpleType.INTEGER, new String[0]);
    public static final CompositeType BUNDLE_WIRE_TYPE = Item.compositeType((String)"BUNDLE_WIRE", (String)"Describes the live association between a provider and a requirer", (Item[])new Item[]{BUNDLE_REQUIREMENT_ITEM, BUNDLE_CAPABILITY_ITEM, PROVIDER_BUNDLE_ID_ITEM, REQUIRER_BUNDLE_ID_ITEM});
    public static final ArrayType<CompositeData> BUNDLE_WIRE_ARRAY_TYPE = Item.arrayType((int)1, (OpenType)BUNDLE_WIRE_TYPE);
    public static final CompositeType BUNDLE_REVISION_WIRE_TYPE = Item.compositeType((String)"BUNDLE_REVISION_WIRE", (String)"Describes the live association between a provider and a requirer", (Item[])new Item[]{BUNDLE_REQUIREMENT_ITEM, BUNDLE_CAPABILITY_ITEM, PROVIDER_BUNDLE_ID_ITEM, PROVIDER_BUNDLE_REVISION_ID_ITEM, REQUIRER_BUNDLE_ID_ITEM, REQUIRER_BUNDLE_REVISION_ID_ITEM});
    public static final ArrayType<CompositeData> BUNDLE_REVISION_WIRE_ARRAY_TYPE = Item.arrayType((int)1, (OpenType)BUNDLE_REVISION_WIRE_TYPE);
    public static final String PROVIDED_WIRES = "ProvidedWires";
    public static final Item PROVIDED_WIRES_ITEM = new Item("ProvidedWires", "The bundle wires to the capabilities provided by this bundle wiring.", BUNDLE_WIRE_ARRAY_TYPE, new String[0]);
    public static final String REQUIRED_WIRES = "RequiredWires";
    public static final Item REQUIRED_WIRES_ITEM = new Item("RequiredWires", "The bundle wires to requirements in use by this bundle wiring", BUNDLE_WIRE_ARRAY_TYPE, new String[0]);
    public static final String REVISION_PROVIDED_WIRES = "RevisionProvidedWires";
    public static final Item REVISION_PROVIDED_WIRES_ITEM = new Item("RevisionProvidedWires", "The bundle wires to the capabilities provided by this bundle revision wiring.", BUNDLE_REVISION_WIRE_ARRAY_TYPE, new String[0]);
    public static final String REVISION_REQUIRED_WIRES = "RevisionRequiredWires";
    public static final Item REVISION_REQUIRED_WIRES_ITEM = new Item("RevisionRequiredWires", "The bundle wires to requirements in use by this bundle revision wiring", BUNDLE_REVISION_WIRE_ARRAY_TYPE, new String[0]);
    public static final CompositeType BUNDLE_WIRING_TYPE = Item.compositeType((String)"BUNDLE_WIRING", (String)"Describes the runtime association between a provider and a requirer", (Item[])new Item[]{REQUIREMENTS_ITEM, CAPABILITIES_ITEM, REQUIRED_WIRES_ITEM, PROVIDED_WIRES_ITEM});
    public static final CompositeType BUNDLE_REVISION_WIRING_TYPE = Item.compositeType((String)"BUNDLE_REVISION_WIRING", (String)"Describes the runtime association between a provider and a requirer", (Item[])new Item[]{BUNDLE_REVISION_ID_ITEM, REQUIREMENTS_ITEM, CAPABILITIES_ITEM, REVISION_REQUIRED_WIRES_ITEM, REVISION_PROVIDED_WIRES_ITEM});
    public static final TabularType BUNDLE_REVISIONS_WIRINGS_TYPE = Item.tabularType((String)"BUNDLE_REVISIONS_WIRINGS", (String)"A bundle wiring for each revision of a bundle", (CompositeType)BUNDLE_REVISION_WIRING_TYPE, (String[])new String[]{"BundleRevisionId"});
    public static final String BUNDLE_ID = "BundleId";
    public static final Item BUNDLE_ID_ITEM = new Item("BundleId", "The bundle identifier of the bundle revision", SimpleType.LONG, new String[0]);
    public static final CompositeType BUNDLE_REVISION_WIRING_CLOSURE_TYPE = Item.compositeType((String)"BUNDLE_REVISION_WIRING_CLOSURE", (String)"Describes the runtime association between a provider and a requirer", (Item[])new Item[]{BUNDLE_ID_ITEM, BUNDLE_REVISION_ID_ITEM, REQUIREMENTS_ITEM, CAPABILITIES_ITEM, REVISION_REQUIRED_WIRES_ITEM, REVISION_PROVIDED_WIRES_ITEM});
    public static final TabularType BUNDLE_REVISIONS_WIRINGS_CLOSURES_TYPE = Item.tabularType((String)"BUNDLE_REVISIONS_WIRING_CLOSURES_TYPE", (String)"A transitivly complete set of bundle wirings for each revision of a bundle", (CompositeType)BUNDLE_REVISION_WIRING_CLOSURE_TYPE, (String[])new String[]{"BundleId", "BundleRevisionId"});

    public CompositeData[] getCurrentRevisionDeclaredRequirements(long var1, String var3) throws IOException;

    public CompositeData[] getCurrentRevisionDeclaredCapabilities(long var1, String var3) throws IOException;

    public CompositeData getCurrentWiring(long var1, String var3) throws IOException;

    public TabularData getCurrentWiringClosure(long var1, String var3) throws IOException;

    public TabularData getRevisionsDeclaredRequirements(long var1, String var3) throws IOException;

    public TabularData getRevisionsDeclaredCapabilities(long var1, String var3) throws IOException;

    public TabularData getRevisionsWiring(long var1, String var3) throws IOException;

    public TabularData getRevisionsWiringClosure(long var1, String var3) throws IOException;
}

