/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ClassFormatException;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.Code;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantValue;
import org.aspectj.apache.bcel.classfile.ExceptionTable;
import org.aspectj.apache.bcel.classfile.Signature;
import org.aspectj.apache.bcel.classfile.SourceFile;

public class AttributeUtils {
    public static Attribute[] readAttributes(DataInputStream dataInputstream, ConstantPool cpool) {
        try {
            int length = dataInputstream.readUnsignedShort();
            if (length == 0) {
                return Attribute.NoAttributes;
            }
            Attribute[] attrs = new Attribute[length];
            int i = 0;
            while (i < length) {
                attrs[i] = Attribute.readAttribute(dataInputstream, cpool);
                ++i;
            }
            return attrs;
        }
        catch (IOException e) {
            throw new ClassFormatException("IOException whilst reading set of attributes: " + e.toString());
        }
    }

    public static void writeAttributes(Attribute[] attributes, DataOutputStream file) throws IOException {
        if (attributes == null) {
            file.writeShort(0);
        } else {
            file.writeShort(attributes.length);
            int i = 0;
            while (i < attributes.length) {
                attributes[i].dump(file);
                ++i;
            }
        }
    }

    public static Signature getSignatureAttribute(Attribute[] attributes) {
        int i = 0;
        while (i < attributes.length) {
            if (attributes[i].tag == 10) {
                return (Signature)attributes[i];
            }
            ++i;
        }
        return null;
    }

    public static Code getCodeAttribute(Attribute[] attributes) {
        int i = 0;
        while (i < attributes.length) {
            if (attributes[i].tag == 2) {
                return (Code)attributes[i];
            }
            ++i;
        }
        return null;
    }

    public static ExceptionTable getExceptionTableAttribute(Attribute[] attributes) {
        int i = 0;
        while (i < attributes.length) {
            if (attributes[i].tag == 3) {
                return (ExceptionTable)attributes[i];
            }
            ++i;
        }
        return null;
    }

    public static ConstantValue getConstantValueAttribute(Attribute[] attributes) {
        int i = 0;
        while (i < attributes.length) {
            if (attributes[i].getTag() == 1) {
                return (ConstantValue)attributes[i];
            }
            ++i;
        }
        return null;
    }

    public static void accept(Attribute[] attributes, ClassVisitor visitor) {
        int i = 0;
        while (i < attributes.length) {
            attributes[i].accept(visitor);
            ++i;
        }
    }

    public static boolean hasSyntheticAttribute(Attribute[] attributes) {
        int i = 0;
        while (i < attributes.length) {
            if (attributes[i].tag == 7) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static SourceFile getSourceFileAttribute(Attribute[] attributes) {
        int i = 0;
        while (i < attributes.length) {
            if (attributes[i].tag == 0) {
                return (SourceFile)attributes[i];
            }
            ++i;
        }
        return null;
    }
}

