/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.util;

import java.io.Serializable;
import javax.validation.Path;

public final class NodeImpl
implements Path.Node,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String INDEX_OPEN = "[";
    private static final String INDEX_CLOSE = "]";
    private String name;
    private boolean inIterable;
    private Integer index;
    private Object key;

    public static StringBuilder appendNode(Path.Node node, StringBuilder to) {
        if (node.isInIterable()) {
            to.append(INDEX_OPEN);
            if (node.getIndex() != null) {
                to.append(node.getIndex());
            } else if (node.getKey() != null) {
                to.append(node.getKey());
            }
            to.append(INDEX_CLOSE);
        }
        if (node.getName() != null) {
            if (to.length() > 0) {
                to.append(".");
            }
            to.append(node.getName());
        }
        return to;
    }

    public static NodeImpl atIndex(Integer index) {
        NodeImpl result = new NodeImpl();
        result.setIndex(index);
        return result;
    }

    public static NodeImpl atKey(Object key) {
        NodeImpl result = new NodeImpl();
        result.setKey(key);
        return result;
    }

    public NodeImpl(String name) {
        this.name = name;
    }

    NodeImpl(Path.Node node) {
        this.name = node.getName();
        this.inIterable = node.isInIterable();
        this.index = node.getIndex();
        this.key = node.getKey();
    }

    private NodeImpl() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isInIterable() {
        return this.inIterable;
    }

    public void setInIterable(boolean inIterable) {
        this.inIterable = inIterable;
    }

    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.inIterable = true;
        this.index = index;
        this.key = null;
    }

    public Object getKey() {
        return this.key;
    }

    public void setKey(Object key) {
        this.inIterable = true;
        this.key = key;
        this.index = null;
    }

    public String toString() {
        return NodeImpl.appendNode(this, new StringBuilder()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeImpl node = (NodeImpl)o;
        if (this.inIterable != node.inIterable) {
            return false;
        }
        if (this.index != null ? !this.index.equals(node.index) : node.index != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(node.key) : node.key != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(node.name) : node.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.inIterable ? 1 : 0);
        result = 31 * result + (this.index != null ? this.index.hashCode() : 0);
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        return result;
    }
}

