/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.snaps.core.internal;

import java.util.Collection;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.snaps.core.RequestRouter;
import org.eclipse.virgo.snaps.core.SnapRegistry;
import org.eclipse.virgo.snaps.core.internal.Host;
import org.eclipse.virgo.snaps.core.internal.HostSelector;
import org.eclipse.virgo.snaps.core.internal.Snap;
import org.eclipse.virgo.snaps.core.internal.SnapHostDefinition;
import org.eclipse.virgo.snaps.core.internal.SnapUtils;
import org.eclipse.virgo.snaps.core.internal.SnapsLogEvents;
import org.eclipse.virgo.snaps.core.internal.deployer.SnapFactory;
import org.eclipse.virgo.util.osgi.ServiceRegistrationTracker;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SnapFactoryMonitor
implements ServiceTrackerCustomizer<SnapFactory, Object> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BundleContext bundleContext;
    private final ServiceTracker<SnapFactory, Object> snapFactoryTracker;
    private final EventLogger eventLogger;
    private final SnapRegistry snapRegistry;

    public SnapFactoryMonitor(BundleContext bundleContext, EventLogger eventLogger, SnapRegistry snapRegistry) {
        this.bundleContext = bundleContext;
        this.snapFactoryTracker = new ServiceTracker(bundleContext, SnapFactory.class, (ServiceTrackerCustomizer)this);
        this.eventLogger = eventLogger;
        this.snapRegistry = snapRegistry;
    }

    public void start() {
        this.snapFactoryTracker.open();
    }

    public void stop() {
        this.snapFactoryTracker.close();
    }

    public Object addingService(ServiceReference<SnapFactory> reference) {
        SnapFactory snapFactory = (SnapFactory)this.bundleContext.getService(reference);
        if (snapFactory != null) {
            BundleContext snapBundleContext = reference.getBundle().getBundleContext();
            SnapBinder snapBinder = new SnapBinder(snapBundleContext, snapFactory, SnapHostDefinition.fromServiceReference(reference), this.eventLogger, this.snapRegistry);
            snapBinder.start();
            return snapBinder;
        }
        this.logger.warn("Unable to create SnapBinder due to missing SnapFactory");
        return null;
    }

    public void modifiedService(ServiceReference<SnapFactory> reference, Object service) {
    }

    public void removedService(ServiceReference<SnapFactory> reference, Object service) {
        this.logger.info("Destroying SnapBinder for bundle '{}'", (Object)reference.getBundle());
        ((SnapBinder)service).destroy();
    }

    private static final class SnapBinder
    implements ServiceListener {
        private static final String SNAP_ORDER = "snap.order";
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final BundleContext context;
        private final SnapFactory factory;
        private final HostSelector hostSelector;
        private final Object hostStateMonitor = new Object();
        private final Object snapStateMonitor = new Object();
        private boolean queriedInitialHosts = false;
        private ServiceReference<ServletContext> hostReference;
        private final ServiceRegistrationTracker registrationTracker = new ServiceRegistrationTracker();
        private final EventLogger eventLogger;
        private final SnapRegistry snapRegistry;
        private Snap snap;

        public SnapBinder(BundleContext context, SnapFactory factory, SnapHostDefinition hostDefinition, EventLogger eventLogger, SnapRegistry snapRegistry) {
            this.context = context;
            this.factory = factory;
            this.hostSelector = new HostSelector(hostDefinition, (String)context.getBundle().getHeaders().get("Module-Scope"));
            this.eventLogger = eventLogger;
            this.snapRegistry = snapRegistry;
        }

        private void start() {
            this.registerHostListener();
        }

        private void registerHostListener() {
            try {
                this.context.addServiceListener((ServiceListener)this, "(objectClass=javax.servlet.ServletContext)");
                this.logger.info("Listening for hosts to be registered.");
                this.searchForExistingHost();
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                this.logger.error("Filter syntax invalid");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void hostPublished(ServiceReference<ServletContext> hostReference) {
            assert (!Thread.holdsLock(this.hostStateMonitor));
            ServletContext servletContext = (ServletContext)this.context.getService(hostReference);
            if (servletContext != null) {
                Object object = this.hostStateMonitor;
                synchronized (object) {
                    HashSet<ServiceReference<ServletContext>> references = new HashSet<ServiceReference<ServletContext>>();
                    references.add(hostReference);
                    ServiceReference<ServletContext> matchedHost = this.hostSelector.selectHost(references);
                    if (matchedHost == null) {
                        this.logger.info("Host {} did not match {} ", (Object)hostReference.getBundle().getSymbolicName(), (Object)this.hostSelector.getHostDefinition().toString());
                        return;
                    }
                }
                Bundle hostBundle = hostReference.getBundle();
                Host host = new Host(hostBundle, servletContext, new RequestRouter(this.snapRegistry, servletContext));
                Object object2 = this.snapStateMonitor;
                synchronized (object2) {
                    block19: {
                        if (this.factory.hasSnap()) {
                            Snap snap = this.factory.getSnap();
                            snap.addHost(host);
                            this.publishSnapService(snap, hostBundle);
                        } else {
                            SnapLifecycleState newState = SnapLifecycleState.INIT_FAILED;
                            Snap snap = this.factory.createSnap(host);
                            try {
                                try {
                                    this.logger.info("Initializing snap '{}'", (Object)snap.getContextPath());
                                    snap.init();
                                    newState = SnapLifecycleState.INIT_SUCCEEDED;
                                    this.logger.info("Publishing snap '{}'", (Object)snap.getContextPath());
                                    this.publishSnapService(snap, hostBundle);
                                }
                                catch (ServletException servletException) {
                                    this.eventLogger.log((LogEvent)SnapsLogEvents.SNAP_INIT_FAILURE, new Object[]{SnapUtils.boundContextPath(servletContext.getContextPath(), snap.getContextPath())});
                                    if (newState == SnapLifecycleState.INIT_SUCCEEDED) {
                                        this.snap = snap;
                                    }
                                    break block19;
                                }
                            }
                            catch (Throwable throwable) {
                                if (newState == SnapLifecycleState.INIT_SUCCEEDED) {
                                    this.snap = snap;
                                }
                                throw throwable;
                            }
                            if (newState == SnapLifecycleState.INIT_SUCCEEDED) {
                                this.snap = snap;
                            }
                        }
                    }
                }
            }
        }

        private void publishSnapService(Snap snap, Bundle hostBundle) {
            Properties props = snap.getSnapProperties();
            Hashtable serviceProperties = new Hashtable();
            for (Object key : ((Hashtable)props).keySet()) {
                ((Dictionary)serviceProperties).put(key.toString(), ((Hashtable)props).get(key));
            }
            String snapOrder = (String)((Dictionary)serviceProperties).get(SNAP_ORDER);
            if (snapOrder != null) {
                ((Dictionary)serviceProperties).put("service.ranking", Integer.parseInt(snapOrder));
            }
            ((Dictionary)serviceProperties).put("snap.host.id", Long.toString(hostBundle.getBundleId()));
            ((Dictionary)serviceProperties).put("snap.context.path", snap.getContextPath());
            ((Dictionary)serviceProperties).put("snap.name", (String)this.context.getBundle().getHeaders().get("Bundle-Name"));
            ServiceRegistration registration = this.context.registerService(Snap.class, (Object)snap, serviceProperties);
            this.registrationTracker.track(registration);
            this.logger.info("Published snap service for '{}'", (Object)snap.getContextPath());
        }

        private void destroy() {
            try {
                this.destroySnap();
            }
            finally {
                this.unregisterHostListener();
            }
        }

        private void unregisterHostListener() {
            this.logger.info("No longer listening for hosts to be registered.");
            try {
                this.context.removeServiceListener((ServiceListener)this);
            }
            catch (IllegalStateException e) {
                this.logger.warn("Could not remove host listener. Reason: " + e.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void serviceChanged(ServiceEvent event) {
            Object object = this.hostStateMonitor;
            synchronized (object) {
                while (!this.queriedInitialHosts) {
                    try {
                        this.hostStateMonitor.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            int type = event.getType();
            ServiceReference serviceReference = event.getServiceReference();
            if (type == 1 && this.hostReference == null) {
                this.hostPublished((ServiceReference<ServletContext>)serviceReference);
                return;
            }
            if (type != 4) return;
            if (!serviceReference.equals(this.hostReference)) return;
            this.hostRetracted((ServiceReference<ServletContext>)serviceReference);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void hostRetracted(ServiceReference<ServletContext> serviceReference) {
            try {
                this.destroySnap();
            }
            catch (Throwable throwable) {
                Object object = this.hostStateMonitor;
                synchronized (object) {
                    this.hostReference = null;
                }
                throw throwable;
            }
            Object object = this.hostStateMonitor;
            synchronized (object) {
                this.hostReference = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void destroySnap() {
            Snap s = null;
            Object object = this.snapStateMonitor;
            synchronized (object) {
                s = this.snap;
                this.snap = null;
            }
            this.registrationTracker.unregisterAll();
            if (s != null) {
                this.logger.info("Retracted snap service for '{}'", (Object)s.getContextPath());
                s.destroy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void searchForExistingHost() {
            ServiceReference<ServletContext> existingHost = null;
            Collection<ServiceReference<ServletContext>> candidates = this.findHostCandidiates();
            if (candidates != null && !candidates.isEmpty()) {
                this.logger.info("{} host candidates found", (Object)candidates.size());
            } else {
                this.logger.info("No host candidates found");
            }
            Object object = this.hostStateMonitor;
            synchronized (object) {
                try {
                    existingHost = this.hostSelector.selectHost(candidates);
                    this.queriedInitialHosts = true;
                }
                finally {
                    this.hostStateMonitor.notifyAll();
                }
            }
            if (existingHost != null) {
                this.hostPublished(existingHost);
            }
        }

        private Collection<ServiceReference<ServletContext>> findHostCandidiates() {
            try {
                return this.context.getServiceReferences(ServletContext.class, null);
            }
            catch (InvalidSyntaxException ise) {
                throw new IllegalStateException("Unexpected invalid filter syntax with null filter", ise);
            }
        }
    }

    private static enum SnapLifecycleState {
        AWAITING_INIT,
        INIT_SUCCEEDED,
        INIT_FAILED;

    }
}

