/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.config.internal;

import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.eclipse.virgo.nano.config.internal.KernelConfiguration;
import org.eclipse.virgo.nano.config.internal.PropertiesSource;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;

final class KernelConfigurationPropertiesSource
implements PropertiesSource {
    static final String PROPERTY_WORK_DIRECTORY = "work.directory";
    static final String PROPERTY_HOME_DIRECTORY = "home.directory";
    static final String PROPERTY_DOMAIN = "domain";
    static final String KERNEL_CONFIGURATION_PID = "org.eclipse.virgo.kernel";
    static final String PROPERTY_KERNEL_STARTUP_WAIT_LIMIT = "org.eclipse.virgo.kernel.startup.wait.limit";
    private final KernelConfiguration kernelConfiguration;

    public KernelConfigurationPropertiesSource(KernelConfiguration kernelConfiguration) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.kernelConfiguration = kernelConfiguration;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public Map<String, Properties> getConfigurationProperties() {
        try {
            return Collections.singletonMap(KERNEL_CONFIGURATION_PID, this.createProperties());
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private Properties createProperties() {
        try {
            Properties properties = new Properties();
            properties.put(PROPERTY_DOMAIN, this.kernelConfiguration.getDomain());
            properties.put(PROPERTY_HOME_DIRECTORY, this.kernelConfiguration.getHomeDirectory().getAbsolutePath());
            properties.put(PROPERTY_WORK_DIRECTORY, this.kernelConfiguration.getWorkDirectory().getAbsolutePath());
            properties.put(PROPERTY_KERNEL_STARTUP_WAIT_LIMIT, Integer.toString(this.kernelConfiguration.getStartupWaitLimit()));
            return properties;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }
}

