/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.detector;

import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.HashSet;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jolokia.backend.executor.MBeanServerExecutor;
import org.jolokia.detector.ServerDetector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServerDetector
implements ServerDetector {
    private static final MBeanServerExecutor.MBeanAction<String> GET_ATTRIBUTE_HANDLER = new MBeanServerExecutor.MBeanAction<String>(){

        @Override
        public String execute(MBeanServerConnection pConn, ObjectName pName, Object ... extraArgs) throws ReflectionException, InstanceNotFoundException, IOException, MBeanException, AttributeNotFoundException {
            Object attr = pConn.getAttribute(pName, (String)extraArgs[0]);
            return attr != null ? attr.toString() : null;
        }
    };

    protected Set<ObjectName> searchMBeans(MBeanServerExecutor pMBeanServerExecutor, String pMbeanPattern) {
        try {
            ObjectName oName = new ObjectName(pMbeanPattern);
            return pMBeanServerExecutor.queryNames(oName);
        }
        catch (MalformedObjectNameException e) {
            return new HashSet<ObjectName>();
        }
        catch (IOException e) {
            return new HashSet<ObjectName>();
        }
    }

    protected boolean mBeanExists(MBeanServerExecutor pMBeanServerManger, String pObjectName) {
        return this.searchMBeans(pMBeanServerManger, pObjectName).size() > 0;
    }

    protected String getAttributeValue(MBeanServerExecutor pMBeanServerExecutor, String pMBean, String pAttribute) {
        try {
            ObjectName oName = new ObjectName(pMBean);
            return this.getAttributeValue(pMBeanServerExecutor, oName, pAttribute);
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    protected String getAttributeValue(MBeanServerExecutor pMBeanServerExecutor, ObjectName pMBean, String pAttribute) {
        try {
            return pMBeanServerExecutor.call(pMBean, GET_ATTRIBUTE_HANDLER, pAttribute);
        }
        catch (IOException e) {
            return null;
        }
        catch (ReflectionException e) {
            return null;
        }
        catch (JMException e) {
            return null;
        }
    }

    protected String getSingleStringAttribute(MBeanServerExecutor pMBeanServerExecutor, String pMBeanName, String pAttribute) {
        Set<ObjectName> serverMBeanNames = this.searchMBeans(pMBeanServerExecutor, pMBeanName);
        if (serverMBeanNames.size() == 0) {
            return null;
        }
        HashSet<String> attributeValues = new HashSet<String>();
        for (ObjectName oName : serverMBeanNames) {
            String val = this.getAttributeValue(pMBeanServerExecutor, oName, pAttribute);
            if (val == null) continue;
            attributeValues.add(val);
        }
        if (attributeValues.size() == 0 || attributeValues.size() > 1) {
            return null;
        }
        return (String)attributeValues.iterator().next();
    }

    protected String getVersionFromJsr77(MBeanServerExecutor pMbeanServers) {
        Set<ObjectName> names = this.searchMBeans(pMbeanServers, "*:j2eeType=J2EEServer,*");
        if (names.size() > 0) {
            return this.getAttributeValue(pMbeanServers, names.iterator().next(), "serverVersion");
        }
        return null;
    }

    @Override
    public void addMBeanServers(Set<MBeanServerConnection> pServers) {
    }

    @Override
    public void jvmAgentStartup(Instrumentation instrumentation) {
    }

    protected boolean isClassLoaded(String className, Instrumentation instrumentation) {
        Class[] classes;
        if (instrumentation == null || className == null) {
            throw new IllegalArgumentException("instrumentation and className must not be null");
        }
        for (Class c : classes = instrumentation.getAllLoadedClasses()) {
            if (!className.equals(c.getName())) continue;
            return true;
        }
        return false;
    }
}

