/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.agent.dm.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.gemini.blueprint.context.event.OsgiBundleApplicationContextEvent;
import org.eclipse.gemini.blueprint.context.event.OsgiBundleApplicationContextListener;
import org.eclipse.gemini.blueprint.context.event.OsgiBundleContextClosedEvent;
import org.eclipse.gemini.blueprint.context.event.OsgiBundleContextFailedEvent;
import org.eclipse.gemini.blueprint.context.event.OsgiBundleContextRefreshedEvent;
import org.eclipse.gemini.blueprint.extender.event.BootstrappingDependencyEvent;
import org.eclipse.gemini.blueprint.service.importer.OsgiServiceDependency;
import org.eclipse.gemini.blueprint.service.importer.event.OsgiServiceDependencyEvent;
import org.eclipse.gemini.blueprint.service.importer.event.OsgiServiceDependencyWaitEndedEvent;
import org.eclipse.gemini.blueprint.service.importer.event.OsgiServiceDependencyWaitStartingEvent;
import org.eclipse.gemini.blueprint.service.importer.event.OsgiServiceDependencyWaitTimedOutEvent;
import org.osgi.framework.Bundle;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BlueprintEventPostingOsgiBundleApplicationContextListener
implements OsgiBundleApplicationContextListener<OsgiBundleApplicationContextEvent> {
    private static final String PROPERTY_BUNDLE_SYMBOLICNAME = "bundle.symbolicName";
    private static final String PROPERTY_BUNDLE_ID = "bundle.id";
    private static final String PROPERTY_BUNDLE = "bundle";
    private static final String PROPERTY_BUNDLE_VERSION = "bundle.version";
    private static final String PROPERTY_TIMESTAMP = "timestamp";
    private static final String PROPERTY_EXCEPTION = "exception";
    private static final String PROPERTY_DEPENDENCIES = "dependencies";
    private static final String PROPERTY_BEAN_NAME = "bean.name";
    private static final String PROPERTY_MANDATORY = "mandatory";
    private static final String PROPERTY_TYPE = "type";
    private static final String TOPIC_BLUEPRINT_EVENTS = "org/osgi/service/blueprint/container/";
    private static final String EVENT_CREATED = "org/osgi/service/blueprint/container/CREATED";
    private static final String EVENT_DESTROYED = "org/osgi/service/blueprint/container/DESTROYED";
    private static final String EVENT_FAILURE = "org/osgi/service/blueprint/container/FAILURE";
    private static final String EVENT_WAITING = "org/osgi/service/blueprint/container/WAITING";
    private static final String EVENT_GRACE_PERIOD = "org/osgi/service/blueprint/container/GRACE_PERIOD";
    private static final Logger logger = LoggerFactory.getLogger(BlueprintEventPostingOsgiBundleApplicationContextListener.class);
    private static final int TYPE_CREATED = 1;
    private static final int TYPE_DESTROYED = 4;
    private static final int TYPE_FAILURE = 5;
    private static final int TYPE_GRACE_PERIOD = 6;
    private static final int TYPE_WAITING = 7;
    private final EventAdmin eventAdmin;
    private final Map<Bundle, List<OsgiServiceDependency>> unsatisfiedDependencies = new HashMap<Bundle, List<OsgiServiceDependency>>();
    private final Object monitor = new Object();

    public BlueprintEventPostingOsgiBundleApplicationContextListener(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public void onOsgiApplicationEvent(OsgiBundleApplicationContextEvent event) {
        Bundle bundle = event.getBundle();
        Dictionary<String, Object> properties = this.createEventProperties(event);
        if (event instanceof OsgiBundleContextRefreshedEvent) {
            this.clearUnsatisfiedDependencies(bundle);
            this.sendCreatedEvent(properties);
        } else if (event instanceof OsgiBundleContextFailedEvent) {
            this.clearUnsatisfiedDependencies(bundle);
            properties.put(PROPERTY_EXCEPTION, ((OsgiBundleContextFailedEvent)event).getFailureCause());
            this.sendFailureEvent(properties);
        } else if (event instanceof OsgiBundleContextClosedEvent) {
            this.sendDestroyedEvent(properties);
        } else if (event instanceof BootstrappingDependencyEvent) {
            List<OsgiServiceDependency> unsatisfiedDependencies;
            OsgiServiceDependencyEvent serviceDependencyEvent = ((BootstrappingDependencyEvent)event).getDependencyEvent();
            OsgiServiceDependency dependency = serviceDependencyEvent.getServiceDependency();
            if (serviceDependencyEvent instanceof OsgiServiceDependencyWaitStartingEvent) {
                this.addUnsatisfiedDependency(bundle, dependency);
                this.addDependencyProperties(dependency, properties);
                this.sendWaitingEvent(properties);
            } else if (serviceDependencyEvent instanceof OsgiServiceDependencyWaitTimedOutEvent) {
                List<OsgiServiceDependency> unsatisfiedDependencies2 = this.getUnsatisfiedDependencies(bundle);
                this.addDependenciesProperties(unsatisfiedDependencies2, properties);
                this.sendFailureEvent(properties);
            } else if (serviceDependencyEvent instanceof OsgiServiceDependencyWaitEndedEvent && (unsatisfiedDependencies = this.removeUnsatisfiedDependency(bundle, dependency)) != null) {
                this.addDependenciesProperties(unsatisfiedDependencies, properties);
                this.sendGracePeriodEvent(properties);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<OsgiServiceDependency> getUnsatisfiedDependencies(Bundle bundle) {
        Object object = this.monitor;
        synchronized (object) {
            List<Object> dependencies = this.unsatisfiedDependencies.get(bundle);
            if (dependencies == null) {
                dependencies = Collections.emptyList();
            }
            return dependencies;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<OsgiServiceDependency> addUnsatisfiedDependency(Bundle bundle, OsgiServiceDependency dependency) {
        Object object = this.monitor;
        synchronized (object) {
            List<OsgiServiceDependency> bundlesDependencies = this.unsatisfiedDependencies.get(bundle);
            if (bundlesDependencies == null) {
                bundlesDependencies = new ArrayList<OsgiServiceDependency>();
                this.unsatisfiedDependencies.put(bundle, bundlesDependencies);
            }
            bundlesDependencies.add(dependency);
            return bundlesDependencies;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<OsgiServiceDependency> removeUnsatisfiedDependency(Bundle bundle, OsgiServiceDependency satisfiedDependency) {
        Object object = this.monitor;
        synchronized (object) {
            List<OsgiServiceDependency> bundlesDependencies = this.unsatisfiedDependencies.get(bundle);
            if (bundlesDependencies != null) {
                bundlesDependencies.remove(satisfiedDependency);
            }
            return bundlesDependencies;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearUnsatisfiedDependencies(Bundle bundle) {
        Object object = this.monitor;
        synchronized (object) {
            this.unsatisfiedDependencies.remove(bundle);
        }
    }

    private void addDependenciesProperties(List<OsgiServiceDependency> dependencies, Dictionary<String, Object> properties) {
        if (!dependencies.isEmpty()) {
            String[] beanNames = new String[dependencies.size()];
            String[] filters = new String[dependencies.size()];
            boolean[] mandatory = new boolean[dependencies.size()];
            int i = 0;
            while (i < dependencies.size()) {
                OsgiServiceDependency serviceDependency = dependencies.get(i);
                beanNames[i] = serviceDependency.getBeanName();
                filters[i] = serviceDependency.getServiceFilter().toString();
                mandatory[i] = serviceDependency.isMandatory();
                ++i;
            }
            properties.put(PROPERTY_DEPENDENCIES, filters);
            properties.put(PROPERTY_BEAN_NAME, beanNames);
            properties.put(PROPERTY_MANDATORY, mandatory);
        }
    }

    private void addDependencyProperties(OsgiServiceDependency dependency, Dictionary<String, Object> properties) {
        this.addDependenciesProperties(Arrays.asList(dependency), properties);
    }

    private void sendCreatedEvent(Dictionary<String, Object> properties) {
        this.sendEvent(EVENT_CREATED, properties, 1);
    }

    private void sendEvent(String topic, Dictionary<String, Object> properties, int type) {
        properties.put(PROPERTY_TYPE, type);
        logger.info("Sending event to topic '{}' with properties '{}'", (Object)topic, properties);
        try {
            this.eventAdmin.sendEvent(new Event(topic, properties));
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to send event to topic '" + topic + "'. This may be expected during shutdown.", (Throwable)ex);
            }
            logger.error("Failed to send event to topic '{}'. Exception message: '{}'. This may be expected during shutdown. Turn on debug logging for more details.", (Object)topic, (Object)ex.getMessage());
        }
    }

    private void sendFailureEvent(Dictionary<String, Object> properties) {
        this.sendEvent(EVENT_FAILURE, properties, 5);
    }

    private void sendDestroyedEvent(Dictionary<String, Object> properties) {
        this.sendEvent(EVENT_DESTROYED, properties, 4);
    }

    private void sendWaitingEvent(Dictionary<String, Object> properties) {
        this.sendEvent(EVENT_WAITING, properties, 7);
    }

    private void sendGracePeriodEvent(Dictionary<String, Object> properties) {
        this.sendEvent(EVENT_GRACE_PERIOD, properties, 6);
    }

    private Dictionary<String, Object> createEventProperties(OsgiBundleApplicationContextEvent event) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        Bundle bundle = event.getBundle();
        ((Dictionary)properties).put(PROPERTY_BUNDLE, bundle);
        ((Dictionary)properties).put(PROPERTY_BUNDLE_ID, bundle.getBundleId());
        ((Dictionary)properties).put(PROPERTY_BUNDLE_SYMBOLICNAME, bundle.getSymbolicName());
        ((Dictionary)properties).put(PROPERTY_BUNDLE_VERSION, bundle.getVersion());
        ((Dictionary)properties).put(PROPERTY_TIMESTAMP, event.getTimestamp());
        return properties;
    }
}

