/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.management.internal.system;

import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import org.eclipse.virgo.kernel.management.internal.system.AbstractSystemManagementExporter;

public class EnvironmentVariablesSystemManagementExporter
extends AbstractSystemManagementExporter<EnvironmentVariablesMBean> {
    private static final String ENVIRONMENT_VARIABLES = "Environment Variables";

    @Override
    EnvironmentVariablesMBean getBean() {
        return new EnvironmentVariablesMBean();
    }

    @Override
    String getName() {
        return ENVIRONMENT_VARIABLES;
    }

    public static class EnvironmentVariablesMBean
    implements DynamicMBean {
        private final Map<String, String> environmentVariables = System.getenv();

        @Override
        public Object getAttribute(String name) {
            return this.environmentVariables.get(name);
        }

        @Override
        public AttributeList getAttributes(String[] names) {
            AttributeList attributeList = new AttributeList();
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                attributeList.add(new Attribute(name, this.getAttribute(name)));
                ++n2;
            }
            return attributeList;
        }

        @Override
        public MBeanInfo getMBeanInfo() {
            MBeanAttributeInfo[] infos = new MBeanAttributeInfo[this.environmentVariables.size()];
            int i = 0;
            for (String name : this.environmentVariables.keySet()) {
                infos[i++] = new MBeanAttributeInfo(name, "java.lang.String", "", true, false, false);
            }
            return new MBeanInfo(this.getClass().getCanonicalName(), "", infos, new MBeanConstructorInfo[0], new MBeanOperationInfo[0], new MBeanNotificationInfo[0]);
        }

        @Override
        public Object invoke(String method, Object[] arguments, String[] argumentTypes) throws MBeanException, ReflectionException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
            throw new UnsupportedOperationException();
        }

        @Override
        public AttributeList setAttributes(AttributeList attributes) {
            throw new UnsupportedOperationException();
        }
    }
}

