/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.services.concurrent.monitor;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class DeadlockAnalyser {
    private static final Deadlock[] NULL_RESULT = new Deadlock[0];
    private final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();

    public Deadlock[] findDeadlocks() {
        long[] deadlockedThreads = this.threadBean.findMonitorDeadlockedThreads();
        if (deadlockedThreads == null || deadlockedThreads.length == 0) {
            return NULL_RESULT;
        }
        Map<Long, ThreadInfo> threadInfoMap = this.createThreadInfoMap(deadlockedThreads);
        Set<LinkedHashSet<ThreadInfo>> cycles = this.calculateCycles(threadInfoMap);
        Set<LinkedHashSet<ThreadInfo>> chains = this.calculateCycleDeadlockChains(threadInfoMap, cycles);
        cycles.addAll(chains);
        return this.createDeadlockDescriptions(cycles);
    }

    private Deadlock[] createDeadlockDescriptions(Set<LinkedHashSet<ThreadInfo>> cycles) {
        Deadlock[] result = new Deadlock[cycles.size()];
        int count = 0;
        for (Set set : cycles) {
            ThreadInfo[] asArray = set.toArray(new ThreadInfo[set.size()]);
            Deadlock d = new Deadlock(asArray);
            result[count++] = d;
        }
        return result;
    }

    private Set<LinkedHashSet<ThreadInfo>> calculateCycles(Map<Long, ThreadInfo> threadInfoMap) {
        HashSet<LinkedHashSet<ThreadInfo>> cycles = new HashSet<LinkedHashSet<ThreadInfo>>();
        for (Map.Entry<Long, ThreadInfo> entry : threadInfoMap.entrySet()) {
            LinkedHashSet<ThreadInfo> cycle = new LinkedHashSet<ThreadInfo>();
            ThreadInfo t = entry.getValue();
            while (!cycle.contains(t)) {
                cycle.add(t);
                t = threadInfoMap.get(t.getLockOwnerId());
            }
            if (cycles.contains(cycle)) continue;
            cycles.add(cycle);
        }
        return cycles;
    }

    private Set<LinkedHashSet<ThreadInfo>> calculateCycleDeadlockChains(Map<Long, ThreadInfo> threadInfoMap, Set<LinkedHashSet<ThreadInfo>> cycles) {
        ThreadInfo[] allThreads = this.threadBean.getThreadInfo(this.threadBean.getAllThreadIds());
        HashSet<LinkedHashSet<ThreadInfo>> deadlockChain = new HashSet<LinkedHashSet<ThreadInfo>>();
        Set<Long> knownDeadlockedThreads = threadInfoMap.keySet();
        ThreadInfo[] threadInfoArray = allThreads;
        int n = allThreads.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadInfo threadInfo = threadInfoArray[n2];
            Thread.State state = threadInfo.getThreadState();
            if (state == Thread.State.BLOCKED && !knownDeadlockedThreads.contains(threadInfo.getThreadId())) {
                for (LinkedHashSet<ThreadInfo> cycle : cycles) {
                    if (!cycle.contains(threadInfoMap.get(threadInfo.getLockOwnerId()))) continue;
                    LinkedHashSet<ThreadInfo> chain = new LinkedHashSet<ThreadInfo>();
                    ThreadInfo node = threadInfo;
                    while (!chain.contains(node)) {
                        chain.add(node);
                        node = threadInfoMap.get(node.getLockOwnerId());
                    }
                    deadlockChain.add(chain);
                }
            }
            ++n2;
        }
        return deadlockChain;
    }

    private Map<Long, ThreadInfo> createThreadInfoMap(long[] threadIds) {
        ThreadInfo[] threadInfos = this.threadBean.getThreadInfo(threadIds);
        HashMap<Long, ThreadInfo> threadInfoMap = new HashMap<Long, ThreadInfo>();
        ThreadInfo[] threadInfoArray = threadInfos;
        int n = threadInfos.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadInfo threadInfo = threadInfoArray[n2];
            threadInfoMap.put(threadInfo.getThreadId(), threadInfo);
            ++n2;
        }
        return threadInfoMap;
    }

    public static final class Deadlock {
        private final ThreadInfo[] members;
        private final String description;
        private final Set<Long> memberIds;

        private Deadlock(ThreadInfo[] members) {
            this.members = members;
            this.memberIds = new HashSet<Long>(members.length);
            StringBuilder sb = new StringBuilder();
            int x = 0;
            while (x < members.length) {
                ThreadInfo ti = members[x];
                sb.append(ti.getThreadName());
                if (x < members.length) {
                    sb.append(" > ");
                }
                if (x == members.length - 1) {
                    sb.append(ti.getLockOwnerName());
                }
                this.memberIds.add(ti.getThreadId());
                ++x;
            }
            this.description = sb.toString();
        }

        public ThreadInfo[] getMembers() {
            return (ThreadInfo[])this.members.clone();
        }

        public String toString() {
            return this.description;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.memberIds.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Deadlock other = (Deadlock)obj;
            return other.memberIds.equals(this.memberIds);
        }
    }
}

