/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.medic.log.impl.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.eclipse.virgo.medic.log.LoggingConfiguration;

class StandardLoggingConfiguration
implements LoggingConfiguration {
    private final String configuration;
    private final String name;

    StandardLoggingConfiguration(URL configuration, String name) throws IOException {
        this(StandardLoggingConfiguration.readConfiguration(configuration), name);
    }

    StandardLoggingConfiguration(File configuration, String name) throws IOException {
        this(StandardLoggingConfiguration.readConfiguration(configuration), name);
    }

    private StandardLoggingConfiguration(String configuration, String name) {
        this.configuration = configuration;
        this.name = name;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public String getName() {
        return this.name;
    }

    private static String readConfiguration(URL configURL) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(configURL.openStream(), StandardCharsets.UTF_8));){
            return StandardLoggingConfiguration.readConfiguration(reader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static String readConfiguration(File configFile) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(configFile), StandardCharsets.UTF_8));){
            return StandardLoggingConfiguration.readConfiguration(reader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static String readConfiguration(BufferedReader reader) throws IOException {
        String line;
        StringBuilder configurationBuilder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            configurationBuilder.append(line);
        }
        return configurationBuilder.toString();
    }
}

