/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.shutdown;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;

final class KernelAuthenticationConfiguration {
    public static final String FILE_LOCATION_PROPERTY = "org.eclipse.virgo.kernel.authentication.file";
    public static final String DEFAULT_USERNAME = "admin";
    public static final String DEFAULT_PASSWORD = "springsource";
    private static final String USER_PREFIX = "user.";
    private static final String ADMIN_ROLE = "role.admin";
    private final String password;
    private final String userName;

    public KernelAuthenticationConfiguration() {
        this(KernelAuthenticationConfiguration.getProperties(FILE_LOCATION_PROPERTY));
    }

    KernelAuthenticationConfiguration(Properties props) {
        String adminPassword;
        String adminUserName;
        String userName = DEFAULT_USERNAME;
        String password = DEFAULT_PASSWORD;
        if (props != null && (adminUserName = props.getProperty(ADMIN_ROLE)) != null && (adminPassword = props.getProperty(USER_PREFIX + adminUserName)) != null) {
            userName = adminUserName;
            password = adminPassword;
        }
        this.userName = userName;
        this.password = password;
    }

    String getPassword() {
        return this.password;
    }

    String getUserName() {
        return this.userName;
    }

    private static Properties getProperties(String fileLocationProperty) {
        String fileLocation = System.getProperty(fileLocationProperty);
        if (fileLocation == null) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(fileLocation), StandardCharsets.UTF_8);){
                Properties properties = new Properties();
                properties.load(reader);
                return properties;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

