/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.snaps.core.internal;

import java.util.Collection;
import javax.servlet.ServletContext;
import org.eclipse.virgo.snaps.core.internal.SnapHostDefinition;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HostSelector {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SnapHostDefinition hostDefinition;
    private final String moduleScope;

    HostSelector(SnapHostDefinition hostDefinition, String moduleScope) {
        this.hostDefinition = hostDefinition;
        this.moduleScope = moduleScope;
    }

    SnapHostDefinition getHostDefinition() {
        return this.hostDefinition;
    }

    ServiceReference<ServletContext> selectHost(Collection<ServiceReference<ServletContext>> candidates) {
        ServiceReference<ServletContext> bestSoFar = null;
        if (candidates != null) {
            for (ServiceReference<ServletContext> candidateServiceReference : candidates) {
                if (!this.isPossibleHost(candidateServiceReference) || !this.isHigherPriority(bestSoFar, candidateServiceReference)) continue;
                bestSoFar = candidateServiceReference;
                this.logger.info("Found best-so-far Host candidate from bundle '{}'", (Object)candidateServiceReference.getBundle());
            }
        }
        if (bestSoFar != null) {
            this.logger.info("Host service '{}' found", bestSoFar);
        }
        return bestSoFar;
    }

    private boolean isHigherPriority(ServiceReference<ServletContext> bestSoFar, ServiceReference<ServletContext> candidate) {
        return bestSoFar == null || candidate.getBundle().getVersion().compareTo(bestSoFar.getBundle().getVersion()) > 0;
    }

    private boolean isPossibleHost(ServiceReference<ServletContext> servletContextReference) {
        Bundle bundle = servletContextReference.getBundle();
        return this.bundleMatchesHostName(bundle) && this.bundleMatchesHostRange(bundle) && this.bundleIsActive(bundle);
    }

    private boolean bundleIsActive(Bundle bundle) {
        return bundle.getState() == 32;
    }

    private boolean bundleMatchesHostRange(Bundle bundle) {
        return this.hostDefinition.getVersionRange().includes(bundle.getVersion());
    }

    private boolean bundleMatchesHostName(Bundle bundle) {
        String scopedHostSymbolicName;
        if (this.moduleScope != null && (scopedHostSymbolicName = String.valueOf(this.moduleScope) + "-" + this.hostDefinition.getSymbolicName()).equals(bundle.getSymbolicName())) {
            return true;
        }
        return this.hostDefinition.getSymbolicName().equals(bundle.getSymbolicName());
    }
}

