/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.artifact.plan;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import org.eclipse.virgo.kernel.artifact.ArtifactSpecification;
import org.eclipse.virgo.kernel.artifact.plan.PlanDescriptor;
import org.eclipse.virgo.kernel.artifact.plan.PlanReader;
import org.eclipse.virgo.repository.ArtifactBridge;
import org.eclipse.virgo.repository.ArtifactDescriptor;
import org.eclipse.virgo.repository.ArtifactGenerationException;
import org.eclipse.virgo.repository.HashGenerator;
import org.eclipse.virgo.repository.builder.ArtifactDescriptorBuilder;
import org.eclipse.virgo.repository.builder.AttributeBuilder;
import org.eclipse.virgo.util.io.IOUtils;

public class PlanBridge
implements ArtifactBridge {
    public static final String BRIDGE_TYPE = "plan";
    private final PlanReader reader = new PlanReader();
    private static final String SCOPED = "scoped";
    private static final String ATOMIC = "atomic";
    private static final String ARTIFACT = "artifact";
    private static final String TYPE = "type";
    private static final String NAME = "name";
    private static final String VERSION = "version";
    private final HashGenerator hashGenerator;

    public PlanBridge(HashGenerator hashGenerator) {
        this.hashGenerator = hashGenerator;
    }

    public ArtifactDescriptor generateArtifactDescriptor(File artifactFile) throws ArtifactGenerationException {
        PlanDescriptor plan;
        if (!artifactFile.getPath().endsWith(".plan")) {
            return null;
        }
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(artifactFile);
                plan = this.reader.read(in);
            }
            catch (Exception e) {
                throw new ArtifactGenerationException("Failed to read plan descriptor", BRIDGE_TYPE, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)in);
        return this.parsePlan(plan, artifactFile);
    }

    private ArtifactDescriptor parsePlan(PlanDescriptor plan, File artifactFile) {
        ArtifactDescriptorBuilder builder = new ArtifactDescriptorBuilder();
        builder.setUri(artifactFile.toURI());
        builder.setType(BRIDGE_TYPE);
        builder.setName(plan.getName());
        builder.setVersion(plan.getVersion());
        builder.addAttribute(new AttributeBuilder().setName(SCOPED).setValue(Boolean.toString(plan.getScoped())).build());
        builder.addAttribute(new AttributeBuilder().setName(ATOMIC).setValue(Boolean.toString(plan.getAtomic())).build());
        this.parseArtifacts(plan.getArtifactSpecifications(), builder);
        this.hashGenerator.generateHash(builder, artifactFile);
        return builder.build();
    }

    private void parseArtifacts(List<ArtifactSpecification> artifacts, ArtifactDescriptorBuilder builder) {
        for (ArtifactSpecification artifact : artifacts) {
            AttributeBuilder attributeBuilder = new AttributeBuilder();
            attributeBuilder.setName(ARTIFACT);
            attributeBuilder.setValue("");
            attributeBuilder.putProperties(TYPE, new String[]{artifact.getType()});
            attributeBuilder.putProperties(NAME, new String[]{artifact.getName()});
            attributeBuilder.putProperties(VERSION, new String[]{artifact.getVersionRange().toParseString()});
            builder.addAttribute(attributeBuilder.build());
        }
    }
}

