/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.tomcat;

import java.util.Set;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.math.Sets;
import org.eclipse.virgo.web.tomcat.ApplicationNameTrackingDelegate;

public final class ApplicationNameTrackingListener
implements ContainerListener,
LifecycleListener {
    private static final Set<String> BEFORE_EVENTS;
    private static final Set<String> AFTER_EVENTS;
    private final ApplicationNameTrackingDelegate delegate;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        Factory factory = new Factory("ApplicationNameTrackingListener.java", Class.forName("org.eclipse.virgo.web.tomcat.ApplicationNameTrackingListener"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "containerEvent", "org.eclipse.virgo.web.tomcat.ApplicationNameTrackingListener", "org.apache.catalina.ContainerEvent:", "event:", "", "void"), 38);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "handleHostContainerEvents", "org.eclipse.virgo.web.tomcat.ApplicationNameTrackingListener", "org.apache.catalina.ContainerEvent:java.lang.String:", "event:type:", "", "void"), 49);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "handleContextContainerEvents", "org.eclipse.virgo.web.tomcat.ApplicationNameTrackingListener", "org.apache.catalina.Container:java.lang.String:", "container:type:", "", "void"), 62);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "lifecycleEvent", "org.eclipse.virgo.web.tomcat.ApplicationNameTrackingListener", "org.apache.catalina.LifecycleEvent:", "event:", "", "void"), 71);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.web.tomcat.ApplicationNameTrackingListener");
        BEFORE_EVENTS = Sets.asSet((Object[])new String[]{"beforeSessionCreated", "beforeSessionDestroyed", "beforeSessionAttributeRemoved", "beforeSessionAttributeReplaced", "beforeSessionAttributeAdded"});
        AFTER_EVENTS = Sets.asSet((Object[])new String[]{"afterSessionCreated", "afterSessionDestroyed", "afterSessionAttributeRemoved", "afterSessionAttributeReplaced", "afterSessionAttributeAdded"});
    }

    public ApplicationNameTrackingListener() {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.delegate = ApplicationNameTrackingDelegate.getInstance();
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void containerEvent(ContainerEvent event) {
        try {
            try {
                ApplicationNameTrackingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                Container container = event.getContainer();
                String type = event.getType();
                if (container instanceof Host) {
                    this.handleHostContainerEvents(event, type);
                } else if (container instanceof Context) {
                    this.handleContextContainerEvents(container, type);
                }
                ApplicationNameTrackingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return;
            }
            catch (Throwable throwable) {
                ApplicationNameTrackingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void handleHostContainerEvents(ContainerEvent event, String type) {
        try {
            try {
                ApplicationNameTrackingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
                Object data = event.getData();
                if (data instanceof Context) {
                    Context child = (Context)data;
                    if ("addChild".equals(type)) {
                        child.addContainerListener((ContainerListener)this);
                    } else if ("removeChild".equals(type)) {
                        child.removeContainerListener((ContainerListener)this);
                    }
                }
                ApplicationNameTrackingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
                return;
            }
            catch (Throwable throwable) {
                ApplicationNameTrackingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void handleContextContainerEvents(Container container, String type) {
        try {
            try {
                ApplicationNameTrackingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
                if (BEFORE_EVENTS.contains(type)) {
                    Context context = (Context)container;
                    this.delegate.setApplicationNameForContextPath(context.getPath());
                } else if (AFTER_EVENTS.contains(type)) {
                    this.delegate.clearName();
                }
                ApplicationNameTrackingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
                return;
            }
            catch (Throwable throwable) {
                ApplicationNameTrackingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void lifecycleEvent(LifecycleEvent event) {
        try {
            try {
                ApplicationNameTrackingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_3);
                Object source = event.getSource();
                if (source instanceof Host) {
                    Host host = (Host)source;
                    if ("before_start".equals(event.getType())) {
                        host.addContainerListener((ContainerListener)this);
                    } else if ("after_stop".equals(event.getType())) {
                        host.removeContainerListener((ContainerListener)this);
                    }
                }
                ApplicationNameTrackingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_3);
                return;
            }
            catch (Throwable throwable) {
                ApplicationNameTrackingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_3);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }
}

