/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.security;

import org.apache.felix.eventadmin.impl.security.EventAdminSecurityDecorator;
import org.apache.felix.eventadmin.impl.security.TopicPermissions;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.EventAdmin;

public class SecureEventAdminFactory
implements ServiceFactory {
    private EventAdmin m_admin;
    private final TopicPermissions m_topicPermissions;

    public SecureEventAdminFactory(EventAdmin admin, TopicPermissions topicPermissions) {
        this.checkNull(admin, "Admin");
        this.checkNull(topicPermissions, "TopicPermissions");
        this.m_admin = admin;
        this.m_topicPermissions = topicPermissions;
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        return new EventAdminSecurityDecorator(bundle, this.m_admin, this.m_topicPermissions);
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
    }

    private void checkNull(Object object, String name) {
        if (null == object) {
            throw new NullPointerException(name + " may not be null");
        }
    }
}

