/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.openejb.config.DeploymentLoader;
import org.apache.openejb.config.DeploymentsResolver;
import org.apache.openejb.config.RequireDescriptors;
import org.apache.openejb.loader.FileUtils;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.PerformanceTimer;
import org.apache.openejb.util.URLs;
import org.apache.xbean.finder.UrlSet;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClasspathArchive;
import org.apache.xbean.finder.archive.FilteredArchive;
import org.apache.xbean.finder.filter.Filter;
import org.apache.xbean.finder.filter.Filters;
import org.apache.xbean.finder.filter.IncludeExcludeFilter;
import org.apache.xbean.finder.filter.PatternFilter;

public class NewLoaderLogic {
    private static final Logger logger = DeploymentLoader.logger;

    public static UrlSet filterArchives(Filter filter, ClassLoader classLoader, UrlSet urlSet) {
        for (URL url : urlSet.getUrls()) {
            for (Archive archive : ClasspathArchive.archives((ClassLoader)classLoader, (URL[])new URL[]{url})) {
                FilteredArchive filtered = new FilteredArchive(archive, filter);
                if (filtered.iterator().hasNext()) continue;
                urlSet = urlSet.exclude(url);
            }
        }
        return urlSet;
    }

    public static Set<String> callers() {
        StackTraceElement element;
        LinkedHashSet<String> callers = new LinkedHashSet<String>();
        ArrayList<StackTraceElement> elements = new ArrayList<StackTraceElement>(Arrays.asList(new Exception().fillInStackTrace().getStackTrace()));
        Filter start = Filters.classes((String[])new String[]{"javax.ejb.embeddable.EJBContainer", "javax.naming.InitialContext"});
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            element = (StackTraceElement)iterator.next();
            iterator.remove();
            if (!start.accept(element.getClassName())) continue;
            while (iterator.hasNext() && element.getClassName().equals(((StackTraceElement)iterator.next()).getClassName())) {
                iterator.remove();
            }
            break block0;
        }
        Filter end = Filters.packages((String[])new String[]{"junit.", "org.junit.", "org.testng.", "org.apache.maven.", "org.eclipse.", "com.intellij."});
        iterator = elements.iterator();
        while (iterator.hasNext() && !end.accept((element = (StackTraceElement)iterator.next()).getClassName())) {
            callers.add(element.getClassName());
        }
        elements.clear();
        Filter unwanted = Filters.packages((String[])new String[]{"java.", "javax.", "sun.reflect."});
        Iterator classes = callers.iterator();
        while (classes.hasNext()) {
            if (!unwanted.accept((String)classes.next())) continue;
            classes.remove();
        }
        return callers;
    }

    public static UrlSet applyBuiltinExcludes(UrlSet urlSet) throws MalformedURLException {
        Filter filter = Filters.prefixes((String[])new String[]{"XmlSchema-", "activeio-", "activemq-", "antlr-", "aopalliance-", "avalon-framework-", "axis-", "axis2-", "bcprov-", "bval-core", "bval-jsr", "catalina-", "cglib-", "commons-beanutils", "commons-cli-", "commons-codec-", "commons-collections-", "commons-digester-", "commons-dbcp", "commons-dbcp-all-1.3-", "commons-discovery-", "commons-httpclient-", "commons-io-", "commons-lang-", "commons-lang3-", "commons-logging-", "commons-logging-api-", "commons-net-", "commons-pool-", "cssparser-", "cxf-", "deploy.jar", "derby-", "dom4j-", "geronimo-", "gragent.jar", "guice-", "hibernate-", "howl-", "hsqldb-", "htmlunit-", "icu4j-", "idb-", "idea_rt.jar", "jasypt-", "javaee-", "javaee-api", "javassist-", "javaws.jar", "javax.", "jaxb-", "jaxp-", "jboss-", "jbossall-", "jbosscx-", "jbossjts-", "jbosssx-", "jcommander-", "jetty-", "jettison-", "joda-time-", "jmdns-", "jsp-api-", "jsr299-", "jsr311-", "juli-", "junit-", "kahadb-", "log4j-", "logkit-", "mbean-annotation-api-", "myfaces-", "neethi-", "nekohtml-", "openejb-api", "openejb-cxf-bundle", "openejb-javaagent", "openejb-jee", "openejb-loader", "openjpa-", "opensaml-", "openwebbeans-", "openws-", "org.eclipse.", "org.junit.", "org.osgi.core-", "quartz-", "rmock-", "saaj-", "sac-", "scannotation-", "serializer-", "serp-", "servlet-api-", "slf4j-", "spring-", "stax-api-", "swizzle-", "testng-", "webbeans-ee", "webbeans-ejb", "webbeans-impl", "webbeans-spi", "wsdl4j-", "wss4j-", "wstx-asl-", "xalan-", "xbean-", "xercesImpl-", "xml-apis-", "xml-resolver-", "xmlrpc-", "xmlsec-", "xmlunit-"});
        List urls = urlSet.getUrls();
        Iterator iterator = urls.iterator();
        while (iterator.hasNext()) {
            URL url = (URL)iterator.next();
            File file = URLs.toFile(url);
            String name = NewLoaderLogic.filter(file).getName();
            if (!filter.accept(name)) continue;
            iterator.remove();
        }
        return new UrlSet((Collection)urls);
    }

    private static File filter(File location) {
        ArrayList<String> invalid = new ArrayList<String>();
        invalid.add("classes");
        invalid.add("test-classes");
        invalid.add("target");
        invalid.add("build");
        invalid.add("dist");
        invalid.add("bin");
        while (invalid.contains(location.getName())) {
            location = location.getParentFile();
        }
        return location;
    }

    public static void _loadFromClasspath(FileUtils base, List<URL> jarList, ClassLoader classLoader) {
        IncludeExcludeFilter packageFilter;
        PerformanceTimer timer = new PerformanceTimer();
        timer.event("create filters");
        Options options = SystemInstance.get().getOptions();
        String include = "";
        String exclude = "";
        PatternFilter classpathInclude = new PatternFilter(options.get("openejb.deployments.classpath.include", ".*"));
        PatternFilter classpathExclude = new PatternFilter(options.get("openejb.deployments.classpath.exclude", ""));
        IncludeExcludeFilter classpathFilter = new IncludeExcludeFilter((Filter)classpathInclude, (Filter)classpathExclude);
        PatternFilter packageInclude = new PatternFilter(options.get("openejb.deployments.package.include", ".*"));
        PatternFilter packageExclude = new PatternFilter(options.get("openejb.deployments.package.exclude", ""));
        if (classpathInclude.getPattern().pattern().equals(".*") && packageInclude.getPattern().pattern().equals(".*")) {
            timer.event("callers");
            Set<String> callers = NewLoaderLogic.callers();
            timer.event("parse packages");
            callers.size();
            HashSet<String> packages = new HashSet<String>();
            for (String caller : callers) {
                Object[] parts = caller.split("\\.");
                if (parts.length > 2) {
                    parts = new String[]{parts[0], parts[1]};
                }
                packages.add(Join.join(".", parts));
            }
            Filter includes = Filters.packages((String[])packages.toArray(new String[0]));
            packageFilter = new IncludeExcludeFilter(includes, (Filter)packageExclude);
        } else {
            packageFilter = new IncludeExcludeFilter((Filter)packageInclude, (Filter)packageExclude);
        }
        timer.event("urlset");
        Set requireDescriptors = options.getAll("openejb.deployments.classpath.require.descriptor", (Enum[])new RequireDescriptors[]{RequireDescriptors.CLIENT});
        boolean filterDescriptors = options.get("openejb.deployments.classpath.filter.descriptors", false);
        boolean filterSystemApps = options.get("openejb.deployments.classpath.filter.systemapps", true);
        try {
            boolean userSuppliedClasspathFilter;
            UrlSet urlSet = new UrlSet(classLoader);
            timer.event("exclude system urls");
            urlSet = urlSet.exclude(ClassLoader.getSystemClassLoader().getParent());
            urlSet = urlSet.excludeJavaExtDirs();
            urlSet = urlSet.excludeJavaEndorsedDirs();
            urlSet = urlSet.excludeJavaHome();
            urlSet = urlSet.excludePaths(System.getProperty("sun.boot.class.path", ""));
            urlSet = urlSet.exclude(".*/JavaVM.framework/.*");
            timer.event("classpath filter");
            UrlSet beforeFiltering = urlSet;
            urlSet = urlSet.filter((Filter)classpathFilter);
            if (urlSet.size() == 0) {
                String message = String.format("Classpath Include/Exclude resulted in zero URLs.  There were %s possible URLs before filtering and 0 after: include=\"%s\", exclude=\"%s\"", beforeFiltering.size(), include, exclude);
                logger.error(message);
                logger.info("Eligible Classpath before filtering:");
                for (URL url : beforeFiltering) {
                    logger.info(String.format("   %s", url.toExternalForm()));
                }
            }
            boolean bl = userSuppliedClasspathFilter = beforeFiltering.size() != urlSet.size();
            if (!userSuppliedClasspathFilter) {
                logger.info("Applying buildin classpath excludes");
                timer.event("buildin excludes");
                urlSet = NewLoaderLogic.applyBuiltinExcludes(urlSet);
            }
            DeploymentsResolver.processUrls(urlSet.getUrls(), classLoader, EnumSet.allOf(RequireDescriptors.class), base, jarList);
            timer.event("package filter");
            urlSet = NewLoaderLogic.filterArchives((Filter)packageFilter, classLoader, urlSet);
            timer.event("process urls");
            List urls = urlSet.getUrls();
            int size = urls.size();
            long begin = System.currentTimeMillis();
            DeploymentsResolver.processUrls(urls, classLoader, requireDescriptors, base, jarList);
            long end = System.currentTimeMillis();
            long time = end - begin;
            timer.stop(System.out);
            UrlSet unchecked = new UrlSet(new URL[0]);
            DeploymentsResolver.processUrls(unchecked.getUrls(), classLoader, EnumSet.allOf(RequireDescriptors.class), base, jarList);
            if (logger.isDebugEnabled()) {
                int urlCount = urlSet.getUrls().size() + unchecked.getUrls().size();
                logger.debug("URLs after filtering: " + urlCount);
                for (URL uRL : urlSet.getUrls()) {
                    logger.debug("Annotations path: " + uRL);
                }
                for (URL uRL : unchecked.getUrls()) {
                    logger.debug("Descriptors path: " + uRL);
                }
            }
            if (urls.size() == 0) {
                return;
            }
            if (time < 1000L) {
                logger.debug("Searched " + urls.size() + " classpath urls in " + time + " milliseconds.  Average " + time / (long)urls.size() + " milliseconds per url.");
            } else if (time < 4000L || urls.size() < 3) {
                logger.info("Searched " + urls.size() + " classpath urls in " + time + " milliseconds.  Average " + time / (long)urls.size() + " milliseconds per url.");
            } else if (time < 10000L) {
                logger.warning("Searched " + urls.size() + " classpath urls in " + time + " milliseconds.  Average " + time / (long)urls.size() + " milliseconds per url.");
                logger.warning("Consider adjusting your openejb.deployments.classpath.exclude and openejb.deployments.classpath.include settings.  Current settings: exclude='" + exclude + "', include='" + include + "'");
            } else {
                logger.fatal("Searched " + urls.size() + " classpath urls in " + time + " milliseconds.  Average " + time / (long)urls.size() + " milliseconds per url.  TOO LONG!");
                logger.fatal("ADJUST THE EXCLUDE/INCLUDE!!!.  Current settings: openejb.deployments.classpath.exclude='" + exclude + "', " + "openejb.deployments.classpath.include" + "='" + include + "'");
                ArrayList<String> list = new ArrayList<String>();
                for (URL uRL : urls) {
                    list.add(uRL.toExternalForm());
                }
                Collections.sort(list);
                for (String string : list) {
                    logger.info("Matched: " + string);
                }
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            logger.warning("Unable to search classpath for modules: Received Exception: " + e1.getClass().getName() + " " + e1.getMessage(), e1);
        }
    }
}

