/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.activemq;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapterInternalException;
import org.apache.activemq.broker.BrokerService;
import org.apache.kahadb.util.Scheduler;
import org.apache.openejb.resource.activemq.ActiveMQFactory;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.URISupport;

public class ActiveMQResourceAdapter
extends org.apache.activemq.ra.ActiveMQResourceAdapter {
    private String dataSource;
    private String useDatabaseLock;

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public void setUseDatabaseLock(String useDatabaseLock) {
        this.useDatabaseLock = useDatabaseLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BootstrapContext bootstrapContext) throws ResourceAdapterInternalException {
        String brokerXmlConfig;
        Properties properties = new Properties();
        if (null != this.dataSource) {
            properties.put("DataSource", this.dataSource);
        }
        if (null != this.useDatabaseLock) {
            properties.put("UseDatabaseLock", this.useDatabaseLock);
        }
        if ((brokerXmlConfig = this.getBrokerXmlConfig()) != null) {
            try {
                if (brokerXmlConfig.startsWith("broker:")) {
                    URISupport.CompositeData compositeData = URISupport.parseComposite(new URI(brokerXmlConfig));
                    if (!compositeData.getParameters().containsKey("persistent")) {
                        compositeData.getParameters().put("persistent", "false");
                    }
                    this.setBrokerXmlConfig(ActiveMQFactory.getBrokerMetaFile() + compositeData.toURI());
                } else if (brokerXmlConfig.toLowerCase().startsWith("xbean:")) {
                    this.setBrokerXmlConfig(ActiveMQFactory.getBrokerMetaFile() + brokerXmlConfig);
                }
            }
            catch (URISyntaxException e) {
                throw new ResourceAdapterInternalException("Invalid BrokerXmlConfig", (Throwable)e);
            }
        }
        ActiveMQFactory.setThreadProperties(properties);
        try {
            super.start(bootstrapContext);
        }
        finally {
            ActiveMQFactory.setThreadProperties(null);
            if (brokerXmlConfig != null) {
                this.setBrokerXmlConfig(brokerXmlConfig);
            }
        }
    }

    public void stop() {
        Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources").info("Stopping ActiveMQ");
        final ActiveMQResourceAdapter ra = this;
        Thread stopThread = new Thread("ActiveMQResourceAdapter stop"){

            @Override
            public void run() {
                try {
                    ra.stopImpl();
                }
                catch (Throwable t) {
                    Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources").error("ActiveMQ shutdown failed", t);
                }
            }
        };
        stopThread.setDaemon(true);
        stopThread.start();
        try {
            stopThread.join(10000L);
        }
        catch (InterruptedException ex) {
            Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources").warning("Gave up on ActiveMQ shutdown", ex);
            return;
        }
    }

    private void stopImpl() throws Exception {
        super.stop();
        Collection<BrokerService> brokers = ActiveMQFactory.getBrokers();
        Iterator<BrokerService> it = brokers.iterator();
        while (it.hasNext()) {
            try {
                it.next().waitUntilStopped();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            it.remove();
        }
        Scheduler.shutdown();
        Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources").info("Stopped ActiveMQ");
    }
}

