/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.openejb.util.Strings;

public class StringTemplate {
    public static final Pattern PATTERN = Pattern.compile("(\\{)((\\.|\\w)+)(})");
    private final String template;

    public StringTemplate(String template) {
        this.template = template;
    }

    public String apply(Map<String, String> map) {
        Matcher matcher = PATTERN.matcher(this.template);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            String key = matcher.group(2);
            String value = map.get(key);
            if (key.toLowerCase().endsWith(".lc")) {
                value = map.get(key.substring(0, key.length() - 3)).toLowerCase();
            } else if (key.toLowerCase().endsWith(".uc")) {
                value = map.get(key.substring(0, key.length() - 3)).toUpperCase();
            } else if (key.toLowerCase().endsWith(".cc")) {
                value = Strings.camelCase(map.get(key.substring(0, key.length() - 3)));
            }
            matcher.appendReplacement(buf, value);
        }
        matcher.appendTail(buf);
        return buf.toString();
    }
}

