/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Clob;
import org.apache.derby.client.am.ColumnMetaData;
import org.apache.derby.client.am.DateTime;
import org.apache.derby.client.am.DateTimeValue;
import org.apache.derby.client.am.Lob;
import org.apache.derby.client.am.ResultSet;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.net.FdocaConstants;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetPackageRequest;
import org.apache.derby.client.net.NetPreparedStatement;
import org.apache.derby.client.net.NetStatement;
import org.apache.derby.client.net.StatementRequestInterface;

public class NetStatementRequest
extends NetPackageRequest
implements StatementRequestInterface {
    ArrayList extdtaPositions_ = null;
    int overrideLid_ = 80;
    HashMap promototedParameters_ = new HashMap();

    NetStatementRequest(NetAgent netAgent, int n) {
        super(netAgent, n);
    }

    public void writeExecuteImmediate(NetStatement netStatement, String string, Section section) throws SqlException {
        this.buildEXCSQLIMM(section, false, 0L);
        this.buildSQLSTTcommandData(string);
    }

    public void writePrepareDescribeOutput(NetStatement netStatement, String string, Section section) throws SqlException {
        this.buildPRPSQLSTT(section, string, true, true, 4);
        if (netStatement.statement_.cursorAttributesToSendOnPrepare_ != null) {
            this.buildSQLATTRcommandData(netStatement.statement_.cursorAttributesToSendOnPrepare_);
        }
        this.buildSQLSTTcommandData(string);
    }

    public void writePrepare(NetStatement netStatement, String string, Section section) throws SqlException {
        this.buildPRPSQLSTT(section, string, false, false, 0);
        if (netStatement.statement_.cursorAttributesToSendOnPrepare_ != null) {
            this.buildSQLATTRcommandData(netStatement.statement_.cursorAttributesToSendOnPrepare_);
        }
        this.buildSQLSTTcommandData(string);
    }

    public void writeExecute(NetPreparedStatement netPreparedStatement, Section section, ColumnMetaData columnMetaData, Object[] objectArray, int n, boolean bl, boolean bl2) throws SqlException {
        this.buildEXCSQLSTT(section, true, bl, false, null, false, false, 0, false, 0, false, 0, false, 0);
        if (n > 0) {
            if (this.extdtaPositions_ != null && !this.extdtaPositions_.isEmpty()) {
                this.extdtaPositions_.clear();
            }
            boolean bl3 = this.buildSQLDTAcommandData(n, columnMetaData, objectArray);
            this.buildEXTDTA(columnMetaData, objectArray, bl2);
        }
    }

    public void writeOpenQuery(NetPreparedStatement netPreparedStatement, Section section, int n, int n2, int n3, ColumnMetaData columnMetaData, Object[] objectArray) throws SqlException {
        boolean bl = this.checkSendQryrowset(n, n2);
        n = this.checkFetchsize(n, n2);
        this.buildOPNQRY(section, bl, n);
        netPreparedStatement.qryrowsetSentOnOpnqry_ = bl;
        if (n3 > 0) {
            if (this.extdtaPositions_ != null && !this.extdtaPositions_.isEmpty()) {
                this.extdtaPositions_.clear();
            }
            boolean bl2 = this.buildSQLDTAcommandData(n3, columnMetaData, objectArray);
            this.buildEXTDTA(columnMetaData, objectArray, false);
        }
    }

    public void writeOpenQuery(NetStatement netStatement, Section section, int n, int n2) throws SqlException {
        boolean bl = this.checkSendQryrowset(n, n2);
        n = this.checkFetchsize(n, n2);
        this.buildOPNQRY(section, bl, n);
        netStatement.qryrowsetSentOnOpnqry_ = bl;
    }

    public void writeDescribeInput(NetPreparedStatement netPreparedStatement, Section section) throws SqlException {
        int n = 5;
        this.buildDSCSQLSTT(section, true, n);
    }

    public void writeDescribeOutput(NetPreparedStatement netPreparedStatement, Section section) throws SqlException {
        this.buildDSCSQLSTT(section, true, 4);
    }

    public void writeExecuteCall(NetStatement netStatement, boolean bl, String string, Section section, int n, boolean bl2, int n2, ColumnMetaData columnMetaData, Object[] objectArray) throws SqlException {
        boolean bl3 = true;
        n = n == 0 ? 64 : n;
        boolean bl4 = string != null;
        int n3 = columnMetaData != null ? columnMetaData.columns_ : 0;
        bl = n3 > 0;
        this.buildEXCSQLSTT(section, true, bl, bl4, string, true, !bl2, 65535, true, -1, true, this.calculateResultSetFlags(), bl3, n);
        if (n3 > 0) {
            if (this.extdtaPositions_ != null && !this.extdtaPositions_.isEmpty()) {
                this.extdtaPositions_.clear();
            }
            boolean bl5 = this.buildSQLDTAcommandData(n3, columnMetaData, objectArray);
            this.buildEXTDTA(columnMetaData, objectArray, false);
        }
        netStatement.qryrowsetSentOnOpnqry_ = bl3;
    }

    void buildOPNQRY(Section section, boolean bl, int n) throws SqlException {
        this.createCommand();
        this.markLengthBytes(8204);
        this.buildPKGNAMCSN(section);
        this.buildQRYBLKSZ();
        if (bl) {
            this.buildMAXBLKEXT(-1);
            this.buildQRYROWSET(n);
        }
        if (this.netAgent_.netConnection_.serverSupportsQryclsimp()) {
            this.buildQRYCLSIMP();
        }
        this.updateLengthBytes();
    }

    void buildEXCSQLIMM(Section section, boolean bl, long l) throws SqlException {
        this.createCommand();
        this.markLengthBytes(8202);
        this.buildPKGNAMCSN(section);
        this.buildRDBCMTOK();
        if (bl) {
            this.buildQRYINSID(l);
        }
        this.updateLengthBytes();
    }

    void buildPRPSQLSTT(Section section, String string, boolean bl, boolean bl2, int n) throws SqlException {
        this.createCommand();
        this.markLengthBytes(8205);
        this.buildPKGNAMCSN(section);
        if (bl) {
            this.buildRTNSQLDA();
        }
        if (bl2) {
            this.buildTYPSQLDA(n);
        }
        this.updateLengthBytes();
    }

    void buildEXCSQLSET(Section section) throws SqlException {
        this.createCommand();
        this.markLengthBytes(8212);
        this.buildPKGNAMCSN(section);
        this.updateLengthBytes();
    }

    void buildEXCSQLSTT(Section section, boolean bl, boolean bl2, boolean bl3, String string, boolean bl4, boolean bl5, int n, boolean bl6, int n2, boolean bl7, int n3, boolean bl8, int n4) throws SqlException {
        this.createCommand();
        this.markLengthBytes(8203);
        this.buildPKGNAMCSN(section);
        this.buildRDBCMTOK();
        if (bl) {
            this.buildOUTEXP(bl2);
        }
        if (bl4) {
            this.buildQRYBLKSZ();
        }
        if (bl8 && bl6) {
            this.buildMAXBLKEXT(n2);
        }
        if (bl5) {
            this.buildMAXRSLCNT(n);
        }
        if (bl7) {
            this.buildRSLSETFLG(n3);
        }
        if (bl8) {
            this.buildQRYROWSET(n4);
        }
        if (bl3) {
            this.buildPRCNAM(string);
        }
        this.updateLengthBytes();
    }

    void buildDSCSQLSTT(Section section, boolean bl, int n) throws SqlException {
        this.createCommand();
        this.markLengthBytes(8200);
        this.buildPKGNAMCSN(section);
        if (bl) {
            this.buildTYPSQLDA(n);
        }
        this.updateLengthBytes();
    }

    boolean buildSQLDTAcommandData(int n, ColumnMetaData columnMetaData, Object[] objectArray) throws SqlException {
        this.createEncryptedCommandData();
        int n2 = this.offset_;
        this.markLengthBytes(9234);
        int[][] nArray = this.allocateLidAndLengthsArray(columnMetaData);
        Hashtable hashtable = null;
        ArrayList arrayList = null;
        hashtable = this.computeProtocolTypesAndLengths(objectArray, columnMetaData, nArray, hashtable);
        boolean bl = false;
        this.buildFDODSC(n, nArray, bl, hashtable, arrayList);
        this.buildFDODTA(n, nArray, objectArray);
        this.updateLengthBytes();
        if (this.netAgent_.netConnection_.getSecurityMechanism() == 12 || this.netAgent_.netConnection_.getSecurityMechanism() == 13) {
            this.encryptDataStream(n2);
        }
        return bl;
    }

    private void buildFDODSC(int n, int[][] nArray, boolean bl, Hashtable hashtable, ArrayList arrayList) throws SqlException {
        this.markLengthBytes(16);
        this.buildSQLDTA(n, nArray, bl, hashtable, arrayList);
        this.updateLengthBytes();
    }

    protected void buildSQLDTA(int n, int[][] nArray, boolean bl, Hashtable hashtable, ArrayList arrayList) throws SqlException {
        if (bl) {
            this.buildMddOverrides(arrayList);
            this.writeBytes(FdocaConstants.MDD_SQLDTAGRP_TOSEND);
        }
        this.buildSQLDTAGRP(n, nArray, bl, hashtable);
        if (bl) {
            this.writeBytes(FdocaConstants.MDD_SQLDTA_TOSEND);
        }
        this.writeBytes(FdocaConstants.SQLDTA_RLO_TOSEND);
    }

    protected void buildSQLDTAGRP(int n, int[][] nArray, boolean bl, Hashtable hashtable) throws SqlException {
        int n2 = 0;
        int n3 = 0;
        n2 = this.calculateColumnsInSQLDTAGRPtriplet(n);
        this.buildTripletHeader(3 * n2 + 3, 118, 208);
        while (true) {
            this.writeLidAndLengths(nArray, n2, n3, bl, hashtable);
            if ((n -= n2) == 0) break;
            n3 += n2;
            n2 = this.calculateColumnsInSQLDTAGRPtriplet(n);
            this.buildTripletHeader(3 * n2 + 3, 127, 0);
        }
    }

    protected void buildOUTOVR(ResultSet resultSet, ColumnMetaData columnMetaData) throws SqlException {
        this.createCommandData();
        this.markLengthBytes(9237);
        int[][] nArray = this.calculateOUTOVRLidAndLengthOverrides(resultSet, columnMetaData);
        this.buildSQLDTARD(columnMetaData.columns_, nArray);
        this.updateLengthBytes();
    }

    private int[][] calculateOUTOVRLidAndLengthOverrides(ResultSet resultSet, ColumnMetaData columnMetaData) {
        int n = columnMetaData.columns_;
        int[][] nArray = new int[n][2];
        block4: for (int i = 0; i < n; ++i) {
            switch (columnMetaData.types_[i]) {
                case 2004: {
                    nArray[i][0] = columnMetaData.nullable_[i] ? 25 : 24;
                    nArray[i][1] = 4;
                    continue block4;
                }
                case 2005: {
                    nArray[i][0] = columnMetaData.nullable_[i] ? 27 : 26;
                    nArray[i][1] = 4;
                }
            }
        }
        return nArray;
    }

    protected void buildSQLDTARD(int n, int[][] nArray) throws SqlException {
        this.buildSQLCADTA(n, nArray);
        this.writeBytes(FdocaConstants.SQLDTARD_RLO_TOSEND);
    }

    protected void buildSQLCADTA(int n, int[][] nArray) throws SqlException {
        this.buildSQLDTAGRP(n, nArray, false, null);
        this.writeBytes(FdocaConstants.SQLCADTA_RLO_TOSEND);
    }

    private void buildFDODTA(int n, int[][] nArray, Object[] objectArray) throws SqlException {
        try {
            Object object = null;
            this.markLengthBytes(5242);
            this.write1Byte(0);
            block27: for (int i = 0; i < n; ++i) {
                if (objectArray[i] == null) {
                    if (nArray[i][0] % 2 != 1) continue;
                    this.write1Byte(255);
                    continue;
                }
                if (nArray[i][0] % 2 == 1) {
                    this.write1Byte(0);
                }
                switch (nArray[i][0] | 1) {
                    case 63: 
                    case 65: {
                        object = this.retrievePromotedParameterIfExists(i);
                        if (object == null) {
                            this.writeSingleorMixedCcsidLDString((String)objectArray[i], this.netAgent_.typdef_.getCcsidMbcEncoding());
                            continue block27;
                        }
                        this.setFDODTALob(this.netAgent_.netConnection_.getSecurityMechanism(), (Clob)object, nArray, i);
                        continue block27;
                    }
                    case 51: 
                    case 53: {
                        object = this.retrievePromotedParameterIfExists(i);
                        if (object == null) continue block27;
                        this.setFDODTALob(this.netAgent_.netConnection_.getSecurityMechanism(), (Clob)object, nArray, i);
                        continue block27;
                    }
                    case 191: {
                        this.writeBoolean((Boolean)objectArray[i]);
                        continue block27;
                    }
                    case 3: {
                        this.writeIntFdocaData((Integer)objectArray[i]);
                        continue block27;
                    }
                    case 5: {
                        this.writeShortFdocaData((Short)objectArray[i]);
                        continue block27;
                    }
                    case 13: {
                        this.writeFloat(((Float)objectArray[i]).floatValue());
                        continue block27;
                    }
                    case 11: {
                        this.writeDouble((Double)objectArray[i]);
                        continue block27;
                    }
                    case 15: {
                        this.writeBigDecimal((BigDecimal)objectArray[i], nArray[i][1] >> 8 & 0xFF, nArray[i][1] & 0xFF);
                        continue block27;
                    }
                    case 33: {
                        DateTimeValue dateTimeValue = objectArray[i] instanceof Date ? new DateTimeValue((Date)objectArray[i]) : (DateTimeValue)objectArray[i];
                        this.writeDate(dateTimeValue);
                        continue block27;
                    }
                    case 35: {
                        DateTimeValue dateTimeValue = objectArray[i] instanceof Time ? new DateTimeValue((Time)objectArray[i]) : (DateTimeValue)objectArray[i];
                        this.writeTime(dateTimeValue);
                        continue block27;
                    }
                    case 37: {
                        DateTimeValue dateTimeValue = objectArray[i] instanceof Timestamp ? new DateTimeValue((Timestamp)objectArray[i]) : (DateTimeValue)objectArray[i];
                        this.writeTimestamp(dateTimeValue);
                        continue block27;
                    }
                    case 23: {
                        this.writeLongFdocaData((Long)objectArray[i]);
                        continue block27;
                    }
                    case 41: 
                    case 43: {
                        object = this.retrievePromotedParameterIfExists(i);
                        if (object == null) {
                            this.writeLDBytes((byte[])objectArray[i]);
                            continue block27;
                        }
                        this.setFDODTALob(this.netAgent_.netConnection_.getSecurityMechanism(), (Clob)object, nArray, i);
                        continue block27;
                    }
                    case 81: {
                        this.writeUDT(objectArray[i]);
                        continue block27;
                    }
                    case 203: 
                    case 205: {
                        long l;
                        Object object2;
                        object = this.retrievePromotedParameterIfExists(i);
                        if (object == null) {
                            try {
                                object2 = (java.sql.Clob)objectArray[i];
                                if (object2 instanceof Clob && ((Clob)object2).willBeLayerBStreamed()) {
                                    this.setFDODTALobLengthUnknown(i);
                                    continue block27;
                                }
                                l = object2.length();
                                this.setFDODTALobLength(nArray, i, l);
                                continue block27;
                            }
                            catch (SQLException sQLException) {
                                throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN009.S"), sQLException);
                            }
                        }
                        this.setFDODTALob(this.netAgent_.netConnection_.getSecurityMechanism(), (Clob)object, nArray, i);
                        continue block27;
                    }
                    case 201: {
                        long l;
                        Object object2;
                        object = this.retrievePromotedParameterIfExists(i);
                        if (object == null) {
                            try {
                                object2 = (Blob)objectArray[i];
                                if (object2 instanceof org.apache.derby.client.am.Blob && ((org.apache.derby.client.am.Blob)object2).willBeLayerBStreamed()) {
                                    this.setFDODTALobLengthUnknown(i);
                                    continue block27;
                                }
                                l = object2.length();
                                this.setFDODTALobLength(nArray, i, l);
                                continue block27;
                            }
                            catch (SQLException sQLException) {
                                throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN009.S"), sQLException);
                            }
                        }
                        this.setFDODTALob(this.netAgent_.netConnection_.getSecurityMechanism(), (org.apache.derby.client.am.Blob)object, nArray, i);
                        continue block27;
                    }
                    case 207: {
                        Object object2;
                        object = this.retrievePromotedParameterIfExists(i);
                        if (object == null) {
                            object2 = (Clob)objectArray[i];
                            if (((Clob)object2).isString()) {
                                this.setFDODTALobLength(nArray, i, ((Clob)object2).getUTF8Length());
                                continue block27;
                            }
                            if (!((Lob)object2).willBeLayerBStreamed()) {
                                this.setFDODTALobLength(nArray, i, ((Clob)object2).length());
                                continue block27;
                            }
                            this.setFDODTALobLengthUnknown(i);
                            continue block27;
                        }
                        this.setFDODTALob(this.netAgent_.netConnection_.getSecurityMechanism(), (Clob)object, nArray, i);
                        continue block27;
                    }
                    case 25: {
                        this.writeIntFdocaData(((org.apache.derby.client.am.Blob)objectArray[i]).getLocator());
                        continue block27;
                    }
                    case 27: {
                        this.writeIntFdocaData(((Clob)objectArray[i]).getLocator());
                        continue block27;
                    }
                    default: {
                        throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("22005.S.4"), (Object)new Integer(nArray[i][0]), (Object)new Integer(n), new Integer(i));
                    }
                }
            }
            this.updateLengthBytes();
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
    }

    private void buildEXTDTA(ColumnMetaData columnMetaData, Object[] objectArray, boolean bl) throws SqlException {
        try {
            if (this.extdtaPositions_ != null) {
                for (int i = 0; i < this.extdtaPositions_.size(); ++i) {
                    boolean bl2;
                    org.apache.derby.client.am.Blob blob;
                    Lob lob;
                    int n;
                    boolean bl3;
                    boolean bl4;
                    int n2 = (Integer)this.extdtaPositions_.get(i);
                    if (i != this.extdtaPositions_.size() - 1) {
                        bl4 = true;
                        bl3 = true;
                    } else {
                        bl4 = bl;
                        bl3 = false;
                    }
                    boolean bl5 = false;
                    if (columnMetaData.nullable_[n2]) {
                        bl5 = true;
                    }
                    if ((n = columnMetaData.clientParamtertype_[n2]) == 0) {
                        n = columnMetaData.types_[n2];
                    }
                    if (n == 2004 || n == -2 || n == -3 || n == -4) {
                        lob = (org.apache.derby.client.am.Blob)this.retrievePromotedParameterIfExists(n2);
                        blob = lob == null ? (Blob)objectArray[n2] : lob;
                        boolean bl6 = bl2 = !(blob instanceof org.apache.derby.client.am.Blob);
                        if (bl2) {
                            try {
                                this.writeScalarStream(bl4, bl3, 5228, (long)((int)blob.length()), blob.getBinaryStream(), bl5, n2 + 1);
                                continue;
                            }
                            catch (SQLException sQLException) {
                                throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN009.S"), sQLException);
                            }
                        }
                        if (blob.isBinaryStream()) {
                            if (blob.willBeLayerBStreamed()) {
                                this.writeScalarStream(bl4, bl3, 5228, blob.getBinaryStream(), bl5, n2 + 1);
                                continue;
                            }
                            this.writeScalarStream(bl4, bl3, 5228, (long)((int)blob.length()), blob.getBinaryStream(), bl5, n2 + 1);
                            continue;
                        }
                        this.writeScalarStream(bl4, bl3, 5228, (long)((int)blob.length()), blob.getBinaryStream(), bl5, n2 + 1);
                        continue;
                    }
                    if (n != 2005 && n != 1 && n != 12 && n != -1) continue;
                    lob = (Clob)this.retrievePromotedParameterIfExists(n2);
                    blob = lob == null ? (java.sql.Clob)objectArray[n2] : lob;
                    boolean bl7 = bl2 = !(blob instanceof Clob);
                    if (bl2) {
                        try {
                            this.writeScalarStream(bl4, bl3, 5228, (int)blob.length(), blob.getCharacterStream(), bl5, n2 + 1);
                            continue;
                        }
                        catch (SQLException sQLException) {
                            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN009.S"), sQLException);
                        }
                    }
                    if (((Clob)((Object)blob)).isCharacterStream()) {
                        if (((Clob)((Object)blob)).willBeLayerBStreamed()) {
                            this.writeScalarStream(bl4, bl3, 5228, ((Clob)((Object)blob)).getCharacterStream(), bl5, n2 + 1);
                            continue;
                        }
                        this.writeScalarStream(bl4, bl3, 5228, (int)((Clob)((Object)blob)).length(), ((Clob)((Object)blob)).getCharacterStream(), bl5, n2 + 1);
                        continue;
                    }
                    if (((Clob)((Object)blob)).isAsciiStream()) {
                        if (((Clob)((Object)blob)).willBeLayerBStreamed()) {
                            this.writeScalarStream(bl4, bl3, 5228, ((Clob)((Object)blob)).getAsciiStream(), bl5, n2 + 1);
                            continue;
                        }
                        this.writeScalarStream(bl4, bl3, 5228, (long)((int)((Clob)((Object)blob)).length()), ((Clob)((Object)blob)).getAsciiStream(), bl5, n2 + 1);
                        continue;
                    }
                    if (((Clob)((Object)blob)).isUnicodeStream()) {
                        if (((Clob)((Object)blob)).willBeLayerBStreamed()) {
                            this.writeScalarStream(bl4, bl3, 5228, ((Clob)((Object)blob)).getUnicodeStream(), bl5, n2 + 1);
                            continue;
                        }
                        this.writeScalarStream(bl4, bl3, 5228, (long)((int)((Clob)((Object)blob)).length()), ((Clob)((Object)blob)).getUnicodeStream(), bl5, n2 + 1);
                        continue;
                    }
                    this.writeScalarStream(bl4, bl3, 5228, (long)((Clob)((Object)blob)).getUTF8Length(), new ByteArrayInputStream(((Clob)((Object)blob)).getUtf8String()), bl5, n2 + 1);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
    }

    private Object retrievePromotedParameterIfExists(int n) {
        if (this.promototedParameters_.isEmpty()) {
            return null;
        }
        return this.promototedParameters_.get(new Integer(n));
    }

    private int calculateColumnsInSQLDTAGRPtriplet(int n) {
        if (n > 84) {
            return 84;
        }
        return n;
    }

    private Hashtable computeProtocolTypesAndLengths(Object[] objectArray, ColumnMetaData columnMetaData, int[][] nArray, Hashtable hashtable) throws SqlException {
        try {
            int n = columnMetaData.columns_;
            String string = null;
            if (!this.promototedParameters_.isEmpty()) {
                this.promototedParameters_.clear();
            }
            for (int i = 0; i < n; ++i) {
                int n2 = columnMetaData.clientParamtertype_[i];
                if (n2 == 0) {
                    n2 = columnMetaData.types_[i];
                }
                if (n2 == 0) {
                    throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("22005.S.5"), new Integer(i));
                }
                switch (n2) {
                    case 1: 
                    case 12: {
                        string = (String)objectArray[i];
                        if (string == null || string.length() <= 10922) {
                            nArray[i][0] = 63;
                            nArray[i][1] = Short.MAX_VALUE;
                            break;
                        }
                        Object object = null;
                        byte[] byArray = null;
                        try {
                            byArray = string.getBytes("UTF-8");
                            object = new ByteArrayInputStream(byArray);
                            Clob clob = new Clob((Agent)this.netAgent_, (InputStream)object, "UTF-8", byArray.length);
                            this.promototedParameters_.put(new Integer(i), clob);
                            nArray[i][0] = 207;
                            if (clob.willBeLayerBStreamed()) {
                                nArray[i][1] = 32770;
                                break;
                            }
                            nArray[i][1] = this.buildPlaceholderLength(clob.length());
                            break;
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"byte array", (Object)"Clob", (Throwable)unsupportedEncodingException);
                        }
                    }
                    case 4: {
                        nArray[i][0] = 3;
                        nArray[i][1] = 4;
                        break;
                    }
                    case -7: 
                    case 16: {
                        if (this.netAgent_.netConnection_.databaseMetaData_.serverSupportsBooleanParameterTransport()) {
                            nArray[i][0] = 191;
                            nArray[i][1] = 1;
                            break;
                        }
                        nArray[i][0] = 5;
                        nArray[i][1] = 2;
                        break;
                    }
                    case -6: 
                    case 5: {
                        nArray[i][0] = 5;
                        nArray[i][1] = 2;
                        break;
                    }
                    case 7: {
                        nArray[i][0] = 13;
                        nArray[i][1] = 4;
                        break;
                    }
                    case 6: 
                    case 8: {
                        nArray[i][0] = 11;
                        nArray[i][1] = 8;
                        break;
                    }
                    case 2: 
                    case 3: {
                        int n3;
                        int n4;
                        Object object = (BigDecimal)objectArray[i];
                        if (object == null) {
                            n4 = 0;
                            n3 = 1;
                        } else {
                            if (((BigDecimal)object).scale() < 0) {
                                objectArray[i] = object = ((BigDecimal)object).setScale(0);
                            }
                            n4 = ((BigDecimal)object).scale();
                            n3 = Utils.computeBigDecimalPrecision((BigDecimal)object);
                        }
                        nArray[i][0] = 15;
                        nArray[i][1] = (n3 << 8) + (n4 << 0);
                        break;
                    }
                    case 91: {
                        nArray[i][0] = 33;
                        nArray[i][1] = 10;
                        break;
                    }
                    case 92: {
                        nArray[i][0] = 35;
                        nArray[i][1] = 8;
                        break;
                    }
                    case 93: {
                        nArray[i][0] = 37;
                        nArray[i][1] = DateTime.getTimestampLength(this.netAgent_.netConnection_.serverSupportsTimestampNanoseconds());
                        break;
                    }
                    case -5: {
                        nArray[i][0] = 23;
                        nArray[i][1] = 8;
                        break;
                    }
                    case -1: {
                        java.sql.Clob clob;
                        string = (String)objectArray[i];
                        if (string == null || string.length() <= 10922) {
                            nArray[i][0] = 65;
                            nArray[i][1] = Short.MAX_VALUE;
                            break;
                        }
                        Object object = null;
                        Object object2 = null;
                        try {
                            object2 = string.getBytes("UTF-8");
                            object = new ByteArrayInputStream((byte[])object2);
                            clob = new Clob((Agent)this.netAgent_, (InputStream)object, "UTF-8", ((Object)object2).length);
                            this.promototedParameters_.put(new Integer(i), clob);
                            nArray[i][0] = 207;
                            nArray[i][1] = this.buildPlaceholderLength(((Clob)clob).length());
                            break;
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"byte array", "Clob");
                        }
                    }
                    case -3: 
                    case -2: {
                        Object object = (byte[])objectArray[i];
                        if (object == null) {
                            nArray[i][0] = 41;
                            nArray[i][1] = Short.MAX_VALUE;
                            break;
                        }
                        if (((byte[])object).length <= Short.MAX_VALUE) {
                            nArray[i][0] = 41;
                            nArray[i][1] = Short.MAX_VALUE;
                            break;
                        }
                        Object object2 = new org.apache.derby.client.am.Blob((byte[])object, this.netAgent_, 0);
                        this.promototedParameters_.put(new Integer(i), object2);
                        nArray[i][0] = 201;
                        nArray[i][1] = this.buildPlaceholderLength(((byte[])object).length);
                        break;
                    }
                    case -4: {
                        Object object = (byte[])objectArray[i];
                        if (object == null) {
                            nArray[i][0] = 43;
                            nArray[i][1] = Short.MAX_VALUE;
                            break;
                        }
                        if (((byte[])object).length <= Short.MAX_VALUE) {
                            nArray[i][0] = 43;
                            nArray[i][1] = Short.MAX_VALUE;
                            break;
                        }
                        Object object2 = new org.apache.derby.client.am.Blob((byte[])object, this.netAgent_, 0);
                        this.promototedParameters_.put(new Integer(i), object2);
                        nArray[i][0] = 201;
                        nArray[i][1] = this.buildPlaceholderLength(((byte[])object).length);
                        break;
                    }
                    case 2000: {
                        nArray[i][0] = 81;
                        nArray[i][1] = Short.MAX_VALUE;
                        break;
                    }
                    case 2004: {
                        Object object2 = (Blob)objectArray[i];
                        if (object2 == null) {
                            nArray[i][0] = 201;
                            nArray[i][1] = this.buildPlaceholderLength(columnMetaData.sqlLength_[i]);
                            break;
                        }
                        if (object2 instanceof org.apache.derby.client.am.Blob && ((org.apache.derby.client.am.Blob)object2).isLocator()) {
                            nArray[i][0] = 25;
                            nArray[i][1] = 4;
                            break;
                        }
                        nArray[i][0] = 201;
                        try {
                            if (object2 instanceof org.apache.derby.client.am.Blob && ((org.apache.derby.client.am.Blob)object2).willBeLayerBStreamed()) {
                                nArray[i][1] = 32770;
                                break;
                            }
                            nArray[i][1] = this.buildPlaceholderLength(object2.length());
                            break;
                        }
                        catch (SQLException sQLException) {
                            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN009.S"), sQLException);
                        }
                    }
                    case 2005: {
                        java.sql.Clob clob = (java.sql.Clob)objectArray[i];
                        boolean bl = !(clob instanceof Clob);
                        long l = 0L;
                        boolean bl2 = false;
                        if (clob == null) {
                            l = columnMetaData.sqlLength_[i];
                        } else if (clob instanceof Clob && ((Clob)clob).isLocator()) {
                            nArray[i][0] = 27;
                            nArray[i][1] = 4;
                        } else if (bl) {
                            try {
                                l = clob.length();
                            }
                            catch (SQLException sQLException) {
                                throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN009.S"), sQLException);
                            }
                        } else if (((Clob)clob).willBeLayerBStreamed()) {
                            bl2 = true;
                        } else {
                            l = ((Clob)clob).length();
                        }
                        if (clob == null) {
                            nArray[i][0] = 207;
                            nArray[i][1] = this.buildPlaceholderLength(l);
                            break;
                        }
                        if (bl) {
                            nArray[i][0] = 205;
                            nArray[i][1] = this.buildPlaceholderLength(l);
                            break;
                        }
                        if (((Clob)clob).isCharacterStream()) {
                            nArray[i][0] = 205;
                            if (bl2) {
                                nArray[i][1] = 32770;
                                break;
                            }
                            nArray[i][1] = this.buildPlaceholderLength(l);
                            break;
                        }
                        if (((Clob)clob).isUnicodeStream()) {
                            nArray[i][0] = 207;
                            if (bl2) {
                                nArray[i][1] = 32770;
                                break;
                            }
                            nArray[i][1] = this.buildPlaceholderLength(l);
                            break;
                        }
                        if (((Clob)clob).isAsciiStream()) {
                            nArray[i][0] = 203;
                            if (bl2) {
                                nArray[i][1] = 32770;
                                break;
                            }
                            nArray[i][1] = this.buildPlaceholderLength(l);
                            break;
                        }
                        if (!((Clob)clob).isString()) break;
                        nArray[i][0] = 207;
                        if (bl2) {
                            nArray[i][1] = 32770;
                            break;
                        }
                        nArray[i][1] = this.buildPlaceholderLength(l);
                        break;
                    }
                    default: {
                        throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("22005.S.6"), new Integer(n2));
                    }
                }
                if (columnMetaData.nullable_[i]) continue;
                int[] nArray2 = nArray[i];
                nArray2[0] = nArray2[0] - 1;
            }
            return hashtable;
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
    }

    private int buildPlaceholderLength(long l) {
        if (l < 32767L) {
            return 32770;
        }
        if (l < Integer.MAX_VALUE) {
            return 32772;
        }
        if (l < 0x7FFFFFFFFFFFL) {
            return 32774;
        }
        return 32776;
    }

    private void buildOUTEXP(boolean bl) throws SqlException {
        if (bl) {
            this.writeScalar1Byte(8465, -15);
        }
    }

    void buildMAXBLKEXT(int n) throws SqlException {
        if (n != 0) {
            this.writeScalar2Bytes(8513, n);
        }
    }

    void buildQRYROWSET(int n) throws SqlException {
        this.writeScalar4Bytes(8534, n);
    }

    private void buildPRCNAM(String string) throws SqlException {
        if (string == null) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN010.S"));
        }
        int n = string.length();
        if (n == 0 || n > 255) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN011.S"), (Object)new Integer(n), new Integer(255));
        }
        this.writeScalarString(8504, string);
    }

    void buildQRYBLKSZ() throws SqlException {
        this.writeScalar4Bytes(8468, 32767L);
    }

    private void buildMAXRSLCNT(int n) throws SqlException {
        if (n == 0) {
            return;
        }
        this.writeScalar2Bytes(8512, n);
    }

    private void buildRDBCMTOK() throws SqlException {
        this.writeScalar1Byte(8453, -15);
    }

    private void buildRSLSETFLG(int n) throws SqlException {
        this.writeScalar1Byte(8514, n);
    }

    void buildQRYINSID(long l) throws SqlException {
        this.markLengthBytes(8539);
        this.writeLong(l);
        this.updateLengthBytes();
    }

    private void buildRTNSQLDA() throws SqlException {
        this.writeScalar1Byte(8470, -15);
    }

    private void buildTYPSQLDA(int n) throws SqlException {
        if (n != 0) {
            this.writeScalar1Byte(8518, n);
        }
    }

    private void buildQRYCLSIMP() {
        this.writeScalar1Byte(8541, 1);
    }

    private void setFDODTALobLength(int[][] nArray, int n, long l) throws SqlException {
        if (nArray[n][1] == 32770) {
            this.writeShort((short)l);
        } else if (nArray[n][1] == 32772) {
            this.writeInt((int)l);
        } else if (nArray[n][1] == 32774) {
            this.writeLong6Bytes(l);
        } else if (nArray[n][1] == 32776) {
            this.writeLong(l);
        }
        if (l != 0L) {
            if (this.extdtaPositions_ == null) {
                this.extdtaPositions_ = new ArrayList();
            }
            this.extdtaPositions_.add(new Integer(n));
        }
    }

    private void setFDODTALobLengthUnknown(int n) throws SqlException {
        int n2 = 1;
        short s = (short)(n2 << 15);
        n2 = s;
        this.writeShort(s);
        if (this.extdtaPositions_ == null) {
            this.extdtaPositions_ = new ArrayList();
        }
        this.extdtaPositions_.add(new Integer(n));
    }

    private boolean checkSendQryrowset(int n, int n2) {
        boolean bl = false;
        if (n2 != 1003) {
            bl = true;
        }
        return bl;
    }

    private int checkFetchsize(int n, int n2) {
        if (n2 != 1003 && n == 0) {
            n = 64;
        }
        return n;
    }

    private int calculateResultSetFlags() {
        return 4;
    }

    public void writeSetSpecialRegister(Section section, ArrayList arrayList) throws SqlException {
        this.buildEXCSQLSET(section);
        for (int i = 0; i < arrayList.size(); ++i) {
            this.buildSQLSTTcommandData((String)arrayList.get(i));
        }
    }

    private int[][] allocateLidAndLengthsArray(ColumnMetaData columnMetaData) {
        int n = columnMetaData.columns_;
        int[][] nArray = columnMetaData.protocolTypesCache_;
        if (nArray == null || nArray.length != n) {
            columnMetaData.protocolTypesCache_ = nArray = new int[n][2];
        }
        return nArray;
    }

    private void buildMddOverrides(ArrayList arrayList) throws SqlException {
        for (int i = 0; i < arrayList.size(); ++i) {
            byte[] byArray = (byte[])arrayList.get(i);
            this.writeBytes(byArray);
        }
    }

    private int getNextOverrideLid() {
        return this.overrideLid_++;
    }

    private void setFDODTALob(int n, Lob lob, int[][] nArray, int n2) throws SqlException, SQLException {
        if (lob.willBeLayerBStreamed()) {
            this.setFDODTALobLengthUnknown(n2);
        } else {
            this.setFDODTALobLength(nArray, n2, lob.length());
        }
    }
}

