/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.FileContainer;
import org.apache.derby.io.StorageFile;

final class InputStreamContainer
extends FileContainer {
    private StorageFile containerPath;

    InputStreamContainer(BaseDataFileFactory baseDataFileFactory) {
        super(baseDataFileFactory);
        this.canUpdate = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final boolean openContainer(ContainerKey containerKey) throws StandardException {
        boolean bl;
        FilterInputStream filterInputStream = null;
        try {
            try {
                InputStream inputStream = null;
                this.containerPath = this.dataFactory.getContainerPath(containerKey, false);
                try {
                    inputStream = this.containerPath.getInputStream();
                }
                catch (IOException iOException) {
                    this.containerPath = this.dataFactory.getContainerPath(containerKey, true);
                    try {
                        inputStream = this.getInputStream();
                    }
                    catch (IOException iOException2) {
                        this.containerPath = null;
                        boolean bl2 = false;
                        Object var8_9 = null;
                        if (filterInputStream == null) return bl2;
                        try {
                            filterInputStream.close();
                            return bl2;
                        }
                        catch (IOException iOException3) {
                            // empty catch block
                        }
                        return bl2;
                    }
                }
                filterInputStream = new DataInputStream(inputStream);
                this.readHeader(this.getEmbryonicPage((DataInput)((Object)filterInputStream)));
                bl = true;
                Object var8_10 = null;
                if (filterInputStream == null) return bl;
            }
            catch (IOException iOException) {
                throw StandardException.newException("XSDG3.D", iOException, (Object)new Object[]{this.getIdentity().toString(), "open", containerKey.toString()});
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (filterInputStream == null) throw throwable;
            try {}
            catch (IOException iOException4) {
                throw throwable;
            }
            filterInputStream.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return bl;
        }
        filterInputStream.close();
        return bl;
    }

    void closeContainer() {
        this.containerPath = null;
    }

    public final void clean(boolean bl) throws StandardException {
    }

    protected final int preAllocate(long l, int n) {
        return 0;
    }

    protected void truncatePages(long l) {
    }

    void createContainer(ContainerKey containerKey) throws StandardException {
    }

    protected final void removeContainer(LogInstant logInstant, boolean bl) throws StandardException {
    }

    protected final void readPage(long l, byte[] byArray) throws IOException, StandardException {
        long l2 = l * (long)this.pageSize;
        this.readPositionedPage(l2, byArray);
        if (this.dataFactory.databaseEncrypted() && l != 0L) {
            this.decryptPage(byArray, this.pageSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void readPositionedPage(long l, byte[] byArray) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStream();
            InputStreamUtil.skipFully(inputStream, l);
            InputStreamUtil.readFully(inputStream, byArray, 0, this.pageSize);
            inputStream.close();
            return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected final void writePage(long l, byte[] byArray, boolean bl) throws IOException, StandardException {
    }

    protected final void flushAll() {
    }

    protected InputStream getInputStream() throws IOException {
        return this.containerPath.getInputStream();
    }

    protected void backupContainer(BaseContainerHandle baseContainerHandle, String string) throws StandardException {
        throw StandardException.newException("XSAI3.S");
    }

    protected void encryptContainer(BaseContainerHandle baseContainerHandle, String string) throws StandardException {
        throw StandardException.newException("XSAI3.S");
    }
}

