/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.recipe;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.xbean.recipe.AbstractRecipe;
import org.apache.xbean.recipe.ConstructionException;
import org.apache.xbean.recipe.ExecutionContext;
import org.apache.xbean.recipe.Option;
import org.apache.xbean.recipe.Recipe;
import org.apache.xbean.recipe.RecipeHelper;
import org.apache.xbean.recipe.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionRecipe
extends AbstractRecipe {
    private final List<Object> list;
    private String typeName;
    private Class typeClass;
    private final EnumSet<Option> options = EnumSet.noneOf(Option.class);

    public CollectionRecipe() {
        this.list = new ArrayList<Object>();
    }

    public CollectionRecipe(String type) {
        this.list = new ArrayList<Object>();
        this.typeName = type;
    }

    public CollectionRecipe(Class type) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        this.list = new ArrayList<Object>();
        this.typeClass = type;
    }

    public CollectionRecipe(Collection<?> collection) {
        if (collection == null) {
            throw new NullPointerException("collection is null");
        }
        this.list = new ArrayList(collection);
        this.typeClass = RecipeHelper.hasDefaultConstructor(collection.getClass()) ? collection.getClass() : (collection instanceof SortedSet ? SortedSet.class : (collection instanceof Set ? Set.class : (collection instanceof List ? List.class : Collection.class)));
    }

    public CollectionRecipe(CollectionRecipe collectionRecipe) {
        if (collectionRecipe == null) {
            throw new NullPointerException("setRecipe is null");
        }
        this.typeName = collectionRecipe.typeName;
        this.typeClass = collectionRecipe.typeClass;
        this.list = new ArrayList<Object>(collectionRecipe.list);
    }

    public void allow(Option option) {
        this.options.add(option);
    }

    public void disallow(Option option) {
        this.options.remove((Object)option);
    }

    @Override
    public List<Recipe> getNestedRecipes() {
        ArrayList<Recipe> nestedRecipes = new ArrayList<Recipe>(this.list.size());
        for (Object o : this.list) {
            if (!(o instanceof Recipe)) continue;
            Recipe recipe = (Recipe)o;
            nestedRecipes.add(recipe);
        }
        return nestedRecipes;
    }

    @Override
    public List<Recipe> getConstructorRecipes() {
        if (!this.options.contains((Object)Option.LAZY_ASSIGNMENT)) {
            return this.getNestedRecipes();
        }
        return Collections.emptyList();
    }

    @Override
    public boolean canCreate(Type expectedType) {
        Class myType = this.getType(expectedType);
        return RecipeHelper.isAssignable(expectedType, myType);
    }

    @Override
    protected Object internalCreate(Type expectedType, boolean lazyRefAllowed) throws ConstructionException {
        Object o;
        Class type = this.getType(expectedType);
        if (!RecipeHelper.hasDefaultConstructor(type)) {
            throw new ConstructionException("Type does not have a default constructor " + type.getName());
        }
        try {
            o = type.newInstance();
        }
        catch (Exception e) {
            throw new ConstructionException("Error while creating collection instance: " + type.getName());
        }
        if (!(o instanceof Collection)) {
            throw new ConstructionException("Specified collection type does not implement the Collection interface: " + type.getName());
        }
        Collection instance = (Collection)o;
        if (this.getName() != null) {
            ExecutionContext.getContext().addObject(this.getName(), instance);
        }
        Type[] typeParameters = RecipeHelper.getTypeParameters(Collection.class, expectedType);
        Object componentType = Object.class;
        if (typeParameters != null && typeParameters.length == 1 && typeParameters[0] instanceof Class) {
            componentType = typeParameters[0];
        }
        boolean refAllowed = this.options.contains((Object)Option.LAZY_ASSIGNMENT);
        int index = 0;
        for (Object value : this.list) {
            if ((value = RecipeHelper.convert((Type)componentType, value, refAllowed)) instanceof Reference) {
                Reference reference = (Reference)value;
                if (instance instanceof List) {
                    instance.add(null);
                    reference.setAction(new UpdateList((List)instance, index));
                } else {
                    reference.setAction(new UpdateCollection(instance));
                }
            } else {
                instance.add(value);
            }
            ++index;
        }
        return instance;
    }

    private Class getType(Type expectedType) {
        Class expectedClass = RecipeHelper.toClass(expectedType);
        if (this.typeClass != null || this.typeName != null) {
            Class type = this.typeClass;
            if (type == null) {
                try {
                    type = RecipeHelper.loadClass(this.typeName);
                }
                catch (ClassNotFoundException e) {
                    throw new ConstructionException("Type class could not be found: " + this.typeName);
                }
            }
            if (type.isAssignableFrom(expectedClass)) {
                return this.getCollection(expectedClass);
            }
            return this.getCollection(type);
        }
        return this.getCollection(expectedClass);
    }

    private Class getCollection(Class type) {
        if (RecipeHelper.hasDefaultConstructor(type)) {
            return type;
        }
        if (SortedSet.class.isAssignableFrom(type)) {
            return TreeSet.class;
        }
        if (Set.class.isAssignableFrom(type)) {
            return LinkedHashSet.class;
        }
        if (List.class.isAssignableFrom(type)) {
            return ArrayList.class;
        }
        return ArrayList.class;
    }

    public void add(Object value) {
        this.list.add(value);
    }

    public void addAll(Collection<?> value) {
        this.list.addAll(value);
    }

    public void remove(Object value) {
        this.list.remove(value);
    }

    public void removeAll(Object value) {
        this.list.remove(value);
    }

    public List<Object> getAll() {
        return Collections.unmodifiableList(this.list);
    }

    private static class UpdateCollection
    implements Reference.Action {
        private final Collection collection;

        public UpdateCollection(Collection collection) {
            this.collection = collection;
        }

        public void onSet(Reference ref) {
            this.collection.add(ref.get());
        }
    }

    private static class UpdateList
    implements Reference.Action {
        private final List list;
        private final int index;

        public UpdateList(List list, int index) {
            this.list = list;
            this.index = index;
        }

        public void onSet(Reference ref) {
            this.list.set(this.index, ref.get());
        }
    }
}

