/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal.bundle;

import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.osgi.framework.BundleClassLoaderUnavailableException;
import org.eclipse.virgo.kernel.osgi.framework.OsgiFramework;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.nano.serviceability.enforcement.NonNullAssertionEnforcer;
import org.eclipse.virgo.nano.shim.serviceability.TracingService;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BundleThreadContextManager {
    private static final String WRAPPED_NULL = "WRAPPED_NULL";
    private final Logger logger;
    private final Object monitor;
    private final OsgiFramework osgi;
    private final Bundle threadContextBundle;
    private final String scopeName;
    private final TracingService tracingService;
    private final ThreadLocal<BlockingDeque<ClassLoader>> contextClassLoaderStack;
    private final ThreadLocal<BlockingDeque<String>> applicationTraceNameStack;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    public BundleThreadContextManager(@NonNull OsgiFramework osgi, @NonNull Bundle threadContextBundle, String scopeName, @NonNull TracingService tracingService) {
        TracingService tracingService2 = tracingService;
        Bundle bundle = threadContextBundle;
        OsgiFramework osgiFramework = osgi;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)osgiFramework);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$2$ea5bfc82((Object)bundle);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$4$c122b91c((Object)tracingService2);
        try {
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.monitor = new Object();
            this.contextClassLoaderStack = new ContextClassLoaderStackThreadLocal(null);
            this.applicationTraceNameStack = new ApplicationTraceNameStackThreadLocal(null);
            this.osgi = osgi;
            this.threadContextBundle = threadContextBundle;
            this.scopeName = scopeName;
            this.tracingService = tracingService;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushThreadContext() {
        try {
            try {
                BundleThreadContextManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                Object object = this.monitor;
                synchronized (object) {
                    this.pushThreadContextClassLoader();
                    this.applicationTraceNameStack.get().push(this.wrapNull(this.tracingService.getCurrentApplicationName()));
                    this.tracingService.setCurrentApplicationName(this.scopeName);
                }
                BundleThreadContextManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return;
            }
            catch (Throwable throwable) {
                BundleThreadContextManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private String wrapNull(String string) {
        try {
            try {
                BundleThreadContextManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
                String string2 = string != null ? string : WRAPPED_NULL;
                BundleThreadContextManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
                return string2;
            }
            catch (Throwable throwable) {
                BundleThreadContextManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private String unwrapNull(String string) {
        try {
            try {
                BundleThreadContextManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
                String string2 = WRAPPED_NULL.equals(string) ? null : string;
                BundleThreadContextManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
                return string2;
            }
            catch (Throwable throwable) {
                BundleThreadContextManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popThreadContext() {
        try {
            try {
                BundleThreadContextManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_3);
                Object object = this.monitor;
                synchronized (object) {
                    this.popThreadContextClassLoader();
                    this.tracingService.setCurrentApplicationName(this.unwrapNull((String)this.applicationTraceNameStack.get().pop()));
                }
                BundleThreadContextManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_3);
                return;
            }
            catch (Throwable throwable) {
                BundleThreadContextManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_3);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void pushThreadContextClassLoader() {
        try {
            try {
                BundleThreadContextManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
                Thread currentThread = Thread.currentThread();
                ClassLoader oldContextClassLoader = currentThread.getContextClassLoader();
                this.contextClassLoaderStack.get().push(oldContextClassLoader);
                int state = this.threadContextBundle.getState();
                if (state != 2 && state != 1) {
                    ClassLoader newContextClassLoader = null;
                    try {
                        newContextClassLoader = this.osgi.getBundleClassLoader(this.threadContextBundle);
                    }
                    catch (BundleClassLoaderUnavailableException bundleClassLoaderUnavailableException) {
                        this.logger.info("Bundle class loader not available, it may not be resolved");
                    }
                    if (newContextClassLoader != null) {
                        currentThread.setContextClassLoader(newContextClassLoader);
                        this.logger.info("Thread context class loader '{}' pushed and set to '{}'", (Object)oldContextClassLoader, (Object)newContextClassLoader);
                    } else {
                        this.logger.info("Thread context class loader not found for bundle '{}'", (Object)this.threadContextBundle.getSymbolicName());
                    }
                }
                BundleThreadContextManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
                return;
            }
            catch (Throwable throwable) {
                BundleThreadContextManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void popThreadContextClassLoader() {
        try {
            try {
                BundleThreadContextManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
                Thread currentThread = Thread.currentThread();
                ClassLoader oldContextClassLoader = currentThread.getContextClassLoader();
                ClassLoader newContextClassLoader = (ClassLoader)this.contextClassLoaderStack.get().pop();
                currentThread.setContextClassLoader(newContextClassLoader);
                this.logger.info("Thread context class loader '{}' popped and set to '{}'", (Object)oldContextClassLoader, (Object)newContextClassLoader);
                BundleThreadContextManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
                return;
            }
            catch (Throwable throwable) {
                BundleThreadContextManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("BundleThreadContextManager.java", Class.forName("org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleThreadContextManager"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pushThreadContext", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleThreadContextManager", "", "", "", "void"), 87);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "wrapNull", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleThreadContextManager", "java.lang.String:", "string:", "", "java.lang.String"), 95);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "unwrapNull", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleThreadContextManager", "java.lang.String:", "string:", "", "java.lang.String"), 99);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "popThreadContext", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleThreadContextManager", "", "", "", "void"), 103);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "pushThreadContextClassLoader", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleThreadContextManager", "", "", "", "void"), 110);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "popThreadContextClassLoader", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleThreadContextManager", "", "", "", "void"), 133);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleThreadContextManager");
    }

    private static final class ApplicationTraceNameStackThreadLocal
    extends ThreadLocal<BlockingDeque<String>> {
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        private ApplicationTraceNameStackThreadLocal() {
            try {
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        @Override
        protected BlockingDeque<String> initialValue() {
            try {
                try {
                    ApplicationTraceNameStackThreadLocal.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
                    LinkedBlockingDeque<String> linkedBlockingDeque = new LinkedBlockingDeque<String>();
                    ApplicationTraceNameStackThreadLocal.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
                    return linkedBlockingDeque;
                }
                catch (Throwable throwable) {
                    ApplicationTraceNameStackThreadLocal.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
                    throw throwable;
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        /* synthetic */ ApplicationTraceNameStackThreadLocal(ApplicationTraceNameStackThreadLocal applicationTraceNameStackThreadLocal) {
            ApplicationTraceNameStackThreadLocal ajc$aspectInstance = this;
            try {
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        static {
            Factory factory = new Factory("BundleThreadContextManager.java", Class.forName("org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleThreadContextManager$ApplicationTraceNameStackThreadLocal"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "initialValue", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleThreadContextManager$ApplicationTraceNameStackThreadLocal", "", "", "", "java.util.concurrent.BlockingDeque"), 42);
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleThreadContextManager$ApplicationTraceNameStackThreadLocal");
        }
    }

    private static final class ContextClassLoaderStackThreadLocal
    extends ThreadLocal<BlockingDeque<ClassLoader>> {
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        private ContextClassLoaderStackThreadLocal() {
            try {
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        @Override
        protected BlockingDeque<ClassLoader> initialValue() {
            try {
                try {
                    ContextClassLoaderStackThreadLocal.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
                    LinkedBlockingDeque<ClassLoader> linkedBlockingDeque = new LinkedBlockingDeque<ClassLoader>();
                    ContextClassLoaderStackThreadLocal.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
                    return linkedBlockingDeque;
                }
                catch (Throwable throwable) {
                    ContextClassLoaderStackThreadLocal.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
                    throw throwable;
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        /* synthetic */ ContextClassLoaderStackThreadLocal(ContextClassLoaderStackThreadLocal contextClassLoaderStackThreadLocal) {
            ContextClassLoaderStackThreadLocal ajc$aspectInstance = this;
            try {
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        static {
            Factory factory = new Factory("BundleThreadContextManager.java", Class.forName("org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleThreadContextManager$ContextClassLoaderStackThreadLocal"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "initialValue", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleThreadContextManager$ContextClassLoaderStackThreadLocal", "", "", "", "java.util.concurrent.BlockingDeque"), 50);
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleThreadContextManager$ContextClassLoaderStackThreadLocal");
        }
    }
}

