/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.sql.LanguageFactory;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AggregateDefinition;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByColumn;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.MaxMinAggregateDefinition;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.ReplaceAggregatesWithCRVisitor;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.SubstituteExpressionVisitor;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;
import org.apache.derby.impl.sql.execute.AggregatorInfo;
import org.apache.derby.impl.sql.execute.AggregatorInfoList;

public class GroupByNode
extends SingleChildResultSetNode {
    GroupByList groupingList;
    Vector aggregateVector;
    private AggregatorInfoList aggInfo;
    FromTable parent;
    private boolean addDistinctAggregate;
    private boolean singleInputRowOptimization;
    private int addDistinctAggregateColumnNum;
    private boolean isInSortedOrder;
    private ValueNode havingClause;
    private SubqueryList havingSubquerys;

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) throws StandardException {
        super.init(object, object6);
        this.setLevel((Integer)object7);
        this.havingClause = (ValueNode)object4;
        this.havingSubquerys = (SubqueryList)object5;
        this.groupingList = (GroupByList)object2;
        this.aggregateVector = (Vector)object3;
        this.parent = this;
        ResultColumnList resultColumnList = this.childResult.getResultColumns().copyListAndObjects();
        this.resultColumns = this.childResult.getResultColumns();
        this.childResult.setResultColumns(resultColumnList);
        this.addAggregates();
        if (this.groupingList != null && this.groupingList.isRollup()) {
            this.resultColumns.setNullability(true);
            this.parent.getResultColumns().setNullability(true);
        }
        if (!this.addDistinctAggregate && object2 != null) {
            int n;
            ColumnReference[] columnReferenceArray = new ColumnReference[this.groupingList.size()];
            int n2 = this.groupingList.size();
            for (n = 0; n < n2; ++n) {
                GroupByColumn groupByColumn = (GroupByColumn)this.groupingList.elementAt(n);
                if (!(groupByColumn.getColumnExpression() instanceof ColumnReference)) {
                    this.isInSortedOrder = false;
                    break;
                }
                columnReferenceArray[n] = (ColumnReference)groupByColumn.getColumnExpression();
            }
            if (n == n2) {
                this.isInSortedOrder = this.childResult.isOrderedOn(columnReferenceArray, true, null);
            }
        }
    }

    boolean getIsInSortedOrder() {
        return this.isInSortedOrder;
    }

    private void addAggregates() throws StandardException {
        this.addNewPRNode();
        this.addNewColumnsForAggregation();
        this.addDistinctAggregatesToOrderBy();
    }

    private void addDistinctAggregatesToOrderBy() {
        int n = GroupByNode.numDistinctAggregates(this.aggregateVector);
        if (n != 0) {
            AggregatorInfo aggregatorInfo = null;
            int n2 = this.aggInfo.size();
            for (int i = 0; i < n2 && !(aggregatorInfo = (AggregatorInfo)this.aggInfo.elementAt(i)).isDistinct(); ++i) {
            }
            this.addDistinctAggregate = true;
            this.addDistinctAggregateColumnNum = aggregatorInfo.getInputColNum();
        }
    }

    private void addNewPRNode() throws StandardException {
        ResultColumnList resultColumnList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        int n = this.resultColumns.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.resultColumns.elementAt(i);
            if (resultColumn.isGenerated()) continue;
            resultColumnList.addElement(resultColumn);
        }
        resultColumnList.copyOrderBySelect(this.resultColumns);
        this.parent = (FromTable)this.getNodeFactory().getNode(151, this, resultColumnList, null, null, null, this.havingSubquerys, this.tableProperties, this.getContextManager());
        this.childResult.setResultColumns((ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager()));
        this.resultColumns = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
    }

    private ArrayList addUnAggColumns() throws StandardException {
        ResultColumnList resultColumnList = this.childResult.getResultColumns();
        ResultColumnList resultColumnList2 = this.resultColumns;
        ArrayList<SubstituteExpressionVisitor> arrayList = new ArrayList<SubstituteExpressionVisitor>();
        ArrayList<SubstituteExpressionVisitor> arrayList2 = null;
        if (this.havingClause != null) {
            arrayList2 = new ArrayList<SubstituteExpressionVisitor>();
        }
        int n = this.groupingList.size();
        for (int i = 0; i < n; ++i) {
            GroupByColumn groupByColumn = (GroupByColumn)this.groupingList.elementAt(i);
            ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, "##UnaggColumn", groupByColumn.getColumnExpression(), this.getContextManager());
            resultColumnList.addElement(resultColumn);
            resultColumn.markGenerated();
            resultColumn.bindResultColumnToExpression();
            resultColumn.setVirtualColumnId(resultColumnList.size());
            ResultColumn resultColumn2 = (ResultColumn)this.getNodeFactory().getNode(80, "##UnaggColumn", groupByColumn.getColumnExpression(), this.getContextManager());
            resultColumnList2.addElement(resultColumn2);
            resultColumn2.markGenerated();
            resultColumn2.bindResultColumnToExpression();
            resultColumn2.setVirtualColumnId(resultColumnList2.size());
            VirtualColumnNode virtualColumnNode = (VirtualColumnNode)this.getNodeFactory().getNode(107, this, resultColumn2, new Integer(resultColumnList2.size()), this.getContextManager());
            ValueNode valueNode = groupByColumn.getColumnExpression();
            SubstituteExpressionVisitor substituteExpressionVisitor = new SubstituteExpressionVisitor(valueNode, virtualColumnNode, class$org$apache$derby$impl$sql$compile$AggregateNode == null ? GroupByNode.class$("org.apache.derby.impl.sql.compile.AggregateNode") : class$org$apache$derby$impl$sql$compile$AggregateNode);
            arrayList.add(substituteExpressionVisitor);
            if (this.havingClause != null) {
                SubstituteExpressionVisitor substituteExpressionVisitor2 = new SubstituteExpressionVisitor(valueNode, virtualColumnNode, null);
                arrayList2.add(substituteExpressionVisitor2);
            }
            groupByColumn.setColumnPosition(resultColumnList.size());
        }
        ExpressionSorter expressionSorter = new ExpressionSorter();
        Collections.sort(arrayList, expressionSorter);
        for (int i = 0; i < arrayList.size(); ++i) {
            this.parent.getResultColumns().accept((SubstituteExpressionVisitor)arrayList.get(i));
        }
        if (arrayList2 != null) {
            Collections.sort(arrayList2, expressionSorter);
        }
        return arrayList2;
    }

    private void addNewColumnsForAggregation() throws StandardException {
        this.aggInfo = new AggregatorInfoList();
        ArrayList arrayList = null;
        if (this.groupingList != null) {
            arrayList = this.addUnAggColumns();
        }
        this.addAggregateColumns();
        if (this.havingClause != null) {
            if (arrayList != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.havingClause.accept((SubstituteExpressionVisitor)arrayList.get(i));
                }
            }
            CollectNodesVisitor collectNodesVisitor = new CollectNodesVisitor(ColumnReference.class, AggregateNode.class);
            this.havingClause.accept(collectNodesVisitor);
            Iterator iterator = collectNodesVisitor.getList().iterator();
            while (iterator.hasNext()) {
                ColumnReference columnReference = (ColumnReference)iterator.next();
                if (columnReference.getGeneratedToReplaceAggregate() || columnReference.getGeneratedToReplaceWindowFunctionCall() || columnReference.getSourceLevel() != this.level) continue;
                throw StandardException.newException("42X24", columnReference.getSQLColumnName());
            }
        }
    }

    private void addAggregateColumns() throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        AggregateNode aggregateNode = null;
        ResultColumnList resultColumnList = this.childResult.getResultColumns();
        ResultColumnList resultColumnList2 = this.resultColumns;
        LanguageFactory languageFactory = this.getLanguageConnectionContext().getLanguageFactory();
        ReplaceAggregatesWithCRVisitor replaceAggregatesWithCRVisitor = new ReplaceAggregatesWithCRVisitor((ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager()), ((FromTable)this.childResult).getTableNumber(), ResultSetNode.class);
        this.parent.getResultColumns().accept(replaceAggregatesWithCRVisitor);
        if (this.havingClause != null) {
            replaceAggregatesWithCRVisitor = new ReplaceAggregatesWithCRVisitor((ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager()), ((FromTable)this.childResult).getTableNumber());
            this.havingClause.accept(replaceAggregatesWithCRVisitor);
            ProjectRestrictNode projectRestrictNode = (ProjectRestrictNode)this.parent;
            projectRestrictNode.setRestriction(this.havingClause);
        }
        int n = this.aggregateVector.size();
        for (int i = 0; i < n; ++i) {
            aggregateNode = (AggregateNode)this.aggregateVector.get(i);
            ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, "##aggregate result", aggregateNode.getNewNullResultExpression(), this.getContextManager());
            resultColumn.markGenerated();
            resultColumn.bindResultColumnToExpression();
            resultColumnList.addElement(resultColumn);
            resultColumn.setVirtualColumnId(resultColumnList.size());
            int n2 = resultColumn.getVirtualColumnId();
            ColumnReference columnReference = (ColumnReference)this.getNodeFactory().getNode(62, resultColumn.getName(), null, this.getContextManager());
            columnReference.setSource(resultColumn);
            columnReference.setNestingLevel(this.getLevel());
            columnReference.setSourceLevel(this.getLevel());
            ResultColumn resultColumn2 = (ResultColumn)this.getNodeFactory().getNode(80, resultColumn.getColumnName(), columnReference, this.getContextManager());
            resultColumn2.markGenerated();
            resultColumn2.bindResultColumnToExpression();
            resultColumnList2.addElement(resultColumn2);
            resultColumn2.setVirtualColumnId(resultColumnList2.size());
            columnReference = aggregateNode.getGeneratedRef();
            columnReference.setSource(resultColumn2);
            resultColumn = aggregateNode.getNewExpressionResultColumn(dataDictionary);
            resultColumn.markGenerated();
            resultColumn.bindResultColumnToExpression();
            resultColumnList.addElement(resultColumn);
            resultColumn.setVirtualColumnId(resultColumnList.size());
            int n3 = resultColumn.getVirtualColumnId();
            ResultColumn resultColumn3 = resultColumn;
            resultColumn2 = this.getColumnReference(resultColumn, dataDictionary);
            resultColumnList2.addElement(resultColumn2);
            resultColumn2.setVirtualColumnId(resultColumnList2.size());
            resultColumn = aggregateNode.getNewAggregatorResultColumn(dataDictionary);
            resultColumn.markGenerated();
            resultColumn.bindResultColumnToExpression();
            resultColumnList.addElement(resultColumn);
            resultColumn.setVirtualColumnId(resultColumnList.size());
            int n4 = resultColumn.getVirtualColumnId();
            resultColumn2 = this.getColumnReference(resultColumn, dataDictionary);
            resultColumnList2.addElement(resultColumn2);
            resultColumn2.setVirtualColumnId(resultColumnList2.size());
            ResultColumnList resultColumnList3 = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
            resultColumnList3.addElement(resultColumn3);
            this.aggInfo.addElement(new AggregatorInfo(aggregateNode.getAggregateName(), aggregateNode.getAggregatorClassName(), n3 - 1, n2 - 1, n4 - 1, aggregateNode.isDistinct(), languageFactory.getResultDescription(resultColumnList3.makeResultDescriptors(), "SELECT")));
        }
    }

    public FromTable getParent() {
        return this.parent;
    }

    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList optimizablePredicateList, CostEstimate costEstimate, RowOrdering rowOrdering) throws StandardException {
        CostEstimate costEstimate2 = ((Optimizable)((Object)this.childResult)).optimizeIt(optimizer, optimizablePredicateList, costEstimate, rowOrdering);
        CostEstimate costEstimate3 = super.optimizeIt(optimizer, optimizablePredicateList, costEstimate, rowOrdering);
        return costEstimate3;
    }

    public CostEstimate estimateCost(OptimizablePredicateList optimizablePredicateList, ConglomerateDescriptor conglomerateDescriptor, CostEstimate costEstimate, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        CostEstimate costEstimate2 = ((Optimizable)((Object)this.childResult)).estimateCost(optimizablePredicateList, conglomerateDescriptor, costEstimate, optimizer, rowOrdering);
        CostEstimate costEstimate3 = this.getCostEstimate(optimizer);
        costEstimate3.setCost(costEstimate2.getEstimatedCost(), costEstimate2.rowCount(), costEstimate2.singleScanRowCount());
        return costEstimate3;
    }

    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        return ((Optimizable)((Object)this.childResult)).pushOptPredicate(optimizablePredicate);
    }

    public String toString() {
        return "";
    }

    public void printSubNodes(int n) {
    }

    public boolean flattenableInFromSubquery(FromList fromList) {
        return false;
    }

    public ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicateList, double d) throws StandardException {
        this.childResult = (FromTable)this.childResult.optimize(dataDictionary, predicateList, d);
        Optimizer optimizer = this.getOptimizer((FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()), predicateList, dataDictionary, null);
        this.costEstimate = optimizer.newCostEstimate();
        this.costEstimate.setCost(this.childResult.getCostEstimate().getEstimatedCost(), this.childResult.getCostEstimate().rowCount(), this.childResult.getCostEstimate().singleScanRowCount());
        return this;
    }

    ResultColumnDescriptor[] makeResultDescriptors() {
        return this.childResult.makeResultDescriptors();
    }

    public boolean isOneRowResultSet() throws StandardException {
        return this.groupingList == null || this.groupingList.size() == 0;
    }

    public void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n = 0;
        int n2 = 0;
        this.assignResultSetNumber();
        this.costEstimate = this.childResult.getFinalCostEstimate();
        FormatableArrayHolder formatableArrayHolder = activationClassBuilder.getColumnOrdering(this.groupingList);
        if (this.addDistinctAggregate) {
            formatableArrayHolder = activationClassBuilder.addColumnToOrdering(formatableArrayHolder, this.addDistinctAggregateColumnNum);
        }
        n = activationClassBuilder.addItem(formatableArrayHolder);
        n2 = activationClassBuilder.addItem(this.aggInfo);
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        this.childResult.generate(activationClassBuilder, methodBuilder);
        methodBuilder.push(this.isInSortedOrder);
        methodBuilder.push(n2);
        methodBuilder.push(n);
        this.resultColumns.generateHolder(activationClassBuilder, methodBuilder);
        methodBuilder.push(this.resultColumns.getTotalColumnSize());
        methodBuilder.push(this.resultSetNumber);
        if (this.groupingList == null || this.groupingList.size() == 0) {
            this.genScalarAggregateResultSet(activationClassBuilder, methodBuilder);
        } else {
            this.genGroupedAggregateResultSet(activationClassBuilder, methodBuilder);
        }
    }

    private void genScalarAggregateResultSet(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) {
        String string = this.addDistinctAggregate ? "getDistinctScalarAggregateResultSet" : "getScalarAggregateResultSet";
        methodBuilder.push(this.singleInputRowOptimization);
        methodBuilder.push(this.costEstimate.rowCount());
        methodBuilder.push(this.costEstimate.getEstimatedCost());
        methodBuilder.callMethod((short)185, null, string, "org.apache.derby.iapi.sql.execute.NoPutResultSet", 10);
    }

    private void genGroupedAggregateResultSet(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        String string = this.addDistinctAggregate ? "getDistinctGroupedAggregateResultSet" : "getGroupedAggregateResultSet";
        methodBuilder.push(this.costEstimate.rowCount());
        methodBuilder.push(this.costEstimate.getEstimatedCost());
        methodBuilder.push(this.groupingList.isRollup());
        methodBuilder.callMethod((short)185, null, string, "org.apache.derby.iapi.sql.execute.NoPutResultSet", 10);
    }

    private ResultColumn getColumnReference(ResultColumn resultColumn, DataDictionary dataDictionary) throws StandardException {
        ColumnReference columnReference = (ColumnReference)this.getNodeFactory().getNode(62, resultColumn.getName(), null, this.getContextManager());
        columnReference.setSource(resultColumn);
        columnReference.setNestingLevel(this.getLevel());
        columnReference.setSourceLevel(this.getLevel());
        ResultColumn resultColumn2 = (ResultColumn)this.getNodeFactory().getNode(80, resultColumn.getColumnName(), columnReference, this.getContextManager());
        resultColumn2.markGenerated();
        resultColumn2.bindResultColumnToExpression();
        return resultColumn2;
    }

    void considerPostOptimizeOptimizations(boolean bl) throws StandardException {
        AggregateNode aggregateNode;
        AggregateDefinition aggregateDefinition;
        if (this.groupingList == null && this.aggregateVector.size() == 1 && (aggregateDefinition = (aggregateNode = (AggregateNode)this.aggregateVector.get(0)).getAggregateDefinition()) instanceof MaxMinAggregateDefinition) {
            if (aggregateNode.getOperand() instanceof ColumnReference) {
                Vector vector;
                ColumnReference[] columnReferenceArray = new ColumnReference[]{(ColumnReference)aggregateNode.getOperand()};
                boolean bl2 = this.isOrderedOn(columnReferenceArray, false, vector = new Vector());
                if (bl2) {
                    boolean bl3 = true;
                    int n = columnReferenceArray[0].getColumnNumber();
                    AccessPath accessPath = this.getTrulyTheBestAccessPath();
                    if (accessPath == null || accessPath.getConglomerateDescriptor() == null || accessPath.getConglomerateDescriptor().getIndexDescriptor() == null) {
                        return;
                    }
                    IndexRowGenerator indexRowGenerator = accessPath.getConglomerateDescriptor().getIndexDescriptor();
                    int[] nArray = indexRowGenerator.baseColumnPositions();
                    boolean[] blArray = indexRowGenerator.isAscending();
                    for (int i = 0; i < nArray.length; ++i) {
                        if (n != nArray[i]) continue;
                        if (blArray[i]) break;
                        bl3 = false;
                        break;
                    }
                    FromBaseTable fromBaseTable = (FromBaseTable)vector.firstElement();
                    MaxMinAggregateDefinition maxMinAggregateDefinition = (MaxMinAggregateDefinition)aggregateDefinition;
                    if (!maxMinAggregateDefinition.isMax() && bl3 || maxMinAggregateDefinition.isMax() && !bl3) {
                        fromBaseTable.disableBulkFetch();
                        this.singleInputRowOptimization = true;
                    } else if (!bl && (maxMinAggregateDefinition.isMax() && bl3 || !maxMinAggregateDefinition.isMax() && !bl3)) {
                        fromBaseTable.disableBulkFetch();
                        fromBaseTable.doSpecialMaxScan();
                        this.singleInputRowOptimization = true;
                    }
                }
            } else if (aggregateNode.getOperand() instanceof ConstantNode) {
                this.singleInputRowOptimization = true;
            }
        }
    }

    private static final class ExpressionSorter
    implements Comparator {
        private ExpressionSorter() {
        }

        public int compare(Object object, Object object2) {
            try {
                ValueNode valueNode = ((SubstituteExpressionVisitor)object).getSource();
                ValueNode valueNode2 = ((SubstituteExpressionVisitor)object2).getSource();
                CollectNodesVisitor collectNodesVisitor = new CollectNodesVisitor(class$org$apache$derby$impl$sql$compile$ColumnReference == null ? (class$org$apache$derby$impl$sql$compile$ColumnReference = GroupByNode.class$("org.apache.derby.impl.sql.compile.ColumnReference")) : class$org$apache$derby$impl$sql$compile$ColumnReference);
                valueNode.accept(collectNodesVisitor);
                int n = collectNodesVisitor.getList().size();
                collectNodesVisitor = new CollectNodesVisitor(class$org$apache$derby$impl$sql$compile$ColumnReference == null ? (class$org$apache$derby$impl$sql$compile$ColumnReference = GroupByNode.class$("org.apache.derby.impl.sql.compile.ColumnReference")) : class$org$apache$derby$impl$sql$compile$ColumnReference);
                valueNode2.accept(collectNodesVisitor);
                int n2 = collectNodesVisitor.getList().size();
                return n2 - n;
            }
            catch (StandardException standardException) {
                throw new RuntimeException(standardException);
            }
        }
    }
}

