/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.cache.Cache;
import org.springframework.cache.interceptor.CacheExpressionRootObject;
import org.springframework.cache.interceptor.LazyParamAwareEvaluationContext;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExpressionEvaluator {
    private SpelExpressionParser parser = new SpelExpressionParser();
    private ParameterNameDiscoverer paramNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private Map<String, Expression> conditionCache = new ConcurrentHashMap<String, Expression>();
    private Map<String, Expression> keyCache = new ConcurrentHashMap<String, Expression>();
    private Map<String, Method> targetMethodCache = new ConcurrentHashMap<String, Method>();

    ExpressionEvaluator() {
    }

    public EvaluationContext createEvaluationContext(Collection<Cache> caches, Method method, Object[] args, Object target, Class<?> targetClass) {
        CacheExpressionRootObject rootObject = new CacheExpressionRootObject(caches, method, args, target, targetClass);
        return new LazyParamAwareEvaluationContext(rootObject, this.paramNameDiscoverer, method, args, targetClass, this.targetMethodCache);
    }

    public boolean condition(String conditionExpression, Method method, EvaluationContext evalContext) {
        String key = this.toString(method, conditionExpression);
        Expression condExp = this.conditionCache.get(key);
        if (condExp == null) {
            condExp = this.parser.parseExpression(conditionExpression);
            this.conditionCache.put(key, condExp);
        }
        return (Boolean)condExp.getValue(evalContext, Boolean.TYPE);
    }

    public Object key(String keyExpression, Method method, EvaluationContext evalContext) {
        String key = this.toString(method, keyExpression);
        Expression keyExp = this.keyCache.get(key);
        if (keyExp == null) {
            keyExp = this.parser.parseExpression(keyExpression);
            this.keyCache.put(key, keyExp);
        }
        return keyExp.getValue(evalContext);
    }

    private String toString(Method method, String expression) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getDeclaringClass().getName());
        sb.append("#");
        sb.append(method.toString());
        sb.append("#");
        sb.append(expression);
        return sb.toString();
    }
}

