/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.List;

public class ProxyInterfaceResolver {
    public static List<Class> getInterfaces(Class implementation, Class mainInterface, List<Class> interfaces) {
        ArrayList<Class> valid = new ArrayList<Class>();
        if (mainInterface != null) {
            valid.add(mainInterface);
        }
        for (Class interfce : interfaces) {
            if (!interfce.isAssignableFrom(implementation)) continue;
            valid.add(interfce);
        }
        ArrayList<Class> remotes = new ArrayList<Class>();
        ArrayList<Class> nonremotes = new ArrayList<Class>();
        for (Class interfce : valid) {
            if (Remote.class.isAssignableFrom(interfce)) {
                remotes.add(interfce);
                continue;
            }
            nonremotes.add(interfce);
        }
        if (remotes.size() == 0) {
            return valid;
        }
        valid.clear();
        remotes.remove(mainInterface);
        nonremotes.remove(mainInterface);
        valid.add(mainInterface);
        List<Signature> proxySignatures = ProxyInterfaceResolver.getSignatures(mainInterface);
        if (Remote.class.isAssignableFrom(mainInterface)) {
            for (Class interfce : remotes) {
                ProxyInterfaceResolver.addIfNotConflicting(interfce, valid, proxySignatures);
            }
            for (Class interfce : nonremotes) {
                ProxyInterfaceResolver.addIfNotConflicting(interfce, valid, proxySignatures);
            }
        } else {
            for (Class interfce : nonremotes) {
                ProxyInterfaceResolver.addIfNotConflicting(interfce, valid, proxySignatures);
            }
            for (Class interfce : remotes) {
                ProxyInterfaceResolver.addIfNotConflicting(interfce, valid, proxySignatures);
            }
        }
        return valid;
    }

    private static void addIfNotConflicting(Class interfce, List<Class> valid, List<Signature> proxySignatures) {
        List<Signature> interfaceSigs = ProxyInterfaceResolver.getSignatures(interfce);
        for (Signature sig : interfaceSigs) {
            if (!proxySignatures.contains(sig)) continue;
            return;
        }
        valid.add(interfce);
        proxySignatures.addAll(interfaceSigs);
    }

    private static List<Signature> getSignatures(Class mainInterface) {
        ArrayList<Signature> sigs = new ArrayList<Signature>();
        for (Method method : mainInterface.getMethods()) {
            sigs.add(new Signature(mainInterface, method));
        }
        return sigs;
    }

    public static class Signature {
        private final Class clazz;
        private final Method method;
        private final String sig;

        public Signature(Class clazz, Method method) {
            this.clazz = clazz;
            this.method = method;
            StringBuilder sb = new StringBuilder();
            sb.append(method.getName());
            sb.append('(');
            for (Class<?> type : method.getParameterTypes()) {
                sb.append(type.getName());
                sb.append(',');
            }
            sb.append(')');
            this.sig = sb.toString();
        }

        public Method getMethod() {
            return this.method;
        }

        public boolean equals(Object o) {
            boolean bIsRemote;
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Signature signature = (Signature)o;
            if (!this.sig.equals(signature.sig)) {
                return false;
            }
            boolean aIsRemote = Remote.class.isAssignableFrom(this.clazz);
            return aIsRemote != (bIsRemote = Remote.class.isAssignableFrom(signature.clazz));
        }

        public int hashCode() {
            return this.sig.hashCode();
        }

        public String toString() {
            return this.method.toString();
        }
    }
}

