/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.blueprint.extender.internal.blueprint.activator;

import org.eclipse.gemini.blueprint.context.event.OsgiBundleApplicationContextListener;
import org.eclipse.gemini.blueprint.extender.OsgiApplicationContextCreator;
import org.eclipse.gemini.blueprint.extender.internal.activator.ApplicationContextConfigurationFactory;
import org.eclipse.gemini.blueprint.extender.internal.activator.ContextLoaderListener;
import org.eclipse.gemini.blueprint.extender.internal.activator.ListenerServiceActivator;
import org.eclipse.gemini.blueprint.extender.internal.activator.OsgiContextProcessor;
import org.eclipse.gemini.blueprint.extender.internal.activator.TypeCompatibilityChecker;
import org.eclipse.gemini.blueprint.extender.internal.blueprint.activator.BlueprintContainerProcessor;
import org.eclipse.gemini.blueprint.extender.internal.blueprint.activator.BlueprintListenerManager;
import org.eclipse.gemini.blueprint.extender.internal.blueprint.activator.BlueprintTypeCompatibilityChecker;
import org.eclipse.gemini.blueprint.extender.internal.blueprint.activator.support.BlueprintContainerConfig;
import org.eclipse.gemini.blueprint.extender.internal.blueprint.activator.support.BlueprintContainerCreator;
import org.eclipse.gemini.blueprint.extender.internal.blueprint.event.EventAdminDispatcher;
import org.eclipse.gemini.blueprint.extender.internal.support.ExtenderConfiguration;
import org.eclipse.gemini.blueprint.extender.support.ApplicationContextConfiguration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class BlueprintLoaderListener
extends ContextLoaderListener {
    private volatile BlueprintListenerManager listenerManager;
    private volatile BlueprintContainerProcessor contextProcessor;
    private volatile TypeCompatibilityChecker typeChecker;
    private ListenerServiceActivator listenerServiceActivator;

    public BlueprintLoaderListener(ExtenderConfiguration extenderConfiguration, ListenerServiceActivator listenerServiceActivator) {
        super(extenderConfiguration);
        this.listenerServiceActivator = listenerServiceActivator;
    }

    public void start(BundleContext context) throws Exception {
        this.listenerManager = new BlueprintListenerManager(context);
        EventAdminDispatcher dispatcher = new EventAdminDispatcher(context);
        Bundle bundle = context.getBundle();
        this.contextProcessor = new BlueprintContainerProcessor(dispatcher, this.listenerManager, bundle);
        this.typeChecker = new BlueprintTypeCompatibilityChecker(bundle);
        this.listenerServiceActivator.getMulticaster().addApplicationListener((OsgiBundleApplicationContextListener)this.contextProcessor);
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.listenerManager.destroy();
    }

    protected ApplicationContextConfigurationFactory createContextConfigFactory() {
        return new ApplicationContextConfigurationFactory(){

            public ApplicationContextConfiguration createConfiguration(Bundle bundle) {
                return new BlueprintContainerConfig(bundle);
            }
        };
    }

    protected OsgiApplicationContextCreator getOsgiApplicationContextCreator() {
        return new BlueprintContainerCreator();
    }

    protected OsgiContextProcessor createContextProcessor() {
        return this.contextProcessor;
    }

    protected TypeCompatibilityChecker getTypeCompatibilityChecker() {
        return this.typeChecker;
    }

    protected String getManagedBundleExtenderVersionHeader() {
        return "BlueprintExtender-Version";
    }
}

