/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.IntermediateInputStream;
import org.apache.tomcat.util.buf.ReadConvertor;
import org.apache.tomcat.util.res.StringManager;

public class B2CConverter {
    private static final Log log = LogFactory.getLog(B2CConverter.class);
    private static final StringManager sm = StringManager.getManager((String)"org.apache.tomcat.util.buf");
    private static final Map<String, Charset> encodingToCharsetCache = new HashMap<String, Charset>();
    public static final Charset ISO_8859_1;
    public static final Charset UTF_8;
    private IntermediateInputStream iis;
    private ReadConvertor conv;
    private CharsetDecoder decoder;
    private String encoding;
    static final int BUFFER_SIZE = 8192;
    char[] result = new char[8192];

    public static Charset getCharset(String enc) throws UnsupportedEncodingException {
        String lowerCaseEnc = enc.toLowerCase(Locale.US);
        Charset charset = encodingToCharsetCache.get(lowerCaseEnc);
        if (charset == null) {
            throw new UnsupportedEncodingException(sm.getString("b2cConverter.unknownEncoding", new Object[]{enc}));
        }
        return charset;
    }

    @Deprecated
    protected B2CConverter() {
    }

    public B2CConverter(String encoding) throws IOException {
        this.encoding = encoding;
        this.reset();
    }

    public void recycle() {
        this.conv.recycle();
        this.decoder.reset();
    }

    public void convert(ByteChunk bb, CharChunk cb, int limit) throws IOException {
        this.iis.setByteChunk(bb);
        try {
            int bbLengthBeforeRead = 0;
            while (limit > 0) {
                int size = limit < 8192 ? limit : 8192;
                bbLengthBeforeRead = bb.getLength();
                int cnt = this.conv.read(this.result, 0, size);
                if (cnt <= 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"B2CConverter: EOF");
                    }
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("B2CConverter: Converted: " + new String(this.result, 0, cnt)));
                }
                cb.append(this.result, 0, cnt);
                limit -= bbLengthBeforeRead - bb.getLength();
            }
        }
        catch (IOException ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("B2CConverter: Reseting the converter " + ex.toString()));
            }
            this.reset();
            throw ex;
        }
    }

    public void reset() throws IOException {
        this.iis = new IntermediateInputStream();
        this.decoder = B2CConverter.getCharset(this.encoding).newDecoder();
        this.conv = new ReadConvertor(this.iis, this.decoder);
    }

    static {
        for (Charset charset : Charset.availableCharsets().values()) {
            encodingToCharsetCache.put(charset.name().toLowerCase(Locale.US), charset);
            for (String alias : charset.aliases()) {
                encodingToCharsetCache.put(alias.toLowerCase(Locale.US), charset);
            }
        }
        Charset iso88591 = null;
        Charset utf8 = null;
        try {
            iso88591 = B2CConverter.getCharset("ISO-8859-1");
            utf8 = B2CConverter.getCharset("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ISO_8859_1 = iso88591;
        UTF_8 = utf8;
    }
}

