/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.coap.server.templates;

import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;

public class LinkTemplate
implements IFileTemplate<InformationModel> {
    private String targetPath;
    private String classPackage;

    public LinkTemplate(String targetPath, String classPackage) {
        this.targetPath = targetPath;
        this.classPackage = classPackage;
    }

    public String getFileName(InformationModel context) {
        return "Link.java";
    }

    public String getPath(InformationModel context) {
        return this.targetPath;
    }

    public String getContent(InformationModel context, InvocationContext invocationContext) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        _builder.append((Object)this.classPackage, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.californium.core.coap.CoAP;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.californium.core.coap.LinkFormat;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.californium.core.coap.MediaTypeRegistry;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.californium.core.server.resources.CoapExchange;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.californium.core.server.resources.ConcurrentCoapResource;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.californium.core.server.resources.Resource;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import java.util.Collection;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import static org.eclipse.californium.core.coap.MediaTypeRegistry.APPLICATION_LINK_FORMAT;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"public class Link extends ConcurrentCoapResource {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public Link(String name) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"super(name, SINGLE_THREADED);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"getAttributes().addContentType(MediaTypeRegistry.APPLICATION_LINK_FORMAT);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public void handleGET(CoapExchange exchange) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"final Collection<Resource> children = this.getChildren();");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"StringBuilder sb = new StringBuilder();");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"for (Resource child : children) {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"sb.append(LinkFormat.serializeResource(child));");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"exchange.respond(CoAP.ResponseCode.CONTENT, sb.toString(), APPLICATION_LINK_FORMAT);");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }
}

