/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.webui.templates.service.bosch;

import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.webui.templates.TemplateUtils;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;

public class BoschThingsDataServiceTemplate
implements IFileTemplate<InformationModel> {
    public String getFileName(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"BoschThingsDataService.java");
        return _builder.toString();
    }

    public String getPath(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        String _baseApplicationPath = TemplateUtils.getBaseApplicationPath(context);
        _builder.append((Object)_baseApplicationPath, "");
        _builder.append((Object)"/service/bosch");
        return _builder.toString();
    }

    public String getContent(InformationModel element, InvocationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package com.example.iot.");
        String _name = element.getName();
        String _lowerCase = _name.toLowerCase();
        _builder.append((Object)_lowerCase, "");
        _builder.append((Object)".service.bosch;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import java.util.Collections;");
        _builder.newLine();
        _builder.append((Object)"import java.util.List;");
        _builder.newLine();
        _builder.append((Object)"import java.util.Map;");
        _builder.newLine();
        _builder.append((Object)"import java.util.concurrent.CompletableFuture;");
        _builder.newLine();
        _builder.append((Object)"import java.util.function.Function;");
        _builder.newLine();
        _builder.append((Object)"import java.util.stream.Collectors;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.vorto.repository.api.ModelId;");
        _builder.newLine();
        _builder.append((Object)"import org.slf4j.Logger;");
        _builder.newLine();
        _builder.append((Object)"import org.slf4j.LoggerFactory;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import com.bosch.cr.integration.things.ThingIntegration;");
        _builder.newLine();
        _builder.append((Object)"import com.example.iot.");
        String _name_1 = element.getName();
        String _lowerCase_1 = _name_1.toLowerCase();
        _builder.append((Object)_lowerCase_1, "");
        _builder.append((Object)".model.*;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import com.example.iot.");
        String _name_2 = element.getName();
        String _lowerCase_2 = _name_2.toLowerCase();
        _builder.append((Object)_lowerCase_2, "");
        _builder.append((Object)".service.DataService;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import com.example.iot.");
        String _name_3 = element.getName();
        String _lowerCase_3 = _name_3.toLowerCase();
        _builder.append((Object)_lowerCase_3, "");
        _builder.append((Object)".service.Query;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import com.example.iot.");
        String _name_4 = element.getName();
        String _lowerCase_4 = _name_4.toLowerCase();
        _builder.append((Object)_lowerCase_4, "");
        _builder.append((Object)".service.bosch.model.Thing;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import com.example.iot.");
        String _name_5 = element.getName();
        String _lowerCase_5 = _name_5.toLowerCase();
        _builder.append((Object)_lowerCase_5, "");
        _builder.append((Object)".service.bosch.model.ThingSearchResult;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import com.fasterxml.jackson.databind.ObjectMapper;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"public class BoschThingsDataService implements DataService {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static Logger log = LoggerFactory.getLogger(BoschThingsDataService.class);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private ThingIntegration thingsIntegration;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private ThingClient thingClient;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static final String SUBSCRIBER_PREFIX = \"/");
        String _name_6 = element.getName();
        String _lowerCase_6 = _name_6.toLowerCase();
        _builder.append((Object)_lowerCase_6, "\t");
        _builder.append((Object)"/\";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public BoschThingsDataService(ThingClient thingClient, ThingIntegration integrationClient) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.thingClient = thingClient;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.thingsIntegration = integrationClient;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public Query newQuery() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return new ThingsQuery();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public List<");
        String _name_7 = element.getName();
        _builder.append((Object)_name_7, "\t");
        _builder.append((Object)"> queryThings(Query query) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"CompletableFuture<ThingSearchResult> result = thingClient.searchThings(query.getValue());");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return result.get().getThings().stream().map(thingTo");
        String _name_8 = element.getName();
        _builder.append((Object)_name_8, "\t\t\t");
        _builder.append((Object)").collect(Collectors.toList());");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (Exception e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"log.error(\"Problem when searching things\",e);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return Collections.emptyList();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} ");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_9 = element.getName();
        _builder.append((Object)_name_9, "\t");
        _builder.append((Object)" getThing(String thingId) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return thingTo");
        String _name_10 = element.getName();
        _builder.append((Object)_name_10, "\t\t\t");
        _builder.append((Object)".apply(thingClient.getThing(thingId).get());");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (Exception e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"log.error(\"Problem when getting thing details\",e);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void registerAsyncCallback(String thingId, DataCallback callback) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.thingsIntegration.forId(thingId).registerForFeatureChanges(getSubscriberId(thingId), featureChange -> {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"com.bosch.cr.model.things.Thing crThing = thingsIntegration.forId(thingId).retrieve().get();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"Thing thing = Thing.newBuilder().fromThing(crThing).build();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"callback.onChange(thingTo");
        String _name_11 = element.getName();
        _builder.append((Object)_name_11, "\t\t\t\t");
        _builder.append((Object)".apply(thing));");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"} catch (Exception e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"log.error(\"Error while retrieving thing\", e);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"});");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void deregisterAsyncCallback(String thingId) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.thingsIntegration.forId(thingId).deregister(getSubscriberId(thingId));");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private String getSubscriberId(String thingId) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return SUBSCRIBER_PREFIX + thingId;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static Function<Thing, ");
        String _name_12 = element.getName();
        _builder.append((Object)_name_12, "\t");
        _builder.append((Object)"> thingTo");
        String _name_13 = element.getName();
        _builder.append((Object)_name_13, "\t");
        _builder.append((Object)" = (thing) -> {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        String _name_14 = element.getName();
        _builder.append((Object)_name_14, "\t\t");
        _builder.append((Object)" ");
        String _name_15 = element.getName();
        String _lowerCase_7 = _name_15.toLowerCase();
        _builder.append((Object)_lowerCase_7, "\t\t");
        _builder.append((Object)" = new ");
        String _name_16 = element.getName();
        _builder.append((Object)_name_16, "\t\t");
        _builder.append((Object)"(thing.getId(), thing.getName(),");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"ModelId.fromPrettyFormat(thing.getThingTypeId()));");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        String _name_17 = element.getName();
        String _lowerCase_8 = _name_17.toLowerCase();
        _builder.append((Object)_lowerCase_8, "\t\t");
        _builder.append((Object)".setCreatedOn(thing.getCreatedOn());");
        _builder.newLineIfNotEmpty();
        EList _properties = element.getProperties();
        for (FunctionblockProperty fbProperty : _properties) {
            _builder.append((Object)"\t\t");
            String _name_18 = element.getName();
            String _lowerCase_9 = _name_18.toLowerCase();
            _builder.append((Object)_lowerCase_9, "\t\t");
            _builder.append((Object)".set");
            FunctionblockModel _type = fbProperty.getType();
            String _name_19 = _type.getName();
            _builder.append((Object)_name_19, "\t\t");
            _builder.append((Object)"(convert(thing, \"");
            String _name_20 = fbProperty.getName();
            _builder.append((Object)_name_20, "\t\t");
            _builder.append((Object)"\", ");
            FunctionblockModel _type_1 = fbProperty.getType();
            String _name_21 = _type_1.getName();
            _builder.append((Object)_name_21, "\t\t");
            _builder.append((Object)".class));");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ");
        String _name_22 = element.getName();
        String _lowerCase_10 = _name_22.toLowerCase();
        _builder.append((Object)_lowerCase_10, "\t\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static <T> T convert(Thing thing, String propertyName, Class<T> expectedClass) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"Map<String, Object> statusProperty = thing.listFeatures().get(propertyName).getProperties();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"statusProperty.remove(\"_modelId\");");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"final ObjectMapper mapper = new ObjectMapper();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"mapper.setDateFormat(Thing.JSON_DATE_FORMAT);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return mapper.convertValue(statusProperty, expectedClass);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        return _builder.toString();
    }
}

