/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.webui.templates.web;

import java.util.Map;
import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.webui.templates.TemplateUtils;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;

public class ThingMessageControllerTemplate
implements IFileTemplate<InformationModel> {
    public String getFileName(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = context.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"MessageController.java");
        return _builder.toString();
    }

    public String getPath(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        String _baseApplicationPath = TemplateUtils.getBaseApplicationPath(context);
        _builder.append((Object)_baseApplicationPath, "");
        _builder.append((Object)"/web");
        return _builder.toString();
    }

    public String getContent(InformationModel element, InvocationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package com.example.iot.");
        String _name = element.getName();
        String _lowerCase = _name.toLowerCase();
        _builder.append((Object)_lowerCase, "");
        _builder.append((Object)".web;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import org.slf4j.Logger;");
        _builder.newLine();
        _builder.append((Object)"import org.slf4j.LoggerFactory;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.beans.factory.annotation.Autowired;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.messaging.handler.annotation.MessageMapping;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.messaging.simp.SimpMessagingTemplate;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.stereotype.Controller;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import com.example.iot.");
        String _name_1 = element.getName();
        String _lowerCase_1 = _name_1.toLowerCase();
        _builder.append((Object)_lowerCase_1, "");
        _builder.append((Object)".config.WebSocketConfig;");
        _builder.newLineIfNotEmpty();
        Map _configurationProperties = context.getConfigurationProperties();
        String _orDefault = _configurationProperties.getOrDefault("persistence", "false");
        boolean _equalsIgnoreCase = _orDefault.equalsIgnoreCase("true");
        if (_equalsIgnoreCase) {
            _builder.append((Object)"import com.example.iot.");
            String _name_2 = element.getName();
            String _lowerCase_2 = _name_2.toLowerCase();
            _builder.append((Object)_lowerCase_2, "");
            _builder.append((Object)".dao.");
            String _name_3 = element.getName();
            _builder.append((Object)_name_3, "");
            _builder.append((Object)"Repository;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"import com.example.iot.");
        String _name_4 = element.getName();
        String _lowerCase_3 = _name_4.toLowerCase();
        _builder.append((Object)_lowerCase_3, "");
        _builder.append((Object)".model.");
        String _name_5 = element.getName();
        _builder.append((Object)_name_5, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import com.example.iot.");
        String _name_6 = element.getName();
        String _lowerCase_4 = _name_6.toLowerCase();
        _builder.append((Object)_lowerCase_4, "");
        _builder.append((Object)".service.DataService;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import com.example.iot.");
        String _name_7 = element.getName();
        String _lowerCase_5 = _name_7.toLowerCase();
        _builder.append((Object)_lowerCase_5, "");
        _builder.append((Object)".service.DataService.DataCallback;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"@Controller");
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _name_8 = element.getName();
        _builder.append((Object)_name_8, "");
        _builder.append((Object)"MessageController {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private Logger log = LoggerFactory.getLogger(");
        String _name_9 = element.getName();
        _builder.append((Object)_name_9, "\t");
        _builder.append((Object)"MessageController.class);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Autowired");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private SimpMessagingTemplate messagingTemplate;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Autowired");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private DataService dataService;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        Map _configurationProperties_1 = context.getConfigurationProperties();
        String _orDefault_1 = _configurationProperties_1.getOrDefault("persistence", "false");
        boolean _equalsIgnoreCase_1 = _orDefault_1.equalsIgnoreCase("true");
        if (_equalsIgnoreCase_1) {
            _builder.append((Object)"\t");
            _builder.append((Object)"@Autowired");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private ");
            String _name_10 = element.getName();
            _builder.append((Object)_name_10, "\t");
            _builder.append((Object)"Repository crudRepository;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@MessageMapping(WebSocketConfig.ENDPOINT+\"/subscribe\")");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public String subscribe(String thingId) throws Exception {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"log.info(\"Subscribing for thingId : \" + thingId);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"final SimpMessagingTemplate tmp = messagingTemplate;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"dataService.registerAsyncCallback(thingId, new DataCallback() {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"public void onChange(");
        String _name_11 = element.getName();
        _builder.append((Object)_name_11, "\t\t\t\t");
        _builder.append((Object)" thing) {");
        _builder.newLineIfNotEmpty();
        Map _configurationProperties_2 = context.getConfigurationProperties();
        String _orDefault_2 = _configurationProperties_2.getOrDefault("persistence", "false");
        boolean _equalsIgnoreCase_2 = _orDefault_2.equalsIgnoreCase("true");
        if (_equalsIgnoreCase_2) {
            _builder.append((Object)"\t\t\t\t\t");
            _builder.append((Object)"crudRepository.save(thing);");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"tmp.convertAndSend( \"/topic/device/\" + thingId, thing);\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"});");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (Throwable e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"log.error(\"Error while subcribing to device\", e);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return thingId;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@MessageMapping(WebSocketConfig.ENDPOINT+\"/unsubscribe\")");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public String unsubscribe(String thingId) throws Exception {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"log.info(\"Unsubscribing for thingId : \" + thingId);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"dataService.deregisterAsyncCallback(thingId);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (Throwable e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"log.error(\"Error while unsubcribing to thing\", e);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return thingId;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }
}

