/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.tools;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.Type;
import org.eclipse.vorto.core.api.model.functionblock.Event;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.Operation;

public class CodeGenTools {
    private static final String GETTER_PREFIX = "get";
    private static final String SETTER_PREFIX = "set";

    public static boolean isGetter(Operation operation, FunctionBlock fb) {
        return operation.getName().length() >= GETTER_PREFIX.length() && operation.getName().substring(0, GETTER_PREFIX.length()).equalsIgnoreCase(GETTER_PREFIX);
    }

    public static boolean isSetter(Operation operation, FunctionBlock fb) {
        return operation.getName().length() >= SETTER_PREFIX.length() && operation.getName().substring(0, SETTER_PREFIX.length()).equalsIgnoreCase(SETTER_PREFIX);
    }

    public static boolean isReadable(Property property, FunctionBlock fb) {
        String getterName = GETTER_PREFIX + property.getName();
        return CodeGenTools.findOperationByName(getterName, fb) != null;
    }

    public static boolean isWritable(Property property, FunctionBlock fb) {
        String setterName = SETTER_PREFIX + property.getName();
        return CodeGenTools.findOperationByName(setterName, fb) != null;
    }

    public static boolean isEventable(Property property, FunctionBlock fb) {
        return CodeGenTools.findEventByName(property.getName(), fb) != null;
    }

    public static Operation findOperationByName(String operationName, FunctionBlock fb) {
        for (Operation operation : fb.getOperations()) {
            if (!operation.getName().equalsIgnoreCase(operationName)) continue;
            return operation;
        }
        return null;
    }

    public static Event findEventByName(String eventName, FunctionBlock fb) {
        for (Event event : fb.getEvents()) {
            if (!event.getName().equalsIgnoreCase(eventName)) continue;
            return event;
        }
        return null;
    }

    public static EList<Entity> getReferencedEntities(FunctionBlock fb) {
        BasicEList entities = new BasicEList();
        for (Type type : CodeGenTools.getReferencedTypes(fb)) {
            if (!(type instanceof Entity)) continue;
            entities.add((Object)((Entity)type));
        }
        return entities;
    }

    public static EList<Enum> getReferencedEnums(FunctionBlock fb) {
        BasicEList enums = new BasicEList();
        for (Type type : CodeGenTools.getReferencedTypes(fb)) {
            if (!(type instanceof Enum)) continue;
            enums.add((Object)((Enum)type));
        }
        return enums;
    }

    public static EList<Type> getReferencedTypes(Entity entity) {
        BasicEList types = new BasicEList();
        for (Property property : entity.getProperties()) {
            types.addAll(CodeGenTools.getReferencedTypes(property));
        }
        types.add((Object)entity.getSuperType());
        return types;
    }

    public static EList<Type> getReferencedTypes(Property property) {
        BasicEList types = new BasicEList();
        if (property.getType() instanceof ObjectPropertyType) {
            ObjectPropertyType objectType = (ObjectPropertyType)property.getType();
            types.add((Object)objectType.getType());
            if (objectType.getType() instanceof Entity) {
                types.addAll(CodeGenTools.getReferencedTypes((Entity)objectType.getType()));
            }
        }
        return types;
    }

    public static EList<Type> getReferencedTypes(FunctionBlock fb) {
        BasicEList types = new BasicEList();
        if (fb != null) {
            if (fb.getStatus() != null) {
                for (Property property : fb.getStatus().getProperties()) {
                    types.addAll(CodeGenTools.getReferencedTypes(property));
                }
            }
            if (fb.getConfiguration() != null) {
                for (Property property : fb.getConfiguration().getProperties()) {
                    types.addAll(CodeGenTools.getReferencedTypes(property));
                }
            }
            if (fb.getFault() != null) {
                for (Property property : fb.getFault().getProperties()) {
                    types.addAll(CodeGenTools.getReferencedTypes(property));
                }
            }
        }
        return types;
    }
}

