/*******************************************************************************
 * Copyright (c) 2015,2016 Bosch Software Innovations GmbH and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 *   
 * The Eclipse Public License is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * The Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *   
 * Contributors:
 * Bosch Software Innovations GmbH - Please refer to git log
 *******************************************************************************/
package org.eclipse.vorto.codegen.bosch.things.schema.tasks.template;

import org.eclipse.vorto.codegen.api.ITemplate
import org.eclipse.vorto.codegen.api.InvocationContext
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel
import org.eclipse.vorto.core.api.model.functionblock.Operation

class OperationParametersValidationTemplate implements ITemplate<Operation>{
	
	var OperationSingleParameterValidationTemplate operationSingleParameterValidationTemplate;
	
	new(OperationSingleParameterValidationTemplate operationSingleParameterValidationTemplate) {
		this.operationSingleParameterValidationTemplate = operationSingleParameterValidationTemplate;
	}
	
	override getContent(Operation operation,InvocationContext invocationContext) {
		var fbm = operation.eContainer.eContainer as FunctionblockModel;
		var modelId = fbm.namespace + "." + fbm.name + ":" + fbm.version;
		'''
			{
				"$schema": "http://json-schema.org/draft-04/schema#",
				"title": "Operation Parameter Validation",
				"description": "Generated by Vorto Bosch IoT Things Generator from model [«modelId»] for Operation [«operation.name»].",
				"type": "object",
				"properties": {
					«FOR param : operation.params SEPARATOR ', '»
						«operationSingleParameterValidationTemplate.getContent(param,invocationContext)»
					«ENDFOR»
				},
				"required" : [«FOR param : operation.params SEPARATOR ', '»"«param.name»"«ENDFOR»]
				
			}
		'''
	}
}
		