/*******************************************************************************
 * Copyright (c) 2015 Bosch Software Innovations GmbH and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 *   
 * The Eclipse Public License is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * The Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *   
 * Contributors:
 * Bosch Software Innovations GmbH - Please refer to git log
 *******************************************************************************/
package org.eclipse.vorto.codegen.templates.java

import org.eclipse.vorto.codegen.api.ITemplate
import org.eclipse.vorto.core.api.model.datatype.Entity
import org.eclipse.vorto.core.api.model.datatype.Property
import org.eclipse.vorto.codegen.api.InvocationContext

class JavaEntityTemplate implements ITemplate<Entity>{
	
	var String classPackage;
	var ITemplate<Property> fieldTemplate
	var ITemplate<Property> getterTemplate
	var ITemplate<Property> setterTemplate
	
	new(String classPackage, 
		ITemplate<Property> fieldTemplate, 
		ITemplate<Property> getterTemplate, 
		ITemplate<Property> setterTemplate) {
			this.classPackage=classPackage;
			this.fieldTemplate = fieldTemplate;
			this.getterTemplate = getterTemplate;
			this.setterTemplate = setterTemplate;
	}
	
	override getContent(Entity entity,InvocationContext invocationContext) {
		'''
			/*
			*****************************************************************************************
			* The present code has been generated by the Eclipse Vorto Java Code Generator.
			*
			* The basis for the generation was the Entity which is uniquely identified by:
			* Name:			«entity.name»
			* Namespace:	«entity.namespace»
			* Version:		«entity.version»
			*****************************************************************************************
			*/
			
			package «classPackage»;
			
			/**
			* «entity.description»
			*/
			«IF entity.superType != null»
				public class «entity.name.toFirstUpper» extends «entity.superType.name.toFirstUpper» {
			«ELSE»
				public class «entity.name.toFirstUpper» {
			«ENDIF»
			
				«FOR property : entity.properties»
					«fieldTemplate.getContent(property,invocationContext)»
					
				«ENDFOR»
				«FOR property : entity.properties»
					«getterTemplate.getContent(property,invocationContext)»
					
					«setterTemplate.getContent(property,invocationContext)»
					
				«ENDFOR»
			}
		'''
	}
}