/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.webui.templates.config;

import java.util.Map;
import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.webui.templates.TemplateUtils;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;

public class SwaggerConfigurationTemplate
implements IFileTemplate<InformationModel> {
    public String getFileName(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"SwaggerConfiguration.java");
        return _builder.toString();
    }

    public String getPath(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        String _baseApplicationPath = TemplateUtils.getBaseApplicationPath(context);
        _builder.append((Object)_baseApplicationPath, "");
        _builder.append((Object)"/config");
        return _builder.toString();
    }

    public String getContent(InformationModel element, InvocationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package com.example.iot.");
        String _name = element.getName();
        String _lowerCase = _name.toLowerCase();
        _builder.append((Object)_lowerCase, "");
        _builder.append((Object)".config;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import static com.google.common.base.Predicates.or;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import org.springframework.context.annotation.Bean;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.context.annotation.Configuration;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import com.google.common.base.Predicate;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import springfox.documentation.builders.PathSelectors;");
        _builder.newLine();
        _builder.append((Object)"import springfox.documentation.service.ApiInfo;");
        _builder.newLine();
        _builder.append((Object)"import springfox.documentation.spi.DocumentationType;");
        _builder.newLine();
        _builder.append((Object)"import springfox.documentation.spring.web.plugins.Docket;");
        _builder.newLine();
        _builder.append((Object)"import springfox.documentation.swagger2.annotations.EnableSwagger2;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"@EnableSwagger2");
        _builder.newLine();
        _builder.append((Object)"@Configuration");
        _builder.newLine();
        _builder.append((Object)"public class SwaggerConfiguration {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Bean");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public Docket vortoApi() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return new Docket(DocumentationType.SWAGGER_2).apiInfo(apiInfo()).useDefaultResponseMessages(false)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)".select().paths(paths()).build();");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@SuppressWarnings(\"unchecked\")");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private Predicate<String> paths() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return or(\tPathSelectors.regex(\"/rest/devices.*\")");
        Map _configurationProperties = context.getConfigurationProperties();
        String _orDefault = _configurationProperties.getOrDefault("history", "true");
        boolean _equalsIgnoreCase = _orDefault.equalsIgnoreCase("true");
        if (_equalsIgnoreCase) {
            _builder.append((Object)",PathSelectors.regex(\"/rest/history/devices.*\")");
        }
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private ApiInfo apiInfo() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return new ApiInfo(\"");
        String _name_1 = element.getName();
        _builder.append((Object)_name_1, "\t\t");
        _builder.append((Object)"\",");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"\"");
        String _name_2 = element.getName();
        _builder.append((Object)_name_2, "\t\t\t\t");
        _builder.append((Object)" Solution\",");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"\"1.0.0\", \"\", \"Generated by Vorto from ");
        String _namespace = element.getNamespace();
        _builder.append((Object)_namespace, "\t\t\t\t");
        _builder.append((Object)".");
        String _name_3 = element.getName();
        _builder.append((Object)_name_3, "\t\t\t\t");
        _builder.append((Object)":");
        String _version = element.getVersion();
        _builder.append((Object)_version, "\t\t\t\t");
        _builder.append((Object)"\", \"Bosch-SI\", \"\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }
}

