/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.webui.templates.config;

import java.util.Map;
import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.webui.templates.TemplateUtils;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;

public class WebSecurityConfigTemplate
implements IFileTemplate<InformationModel> {
    public String getFileName(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"WebSecurityConfig.java");
        return _builder.toString();
    }

    public String getPath(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        String _baseApplicationPath = TemplateUtils.getBaseApplicationPath(context);
        _builder.append((Object)_baseApplicationPath, "");
        _builder.append((Object)"/config");
        return _builder.toString();
    }

    public String getContent(InformationModel element, InvocationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package com.example.iot.");
        String _name = element.getName();
        String _lowerCase = _name.toLowerCase();
        _builder.append((Object)_lowerCase, "");
        _builder.append((Object)".config;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import java.util.Arrays;");
        _builder.newLine();
        _builder.append((Object)"import java.util.Optional;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import javax.servlet.Filter;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import org.springframework.beans.factory.annotation.Autowired;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.beans.factory.annotation.Value;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoTokenServices;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.boot.context.properties.ConfigurationProperties;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.boot.web.servlet.FilterRegistrationBean;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.context.annotation.Bean;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.context.annotation.Configuration;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.core.annotation.Order;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.security.config.annotation.web.builders.HttpSecurity;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.security.config.annotation.web.builders.WebSecurity;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.security.oauth2.client.OAuth2ClientContext;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.security.oauth2.client.OAuth2RestTemplate;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.security.oauth2.client.filter.OAuth2ClientAuthenticationProcessingFilter;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.security.oauth2.client.filter.OAuth2ClientContextFilter;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.security.oauth2.client.token.AccessTokenProvider;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.security.oauth2.config.annotation.web.configuration.EnableOAuth2Client;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.security.web.util.matcher.AntPathRequestMatcher;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.web.filter.CompositeFilter;");
        _builder.newLine();
        _builder.newLine();
        Map _configurationProperties = context.getConfigurationProperties();
        String _orDefault = _configurationProperties.getOrDefault("boschcloud", "false");
        boolean _equalsIgnoreCase = _orDefault.equalsIgnoreCase("true");
        if (_equalsIgnoreCase) {
            _builder.append((Object)"import com.example.iot.");
            String _name_1 = element.getName();
            String _lowerCase_1 = _name_1.toLowerCase();
            _builder.append((Object)_lowerCase_1, "");
            _builder.append((Object)".service.bosch.permissions.IM3AuthenticationProvider;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"@Configuration");
        _builder.newLine();
        _builder.append((Object)"@EnableWebSecurity");
        _builder.newLine();
        _builder.append((Object)"@EnableOAuth2Client");
        _builder.newLine();
        _builder.append((Object)"@Order(6)");
        _builder.newLine();
        _builder.append((Object)"public class WebSecurityConfig extends WebSecurityConfigurerAdapter {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        Map _configurationProperties_1 = context.getConfigurationProperties();
        String _orDefault_1 = _configurationProperties_1.getOrDefault("boschcloud", "false");
        boolean _equalsIgnoreCase_1 = _orDefault_1.equalsIgnoreCase("true");
        if (_equalsIgnoreCase_1) {
            _builder.append((Object)"\t");
            _builder.append((Object)"@Value(\"${bosch.permissions.clientId}\")");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private String clientId;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"@Value(\"${bosch.permissions.clientSecret}\")");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private String clientSecret;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"@Value(\"${bosch.permissions.endpointUrl}\")");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private String endpointUrl;");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Autowired");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private OAuth2ClientContext oauth2ClientContext;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Autowired");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private AuthorizationCodeResourceDetails google;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Value(\"${google.oauth2.resource.userInfoUri}\")");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private String googleUserInfoUri;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void configure(WebSecurity web) throws Exception {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"web.ignoring().antMatchers(\"/webjars/**\",\"/css/**\",\"/js/**\",\"/dist/**\");");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"protected void configure(HttpSecurity http) throws Exception {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"http.authorizeRequests().antMatchers(\"/rest/identities/user/**\",\"/rest/devices/**\").authenticated().and().logout()");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)".logoutRequestMatcher(new AntPathRequestMatcher(\"/logout\")).logoutSuccessUrl(\"/index.html\");");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"http.addFilterAt(ssoFilter(), BasicAuthenticationFilter.class);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"http.formLogin().loginPage(\"/login\");");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"http.csrf().disable();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private Filter ssoFilter() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"CompositeFilter filter = new CompositeFilter();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"filter.setFilters(Arrays.asList(googleFilter()));");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return filter;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private Filter googleFilter() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"UserInfoTokenServices tokenService = new UserInfoTokenServices(googleUserInfoUri, google.getClientId());");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return newSsoFilter(\"/google/login\", google, tokenService, Optional.empty(), ");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"new OAuth2RestTemplate(google, oauth2ClientContext));\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private Filter newSsoFilter(String defaultFilterProcessesUrl, OAuth2ProtectedResourceDetails resource, ");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"UserInfoTokenServices tokenService, Optional<AccessTokenProvider> accessTokenProvider,");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"OAuth2RestTemplate restTemplate) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"accessTokenProvider.ifPresent(provider -> restTemplate.setAccessTokenProvider(provider));");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"OAuth2ClientAuthenticationProcessingFilter filter = new OAuth2ClientAuthenticationProcessingFilter(defaultFilterProcessesUrl);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"tokenService.setRestTemplate(restTemplate);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"filter.setRestTemplate(restTemplate);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"filter.setTokenServices(tokenService);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return filter;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        Map _configurationProperties_2 = context.getConfigurationProperties();
        String _orDefault_2 = _configurationProperties_2.getOrDefault("boschcloud", "false");
        boolean _equalsIgnoreCase_2 = _orDefault_2.equalsIgnoreCase("true");
        if (_equalsIgnoreCase_2) {
            _builder.append((Object)"\t");
            _builder.append((Object)"@Autowired");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"auth.authenticationProvider(authenticationProvider());");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"@Bean");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public IM3AuthenticationProvider authenticationProvider() {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"IM3AuthenticationProvider auth = new IM3AuthenticationProvider();");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"auth.setClientId(clientId);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"auth.setClientSecret(clientSecret);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"auth.setServiceUrl(endpointUrl);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return auth;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Bean");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public FilterRegistrationBean oauth2ClientFilterRegistration(OAuth2ClientContextFilter filter) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"FilterRegistrationBean registration = new FilterRegistrationBean();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"registration.setFilter(filter);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"registration.setOrder(-100);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return registration;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Bean");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@ConfigurationProperties(\"google.oauth2.client\")");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public AuthorizationCodeResourceDetails google() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return new AuthorizationCodeResourceDetails();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }
}

