/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.core.ui.model;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.vorto.core.ui.model.IModelElement;
import org.eclipse.vorto.core.ui.model.IModelProject;
import org.eclipse.vorto.core.ui.model.ModelParserFactory;
import org.eclipse.vorto.core.ui.model.VortoModelProject;

public class ModelProjectFactory {
    private static ModelProjectFactory singleton = null;

    private ModelProjectFactory() {
    }

    public static ModelProjectFactory getInstance() {
        if (singleton == null) {
            singleton = new ModelProjectFactory();
        }
        return singleton;
    }

    public IModelProject getProject(IProject project) {
        if (VortoModelProject.isVortoModelProject(project)) {
            return new VortoModelProject(project, ModelParserFactory.getInstance().getModelParser());
        }
        throw new IllegalArgumentException("Project is not a valid Vorto Model Project");
    }

    public IModelProject getProjectByName(String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null) {
            throw new IllegalArgumentException("Project with name " + projectName + " is closed or does not exist");
        }
        return this.getProject(project);
    }

    public IModelElement getModelElementFromSelection() {
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
            ISelectionService selectionService = activeWorkbenchWindow.getSelectionService();
            ISelection selection = null;
            selection = selectionService.getSelection();
            if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
                return null;
            }
            return this.getModelElementSelection((IStructuredSelection)selection);
        }
        return null;
    }

    private IModelElement getModelElementSelection(IStructuredSelection selection) {
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof IModelElement) {
            IModelElement modelElement = (IModelElement)firstElement;
            modelElement.reload();
            return modelElement;
        }
        throw new IllegalStateException("Could not retrieve Model Project from selection");
    }
}

