/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.editor.functionblock.tests.formatter;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.impl.FunctionblockPackageImpl;
import org.eclipse.vorto.editor.functionblock.tests.FunctionblockInjectorProvider;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.formatting.INodeModelFormatter;
import org.eclipse.xtext.junit4.AbstractXtextTests;
import org.eclipse.xtext.junit4.InjectWith;
import org.eclipse.xtext.junit4.XtextRunner;
import org.eclipse.xtext.junit4.util.ParseHelper;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=XtextRunner.class)
@InjectWith(value=FunctionblockInjectorProvider.class)
public class FunctionblockModelFormatterTest
extends AbstractXtextTests {
    @Inject
    @Extension
    private ParseHelper<FunctionblockModel> parserHelper;
    @Inject
    @Extension
    private INodeModelFormatter formatter;

    @BeforeClass
    public static void initializeModel() {
        FunctionblockPackageImpl.init();
    }

    @Test
    public void testFormattingForBasicBlock() {
        String expectedText = this.getFormatted();
        String rawText = this.getUnFormatted();
        this.assertFormattedAs(rawText, expectedText);
    }

    public String getFormatted() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"namespace org.eclipse.vorto.example");
        _builder.newLine();
        _builder.append((Object)"version 1.0.0");
        _builder.newLine();
        _builder.append((Object)"displayname \"BinarySwitch\"");
        _builder.newLine();
        _builder.append((Object)"description \"Function block model for BinarySwitch\"");
        _builder.newLine();
        _builder.append((Object)"category example");
        _builder.newLine();
        _builder.append((Object)"using eclipse.vorto.type.OnOff ; 1.0.0");
        _builder.newLine();
        _builder.append((Object)"using eclipse.vorto.type.OnOffUnit ; 1.0.0");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"functionblock BinarySwitch {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"status {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"mandatory currentStatus as OnOff");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"operations {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"on()");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"off()");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"toggle()");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"setStatus(targetStatus as OnOffUnit) returns OnOff");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"}");
        return _builder.toString();
    }

    public String getUnFormatted() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"namespace org.eclipse.vorto.example version 1.0.0 ");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"displayname \"BinarySwitch\" description \"Function block model for BinarySwitch\" category example");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"using eclipse.vorto.type.OnOff ; 1.0.0 using eclipse.vorto.type.OnOffUnit ; 1.0.0 functionblock BinarySwitch {\tstatus { mandatory currentStatus as OnOff} operations {\ton()\toff() toggle() setStatus(targetStatus as OnOffUnit) returns OnOff}}");
        return _builder.toString();
    }

    public void assertFormattedAs(CharSequence input, CharSequence expected) {
        try {
            String expectedText = expected.toString();
            FunctionblockModel _parse = (FunctionblockModel)this.parserHelper.parse(input);
            Resource _eResource = _parse.eResource();
            IParseResult _parseResult = ((XtextResource)_eResource).getParseResult();
            ICompositeNode _rootNode = _parseResult.getRootNode();
            int _length = input.length();
            INodeModelFormatter.IFormattedRegion _format = this.formatter.format(_rootNode, 0, _length);
            String formattedText = _format.getFormattedText();
            Assert.assertEquals((Object)expectedText, (Object)formattedText);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

